/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.browserlaunchers;

import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.browserlaunchers.Sleeper;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.IOUtils;
import org.openqa.selenium.net.Urls;

public class LauncherUtils {
    static Logger log = Logger.getLogger(LauncherUtils.class.getName());
    static final Pattern JAVA_STYLE_UNC_URL = Pattern.compile("^file:////([^/]+/.*)$");

    public static File createCustomProfileDir(String sessionId) {
        File customProfileDir = LauncherUtils.customProfileDir(sessionId);
        if (customProfileDir.exists()) {
            FileHandler.delete(customProfileDir);
        }
        customProfileDir.mkdirs();
        return customProfileDir;
    }

    public static File customProfileDir(String sessionId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String customProfileDirParent = tmpDir.exists() && tmpDir.isDirectory() ? tmpDir.getAbsolutePath() : ".";
        File customProfileDir = new File(customProfileDirParent + "/customProfileDir" + sessionId);
        return customProfileDir;
    }

    public static void deleteTryTryAgain(File dir, int tries) {
        try {
            FileHandler.delete(dir);
        }
        catch (RuntimeException e) {
            if (tries > 0) {
                Sleeper.sleepTight(2000L);
                LauncherUtils.deleteTryTryAgain(dir, tries - 1);
            }
            throw e;
        }
    }

    public static String getQueryString(String url) {
        try {
            String query = new URL(url).getQuery();
            return query == null ? "" : query;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDefaultHTMLSuiteUrl(String browserURL, String suiteUrl, boolean multiWindow, int serverPort) {
        String url = Urls.toProtocolHostAndPort(browserURL);
        String resultsUrl = serverPort == 0 ? "../postResults" : "http://localhost:" + serverPort + "/selenium-server/postResults";
        return url + "/selenium-server/core/TestRunner.html?auto=true" + "&multiWindow=" + multiWindow + "&defaultLogLevel=info" + "&baseUrl=" + Urls.urlEncode(browserURL) + "&resultsUrl=" + resultsUrl + "&test=" + Urls.urlEncode(suiteUrl);
    }

    public static String getDefaultRemoteSessionUrl(String startURL, String sessionId, boolean multiWindow, int serverPort, boolean browserSideLog) {
        String url = Urls.toProtocolHostAndPort(startURL);
        url = url + "/selenium-server/core/RemoteRunner.html?sessionId=" + sessionId + "&multiWindow=" + multiWindow + "&baseUrl=" + Urls.urlEncode(startURL) + "&debugMode=" + browserSideLog;
        if (serverPort != 0) {
            url = url + "&driverUrl=http://localhost:" + serverPort + "/selenium-server/driver/";
        }
        return url;
    }

    public static File extractHTAFile(File dir, int port, String resourceFile, String outFile) {
        InputStream input = LauncherUtils.getSeleniumResourceAsStream(resourceFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        File hta = new File(dir, outFile);
        try {
            FileWriter fw = new FileWriter(hta);
            String line = br.readLine();
            fw.write(line);
            fw.write(10);
            fw.write("<base href=\"http://localhost:" + port + "/selenium-server/core/\">");
            while ((line = br.readLine()) != null) {
                fw.write(line);
                fw.write(10);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hta;
    }

    private static InputStream getSeleniumResourceAsStream(String resourceFile) {
        return LauncherUtils.class.getResourceAsStream(resourceFile);
    }

    public static boolean isScriptFile(File aFile) {
        boolean bl;
        FileReader reader;
        char[] firstTwoChars;
        block5: {
            firstTwoChars = new char[2];
            reader = null;
            reader = new FileReader(aFile);
            int charsRead = reader.read(firstTwoChars);
            if (2 == charsRead) break block5;
            boolean bl2 = false;
            IOUtils.closeQuietly(reader);
            return bl2;
        }
        try {
            bl = firstTwoChars[0] == '#' && firstTwoChars[1] == '!';
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        return bl;
    }

    public static void copySingleFile(File sourceFile, File destFile) {
        LauncherUtils.copySingleFileWithOverwrite(sourceFile, destFile, false);
    }

    public static void copySingleFileWithOverwrite(File sourceFile, File destFile, boolean overwrite) {
        if (!sourceFile.exists()) {
            throw new RuntimeException("Source file does not exist: " + sourceFile);
        }
        if (!sourceFile.isFile()) {
            throw new RuntimeException("Source is not a single file: " + sourceFile);
        }
        if (!overwrite && destFile.exists()) {
            throw new RuntimeException("Destination file already exists: " + destFile);
        }
        try {
            FileHandler.copy(sourceFile, destFile);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void copyDirectory(File source, File dest) {
        try {
            FileHandler.copy(source, dest);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected static boolean copyDirectory(File source, String suffix, File dest) {
        try {
            FileHandler.copy(source, dest, suffix);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void generatePacAndPrefJs(File customProfileDir, int port, String homePage, boolean changeMaxConnections, long timeoutInSeconds, Capabilities capabilities) throws FileNotFoundException {
        File prefsJS = new File(customProfileDir, "prefs.js");
        PrintStream out = new PrintStream(new FileOutputStream(prefsJS, true));
        out.println("user_pref('browser.shell.checkDefaultBrowser', false);");
        if (Proxies.isProxyRequired((Capabilities)capabilities)) {
            File proxyPAC = Proxies.makeProxyPAC((File)customProfileDir, (int)port, (Capabilities)capabilities);
            out.println("user_pref('network.proxy.type', 2);");
            out.println("user_pref('network.proxy.autoconfig_url', '" + LauncherUtils.pathToBrowserURL(proxyPAC.getAbsolutePath()) + "');");
        }
        out.println("user_pref('toolkit.networkmanager.disable', true);");
        out.println("user_pref('browser.offline', false);");
        out.println("user_pref('network.http.phishy-userpass-length', 255);");
        out.println("user_pref('browser.allowpopups', true);");
        out.println("user_pref('dom.disable_open_during_load', false);");
        out.println("user_pref('dom.max_script_run_time', " + timeoutInSeconds + ");");
        out.println("user_pref('dom.max_chrome_script_run_time', " + timeoutInSeconds + ");");
        out.println("user_pref('browser.link.open_external', 2);");
        out.println("user_pref('browser.link.open_newwindow', 2);");
        if (homePage != null) {
            out.println("user_pref('startup.homepage_override_url', '" + homePage + "');");
            out.println("user_pref('browser.startup.homepage', '" + homePage + "');");
            out.println("user_pref('startup.homepage_welcome_url', '');");
            out.println("user_pref('browser.startup.page', 1);");
        }
        out.println("user_pref('security.warn_submit_insecure', false);");
        out.println("user_pref('security.warn_submit_insecure.show_once', false);");
        out.println("user_pref('security.warn_entering_secure', false);");
        out.println("user_pref('security.warn_entering_secure.show_once', false);");
        out.println("user_pref('security.warn_entering_weak', false);");
        out.println("user_pref('security.warn_entering_weak.show_once', false);");
        out.println("user_pref('security.warn_leaving_secure', false);");
        out.println("user_pref('security.warn_leaving_secure.show_once', false);");
        out.println("user_pref('security.warn_viewing_mixed', false);");
        out.println("user_pref('security.warn_viewing_mixed.show_once', false);");
        out.println("user_pref('browser.cache.disk.enable', false);");
        out.println("user_pref('browser.cache.memory.enable', true);");
        out.println("user_pref('extensions.autoDisableScopes', 10);");
        out.println("user_pref('signon.rememberSignons', false);");
        out.println("user_pref('browser.EULA.3.accepted', true);");
        out.println("user_pref('browser.EULA.override', true);");
        out.println("user_pref('app.update.auto', false);");
        out.println("user_pref('app.update.enabled', false);");
        out.println("user_pref('extensions.update.enabled', false);");
        out.println("user_pref('browser.search.update', false);");
        out.println("user_pref('extensions.blocklist.enabled', false);");
        out.println("user_pref('browser.safebrowsing.enabled', false);");
        if (changeMaxConnections) {
            out.println("user_pref('network.http.max-connections', 256);");
            out.println("user_pref('network.http.max-connections-per-server', 256);");
            out.println("user_pref('network.http.max-persistent-connections-per-proxy', 256);");
            out.println("user_pref('network.http.max-persistent-connections-per-server', 256);");
        }
        out.close();
    }

    private static String pathToBrowserURL(String path) {
        if (path == null) {
            return null;
        }
        String url = new File(path).toURI().toString();
        Matcher m = JAVA_STYLE_UNC_URL.matcher(url);
        if (m.find()) {
            url = "file://///";
            url = url + m.group(1);
        }
        return url;
    }
}

