/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdio;

import com.typesafe.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Validator;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadMultiLineBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readMultiLine");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadMultiLine(this, config, parent, child, context);
    }

    private static final class ReadMultiLine
    extends AbstractParser {
        private final Matcher regex;
        private final boolean negate;
        private final What what;
        private final Charset charset;

        public ReadMultiLine(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.regex = Pattern.compile(this.getConfigs().getString(config, "regex")).matcher("");
            this.negate = this.getConfigs().getBoolean(config, "negate", false);
            this.charset = this.getConfigs().getCharset(config, "charset", null);
            this.what = (What)new Validator().validateEnum(config, this.getConfigs().getString(config, "what", What.previous.toString()), What.class, new What[0]);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            String line;
            Record template = inputRecord.copy();
            ReadMultiLine.removeAttachments(template);
            template.removeAll("message");
            Charset detectedCharset = this.detectCharset(inputRecord, this.charset);
            InputStreamReader reader = new InputStreamReader(stream, detectedCharset);
            BufferedReader lineReader = new BufferedReader(reader, this.getBufferSize(stream));
            StringBuilder lines = null;
            while ((line = lineReader.readLine()) != null) {
                boolean doPrevious;
                if (lines == null) {
                    lines = new StringBuilder(line);
                    continue;
                }
                boolean isMatch = this.regex.reset(line).matches();
                if (this.negate) {
                    isMatch = !isMatch;
                }
                boolean bl = doPrevious = this.what == What.previous;
                if (!isMatch) {
                    boolean bl2 = doPrevious = !doPrevious;
                }
                if (doPrevious) {
                    lines.append('\n');
                    lines.append(line);
                    continue;
                }
                if (lines.length() > 0 && !this.flushRecord(template.copy(), lines.toString())) {
                    return false;
                }
                lines.setLength(0);
                lines.append(line);
            }
            if (lines != null && lines.length() > 0) {
                return this.flushRecord(template.copy(), lines.toString());
            }
            return true;
        }

        private boolean flushRecord(Record outputRecord, String lines) {
            outputRecord.put("message", lines);
            this.incrementNumRecords();
            return this.getChild().process(outputRecord);
        }

        private static enum What {
            previous,
            next;

        }
    }
}

