/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.pool;

import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.seasar.framework.container.SingletonS2Container;

public class S2PooledObjectFactory<T>
extends BasePooledObjectFactory<T> {
    public String componentName;
    public OnDestroyListener<T> onDestroyListener;

    public T create() throws Exception {
        Object component = SingletonS2Container.getComponent((String)this.componentName);
        return (T)component;
    }

    public PooledObject<T> wrap(T obj) {
        return new DefaultPooledObject(obj);
    }

    public void destroyObject(PooledObject<T> p) throws Exception {
        if (this.onDestroyListener != null) {
            this.onDestroyListener.onDestroy(p);
        }
    }

    public static interface OnDestroyListener<T> {
        public void onDestroy(PooledObject<T> var1);
    }
}

