/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.rule.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.ResponseData;
import org.codelibs.robot.helper.SitemapsHelper;
import org.codelibs.robot.rule.impl.RegexRule;
import org.codelibs.robot.util.ResponseDataUtil;
import org.codelibs.robot.util.TemporaryFileInputStream;
import org.seasar.framework.container.SingletonS2Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SitemapsRule
extends RegexRule {
    private static final Logger logger = LoggerFactory.getLogger(SitemapsRule.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(ResponseData responseData) {
        if (super.match(responseData)) {
            File tempFile = ResponseDataUtil.createResponseBodyFile(responseData);
            try {
                responseData.setResponseBody(new TemporaryFileInputStream(tempFile));
            }
            catch (FileNotFoundException e) {
                throw new RobotSystemException("File does not exists: " + tempFile.getAbsolutePath(), e);
            }
            FileInputStream is = null;
            try {
                SitemapsHelper sitemapsHelper = (SitemapsHelper)SingletonS2Container.getComponent((String)"sitemapsHelper");
                is = new FileInputStream(tempFile);
                boolean bl = sitemapsHelper.isValid(is);
                IOUtils.closeQuietly((InputStream)is);
                return bl;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed a sitemap check: " + responseData, (Throwable)e);
                }
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        return false;
    }
}

