/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.transformer.impl;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.codelibs.robot.Constants;
import org.codelibs.robot.RobotCrawlAccessException;
import org.codelibs.robot.RobotSystemException;
import org.codelibs.robot.entity.AccessResultData;
import org.codelibs.robot.entity.ResponseData;
import org.codelibs.robot.entity.ResultData;
import org.codelibs.robot.extractor.Extractor;
import org.codelibs.robot.extractor.ExtractorFactory;
import org.codelibs.robot.transformer.impl.AbstractTransformer;
import org.seasar.framework.container.SingletonS2Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextTransformer
extends AbstractTransformer {
    private static final Logger logger = LoggerFactory.getLogger(TextTransformer.class);
    protected String charsetName = "UTF-8";

    @Override
    public ResultData transform(ResponseData responseData) {
        if (responseData == null || responseData.getResponseBody() == null) {
            throw new RobotCrawlAccessException("No response body.");
        }
        ExtractorFactory extractorFactory = (ExtractorFactory)SingletonS2Container.getComponent((String)"extractorFactory");
        if (extractorFactory == null) {
            throw new RobotSystemException("Could not find extractorFactory.");
        }
        Extractor extractor = extractorFactory.getExtractor(responseData.getMimeType());
        InputStream in = responseData.getResponseBody();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceName", this.getResourceName(responseData));
        params.put("Content-Type", responseData.getMimeType());
        String content = null;
        try {
            content = extractor.getText(in, params).getContent();
        }
        catch (Exception e) {
            throw new RobotCrawlAccessException("Could not extract data.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        ResultData resultData = new ResultData();
        resultData.setTransformerName(this.getName());
        try {
            resultData.setData(content.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Invalid charsetName: " + this.charsetName + ". Changed to " + "UTF-8", (Throwable)e);
            }
            this.charsetName = Constants.UTF_8_CHARSET.name();
            resultData.setData(content.getBytes(Constants.UTF_8_CHARSET));
        }
        resultData.setEncoding(this.charsetName);
        return resultData;
    }

    @Override
    public Object getData(AccessResultData accessResultData) {
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new RobotSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        try {
            return new String(data, this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RobotCrawlAccessException("Unsupported encoding: " + this.charsetName, e);
        }
    }

    private String getResourceName(ResponseData responseData) {
        String name = responseData.getUrl();
        String enc = responseData.getCharSet();
        if (name == null || enc == null) {
            return null;
        }
        int idx = (name = name.replaceAll("/+$", "")).lastIndexOf(47);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        try {
            return URLDecoder.decode(name, enc);
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

