/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.IntDoubleProcedure;
import org.apache.mahout.math.map.AbstractIntDoubleMap;
import org.apache.mahout.math.map.OpenIntDoubleHashMap;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.SelectedSparseDoubleMatrix1D;
import org.apache.mahout.math.matrix.impl.SparseDoubleMatrix2D;

@Deprecated
public final class SparseDoubleMatrix1D
extends DoubleMatrix1D {
    final AbstractIntDoubleMap elements;

    public SparseDoubleMatrix1D(double[] values) {
        this(values.length);
        this.assign(values);
    }

    public SparseDoubleMatrix1D(int size) {
        this(size, size / 1000, 0.2, 0.5);
    }

    public SparseDoubleMatrix1D(int size, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(size);
        this.elements = new OpenIntDoubleHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    SparseDoubleMatrix1D(int size, AbstractIntDoubleMap elements, int offset, int stride) {
        this.setUp(size, offset, stride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public Vector toVector() {
        final RandomAccessSparseVector vector = new RandomAccessSparseVector(this.cardinality());
        this.elements.forEachPair(new IntDoubleProcedure(){

            public boolean apply(int i, double v) {
                vector.setQuick(i, v);
                return true;
            }
        });
        return vector;
    }

    @Override
    public void assign(double value) {
        if (this.isNoView && value == 0.0) {
            this.elements.clear();
        } else {
            super.assign(value);
        }
    }

    @Override
    public int cardinality() {
        return this.isNoView ? this.elements.size() : super.cardinality();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public double getQuick(int index) {
        return this.elements.get(this.zero + index * this.stride);
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix1D other) {
        if (other instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D otherMatrix = (SelectedSparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D otherMatrix = (SparseDoubleMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    public DoubleMatrix1D like(int size) {
        return new SparseDoubleMatrix1D(size);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return new SparseDoubleMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int index, double value) {
        int i = this.zero + index * this.stride;
        if (value == 0.0) {
            this.elements.removeKey(i);
        } else {
            this.elements.put(i, value);
        }
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedSparseDoubleMatrix1D(this.elements, offsets);
    }
}

