/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.solver;

import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.solver.Preconditioner;

public final class JacobiConditioner
implements Preconditioner {
    private final DenseVector inverseDiagonal;

    public JacobiConditioner(Matrix a) {
        if (a.numCols() != a.numRows()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        this.inverseDiagonal = new DenseVector(a.numCols());
        for (int i = 0; i < a.numCols(); ++i) {
            this.inverseDiagonal.setQuick(i, 1.0 / a.getQuick(i, i));
        }
    }

    @Override
    public Vector precondition(Vector v) {
        return v.times(this.inverseDiagonal);
    }
}

