/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

public class OnlineExponentialAverage {
    private final double alpha;
    private double lastT;
    private double s;
    private double w;
    private double t;

    public OnlineExponentialAverage(double alpha) {
        this.alpha = alpha;
    }

    public void add(double t, double x) {
        double pi = Math.exp(-(t - this.lastT) / this.alpha);
        this.s = x + pi * this.s;
        this.w = 1.0 + pi * this.w;
        this.t = t - this.lastT + pi * this.t;
        this.lastT = t;
    }

    public double mean() {
        return this.s / this.w;
    }

    public double meanRate() {
        return this.s / this.t;
    }
}

