/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.gempak.GempakGridParameterTable;
import ucar.nc2.iosp.gempak.GempakGridReader;
import ucar.nc2.iosp.gempak.GempakGridRecord;
import ucar.nc2.iosp.gempak.GempakLookup;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class GempakGridServiceProvider
extends GridServiceProvider {
    protected GempakGridReader gemreader;
    public static boolean extendIndex = true;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.gemreader = new GempakGridReader(raf.getLocation());
            this.gemreader.init(raf, false);
        }
        catch (Exception ioe) {
            return false;
        }
        return true;
    }

    @Override
    public String getFileTypeId() {
        return "GempakGrid";
    }

    @Override
    public String getFileTypeDescription() {
        return "GEMPAK Gridded Data";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        long start = System.currentTimeMillis();
        if (this.gemreader == null) {
            this.gemreader = new GempakGridReader(raf.getLocation());
        }
        this.initTables();
        this.gemreader.init(raf, true);
        GridIndex index = this.gemreader.getGridIndex();
        this.open(index, cancelTask);
        if (debugOpen) {
            System.out.println(" GridServiceProvider.open " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
        }
    }

    @Override
    protected void open(GridIndex index, CancelTask cancelTask) throws IOException {
        GempakLookup lookup = new GempakLookup((GempakGridRecord)index.getGridRecords().get(0));
        GridIndexToNC delegate = new GridIndexToNC(index.filename);
        delegate.open(index, lookup, 4, this.ncfile, this.fmrcCoordSys, cancelTask);
        this.ncfile.finish();
    }

    @Override
    public boolean sync() throws IOException {
        if (this.gemreader.getInitFileSize() < this.raf.length() && extendIndex) {
            this.gemreader.init(true);
            GridIndex index = this.gemreader.getGridIndex();
            this.ncfile.empty();
            this.open(index, null);
            return true;
        }
        return false;
    }

    @Override
    protected float[] _readData(GridRecord gr) throws IOException {
        return this.gemreader.readGrid((GempakGridRecord)gr);
    }

    public static void main(String[] args) throws IOException {
        GempakGridServiceProvider ggsp = new GempakGridServiceProvider();
        String className = ggsp.getClass().getName();
        if (args.length < 1) {
            System.out.println("\nUsage of " + className + ":\n");
            System.out.println("Parameters:");
            System.out.println("\t<GEMPAK Grid File> GEMPAK grid file to read");
            System.out.println("\t<NetCDF output file> file to store results (optional)\n");
            System.out.println("java -Xmx256m " + className + " <GEMPAK Grid File> <NetCDF output file>");
            System.exit(0);
        }
        Date now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... Start of " + className);
        try {
            System.out.println("reading GEMPAK grid file=" + args[0]);
            RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
            MakeNetcdfFile ncfile = new MakeNetcdfFile(ggsp, rf, args[0], null);
            if (args.length == 2) {
                System.out.print("writing to netCDF file=" + args[1]);
                NetcdfFile nc = FileWriter.writeToFile(ncfile, args[1]);
                nc.close();
            }
            rf.close();
        }
        catch (FileNotFoundException noFileError) {
            System.err.println("FileNotFoundException : " + noFileError);
        }
        catch (IOException ioError) {
            System.err.println("IOException : " + ioError);
        }
        now = Calendar.getInstance().getTime();
        System.out.println(now.toString() + " ... End of " + className + "!");
    }

    private void initTables() {
        try {
            GempakGridParameterTable.addParameters("resources/nj22/tables/gempak/wmogrib3.tbl");
            GempakGridParameterTable.addParameters("resources/nj22/tables/gempak/ncepgrib2.tbl");
        }
        catch (Exception e) {
            System.out.println("unable to init tables");
        }
    }

    public static void setExtendIndex(boolean b) {
        extendIndex = b;
    }

    protected static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

