/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions.js;

import java.util.ArrayList;
import java.util.List;

public class VariableContext {
    public final Type type;
    public final String text;
    public final int integer;

    private VariableContext(Type c, String s, int i) {
        this.type = c;
        this.text = s;
        this.integer = i;
    }

    public static final VariableContext[] parse(String variable) {
        char[] text = variable.toCharArray();
        ArrayList<VariableContext> contexts = new ArrayList<VariableContext>();
        int i = VariableContext.addMember(text, 0, contexts);
        while (i < text.length) {
            if (text[i] == '[') {
                i = text[++i] == '\'' ? VariableContext.addStringIndex(text, i, contexts) : VariableContext.addIntIndex(text, i, contexts);
                ++i;
                continue;
            }
            i = VariableContext.addMember(text, i + 1, contexts);
        }
        return contexts.toArray(new VariableContext[contexts.size()]);
    }

    private static int addMember(char[] text, int i, List<VariableContext> contexts) {
        int j;
        for (j = i + 1; j < text.length && text[j] != '[' && text[j] != '.'; ++j) {
        }
        contexts.add(new VariableContext(Type.MEMBER, new String(text, i, j - i), -1));
        return j;
    }

    private static int addStringIndex(char[] text, int i, List<VariableContext> contexts) {
        int j = ++i;
        while (text[j] != '\'') {
            if (text[j] == '\\') {
                ++j;
            }
            ++j;
        }
        StringBuffer buf = new StringBuffer(j - i);
        while (i < j) {
            if (text[i] == '\\') {
                ++i;
            }
            buf.append(text[i]);
            ++i;
        }
        contexts.add(new VariableContext(Type.STR_INDEX, buf.toString(), -1));
        return j + 1;
    }

    private static int addIntIndex(char[] text, int i, List<VariableContext> contexts) {
        int j = i + 1;
        while (text[j] != ']') {
            ++j;
        }
        int index = Integer.parseInt(new String(text, i, j - i));
        contexts.add(new VariableContext(Type.INT_INDEX, null, index));
        return j;
    }

    public static enum Type {
        MEMBER,
        STR_INDEX,
        INT_INDEX;

    }
}

