/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import org.carrot2.util.attribute.AttributeLevel;

public final class AttributeInfo {
    public final String key;
    public final String fieldName;
    public final String className;
    public final String javaDoc;
    public final String label;
    public final String title;
    public final String description;
    public final String group;
    public final AttributeLevel level;

    public AttributeInfo(String key, String className, String fieldName, String javaDoc, String label, String title, String description, String group, AttributeLevel level, AttributeInfo inheritFrom) {
        this.fieldName = fieldName;
        this.className = className;
        this.key = key;
        if (inheritFrom == null) {
            this.javaDoc = javaDoc;
            this.label = label;
            this.title = title;
            this.description = description;
            this.group = group;
            this.level = level;
        } else {
            this.javaDoc = AttributeInfo.firstNonNull(javaDoc, inheritFrom.javaDoc);
            this.label = AttributeInfo.firstNonNull(label, inheritFrom.label);
            this.title = AttributeInfo.firstNonNull(title, inheritFrom.title);
            this.description = AttributeInfo.firstNonNull(description, inheritFrom.description);
            this.group = AttributeInfo.firstNonNull(group, inheritFrom.group);
            this.level = AttributeInfo.firstNonNull(level, inheritFrom.level);
        }
    }

    private static <T> T firstNonNull(T ... objs) {
        for (T t : objs) {
            if (t == null) continue;
            return t;
        }
        return null;
    }
}

