/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute.constraint;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.carrot2.util.attribute.constraint.Constraint;
import org.carrot2.util.attribute.constraint.ConstraintFactory;

public class ConstraintViolationException
extends RuntimeException {
    public final Object offendingValue;
    public final Annotation[] annotations;
    public final String key;

    public ConstraintViolationException(String key, Object offendngValue, Annotation ... annotations) {
        this.offendingValue = offendngValue;
        this.annotations = annotations;
        this.key = key;
    }

    @Override
    public String getMessage() {
        StringBuilder constraintsString = new StringBuilder();
        ArrayList constraints = Lists.newArrayList(ConstraintFactory.createConstraints(this.annotations));
        for (int i = 0; i < constraints.size(); ++i) {
            constraintsString.append("@");
            constraintsString.append(this.annotations[i].annotationType().getSimpleName());
            constraintsString.append(": ");
            constraintsString.append(((Constraint)constraints.get(i)).toString());
            if (i == this.annotations.length - 1) continue;
            constraintsString.append(", ");
        }
        return "Value: '" + this.offendingValue + "' of attribute: '" + this.key + "' violates constraints: " + constraintsString;
    }
}

