/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codelibs.core.exception.FileAccessException;
import org.codelibs.core.exception.IORuntimeException;
import org.codelibs.core.util.StringUtil;

public class DynamicProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    public long checkInterval = 5000L;
    protected volatile long lastChecked = 0L;
    protected volatile long lastModified = 0L;
    protected volatile File propertiesFile;
    protected volatile Properties properties;

    public DynamicProperties(String path) {
        if (StringUtil.isEmpty(path)) {
            throw new FileAccessException("ECL0004");
        }
        this.propertiesFile = new File(path);
        if (!this.propertiesFile.exists()) {
            File parentDir = this.propertiesFile.getParentFile();
            if (!parentDir.exists()) {
                if (!parentDir.mkdir()) {
                    throw new FileAccessException("ECL0005", new Object[]{path});
                }
            } else if (!parentDir.isDirectory()) {
                throw new FileAccessException("ECL0006", new Object[]{path});
            }
            this.properties = new Properties();
            this.store();
        } else if (!this.propertiesFile.isFile()) {
            throw new FileAccessException("ECL0007", new Object[]{path});
        }
        this.load();
    }

    public synchronized void reload(String path) {
        File file = new File(path);
        if (!file.exists()) {
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                if (!parentDir.mkdir()) {
                    throw new FileAccessException("ECL0005", new Object[]{path});
                }
            } else if (!parentDir.isDirectory()) {
                throw new FileAccessException("ECL0006", new Object[]{path});
            }
            this.propertiesFile = file;
            this.store();
        } else {
            if (!file.isFile()) {
                throw new FileAccessException("ECL0007", new Object[]{path});
            }
            this.propertiesFile = file;
        }
        this.load();
    }

    public boolean isUpdated() {
        long now = System.currentTimeMillis();
        if (now - this.lastChecked < this.checkInterval) {
            this.lastChecked = now;
            return false;
        }
        this.lastChecked = now;
        long timestamp = this.propertiesFile.lastModified();
        return timestamp > this.lastModified;
    }

    public synchronized void load() {
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.propertiesFile);
            this.lastModified = this.propertiesFile.lastModified();
            prop.load(fis);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        this.properties = prop;
    }

    public synchronized void store() {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.propertiesFile);
            this.properties.store(fos, this.propertiesFile.getName());
        }
        catch (IOException e) {
            throw new FileAccessException("ECL0008", new Object[]{this.propertiesFile.getAbsolutePath()}, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        this.lastModified = this.propertiesFile.lastModified();
    }

    protected Properties getProperties() {
        if (this.isUpdated()) {
            this.load();
        }
        return this.properties;
    }

    @Override
    public void clear() {
        this.getProperties().clear();
    }

    @Override
    public Object clone() {
        DynamicProperties dynamicProperties = new DynamicProperties(this.propertiesFile.getAbsolutePath());
        dynamicProperties.checkInterval = this.checkInterval;
        return dynamicProperties;
    }

    @Override
    public boolean contains(Object value) {
        return this.getProperties().contains(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getProperties().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getProperties().containsValue(value);
    }

    @Override
    public Enumeration<Object> elements() {
        return this.getProperties().elements();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.getProperties().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.getProperties().equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.getProperties().get(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getProperties().getProperty(key, defaultValue);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    @Override
    public int hashCode() {
        return this.getProperties().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    @Override
    public Enumeration<Object> keys() {
        return this.getProperties().keys();
    }

    @Override
    public Set<Object> keySet() {
        return this.getProperties().keySet();
    }

    @Override
    public void list(PrintStream out) {
        this.getProperties().list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.getProperties().list(out);
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void load(Reader reader) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.getProperties().propertyNames();
    }

    @Override
    public Object put(Object key, Object value) {
        return this.getProperties().put(key, value);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> t) {
        this.getProperties().putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.getProperties().remove(key);
    }

    @Override
    public void save(OutputStream out, String comments) {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.getProperties().setProperty(key, value);
    }

    @Override
    public int size() {
        return this.getProperties().size();
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.getProperties().stringPropertyNames();
    }

    @Override
    public String toString() {
        return this.getProperties().toString();
    }

    @Override
    public Collection<Object> values() {
        return this.getProperties().values();
    }
}

