/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import jp.gr.java_conf.dangan.io.DisconnectableInputStream;
import jp.gr.java_conf.dangan.io.LimitedInputStream;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class LhaInputStream
extends InputStream {
    private InputStream source;
    private boolean alreadyOpenedFirstEnrty;
    private boolean reachedEndOfArchive;
    private InputStream in;
    private LimitedInputStream limit;
    private boolean reachedEndOfEntry;
    private boolean markReachedEndOfEntry;
    private Properties property;

    private LhaInputStream() {
    }

    public LhaInputStream(InputStream inputStream) {
        Properties properties = LhaProperty.getProperties();
        try {
            this.constructerHelper(inputStream, properties);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("Unsupported encoding \"" + properties.getProperty("lha.encoding") + "\".");
        }
    }

    public LhaInputStream(InputStream inputStream, Properties properties) throws UnsupportedEncodingException {
        this.constructerHelper(inputStream, properties);
    }

    private void constructerHelper(InputStream inputStream, Properties properties) throws UnsupportedEncodingException {
        String string;
        if (inputStream != null && properties != null) {
            string = properties.getProperty("lha.encoding");
            if (string == null) {
                string = LhaProperty.getProperty("lha.encoding");
            }
        } else {
            if (inputStream == null) {
                throw new NullPointerException("in");
            }
            throw new NullPointerException("property");
        }
        string.getBytes(string);
        this.source = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.in = null;
        this.limit = null;
        this.property = (Properties)properties.clone();
        this.reachedEndOfEntry = false;
        this.reachedEndOfArchive = false;
    }

    public int read() throws IOException {
        if (this.in != null) {
            int n = this.in.read();
            if (n < 0) {
                this.reachedEndOfEntry = true;
            }
            return n;
        }
        throw new IOException("no entry");
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in != null) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                this.reachedEndOfEntry = true;
            }
            return n3;
        }
        throw new IOException("no entry");
    }

    public long skip(long l) throws IOException {
        if (this.in != null) {
            if (0L < l) {
                long l2 = this.in.skip(l - 1L);
                int n = this.in.read();
                if (n < 0) {
                    this.reachedEndOfEntry = true;
                    return l2;
                }
                return l2 + 1L;
            }
            return 0L;
        }
        throw new IOException("no entry");
    }

    public void mark(int n) {
        if (this.in == null) {
            throw new IllegalStateException();
        }
        this.in.mark(n);
        this.markReachedEndOfEntry = this.reachedEndOfEntry;
    }

    public void reset() throws IOException {
        if (this.in == null) {
            throw new IOException("no entry");
        }
        this.in.reset();
        this.reachedEndOfEntry = this.markReachedEndOfEntry;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int available() throws IOException {
        if (this.in != null) {
            return this.reachedEndOfEntry ? 0 : 1;
        }
        throw new IOException("no entry");
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.limit = null;
            this.in = null;
        }
        this.source.close();
        this.source = null;
    }

    public LhaHeader getNextEntry() throws IOException {
        if (!this.reachedEndOfArchive) {
            byte[] byArray;
            if (this.in != null) {
                this.closeEntry();
            }
            if (this.alreadyOpenedFirstEnrty) {
                byArray = LhaHeader.getNextHeaderData(this.source);
            } else {
                byArray = LhaHeader.getFirstHeaderData(this.source);
                this.alreadyOpenedFirstEnrty = true;
            }
            if (null != byArray) {
                LhaHeader lhaHeader = LhaHeader.createInstance(byArray, this.property);
                this.in = new DisconnectableInputStream(this.source);
                this.limit = new LimitedInputStream(this.in, lhaHeader.getCompressedSize());
                this.in = CompressMethod.connectDecoder(this.limit, lhaHeader.getCompressMethod(), this.property, lhaHeader.getOriginalSize());
                this.reachedEndOfEntry = false;
                this.markReachedEndOfEntry = false;
                return lhaHeader;
            }
            this.reachedEndOfArchive = true;
            return null;
        }
        return null;
    }

    public LhaHeader getNextEntryWithoutExtract() throws IOException {
        if (!this.reachedEndOfArchive) {
            byte[] byArray;
            if (this.in != null) {
                this.closeEntry();
            }
            if (this.alreadyOpenedFirstEnrty) {
                byArray = LhaHeader.getNextHeaderData(this.source);
            } else {
                byArray = LhaHeader.getFirstHeaderData(this.source);
                this.alreadyOpenedFirstEnrty = true;
            }
            if (byArray != null) {
                LhaHeader lhaHeader = LhaHeader.createInstance(byArray, this.property);
                this.in = new DisconnectableInputStream(this.source);
                this.limit = new LimitedInputStream(this.in, lhaHeader.getCompressedSize());
                this.in = this.limit;
                this.reachedEndOfEntry = false;
                this.markReachedEndOfEntry = false;
                return lhaHeader;
            }
            this.reachedEndOfArchive = true;
            return null;
        }
        return null;
    }

    public void closeEntry() throws IOException {
        if (this.in != null) {
            while (0 <= this.limit.read()) {
                this.limit.skip(Long.MAX_VALUE);
            }
            this.in.close();
            this.in = null;
            this.limit = null;
        }
    }
}

