/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import jp.gr.java_conf.dangan.lang.reflect.Factory;

public class LhaProperty {
    private static final Properties property = LhaProperty.createLhaProperty();
    public static final String encoding = property.getProperty("lha.encoding");

    private LhaProperty() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getProperty(String string) {
        String string2 = property.getProperty(string);
        if (!string.equals("lha.encoding") || !System.getProperty(string, string2).equals("ShiftJISAuto")) return System.getProperty(string, string2);
        try {
            String string3 = System.getProperty("file.encoding");
            if (!LhaProperty.isCategoryOfShiftJIS(string3)) return "SJIS";
            return string3;
        }
        catch (SecurityException securityException) {
            try {
                return "SJIS";
            }
            catch (SecurityException securityException2) {
                return string2;
            }
        }
    }

    public static Properties getProperties() {
        String string;
        Properties properties = (Properties)property.clone();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            try {
                String string2 = System.getProperty(string);
                if (null == string2) continue;
                properties.put(string, string2);
            }
            catch (SecurityException securityException) {}
        }
        if (properties.getProperty("lha.encoding").equals("ShiftJISAuto")) {
            try {
                string = System.getProperty("file.encoding");
                if (LhaProperty.isCategoryOfShiftJIS(string)) {
                    properties.put("lha.encoding", string);
                } else {
                    properties.put("lha.encoding", "SJIS");
                }
            }
            catch (SecurityException securityException) {
                properties.put("lha.encoding", "SJIS");
            }
        }
        return properties;
    }

    public static Object parse(String string, Hashtable hashtable, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        return LhaProperty.parse(string, hashtable, stringArray);
    }

    public static Object parse(String string, Hashtable hashtable, String[] stringArray) {
        string = string.trim();
        int n = string.indexOf("(");
        int n2 = string.indexOf("[");
        if (0 <= n && (n2 < 0 || n < n2)) {
            return LhaProperty.parseConstructor(string, hashtable, stringArray);
        }
        if (0 <= n2 && (n < 0 || n2 < n)) {
            return LhaProperty.parseArray(string, hashtable, stringArray);
        }
        if (hashtable.containsKey(string)) {
            return hashtable.get(string);
        }
        return LhaProperty.applyPackages(string, stringArray);
    }

    private static Object parseConstructor(String string, Hashtable hashtable, String[] stringArray) {
        Object[] objectArray;
        String string2 = string.substring(0, string.indexOf(40)).trim();
        String string3 = string.substring(string.indexOf(40) + 1, string.lastIndexOf(41)).trim();
        string2 = LhaProperty.applyPackages(string2, stringArray);
        if (!string3.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",()[]", true);
            Stack<Object> stack = new Stack<Object>();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("(")) {
                    stack.push("(");
                } else if (string4.equals(")")) {
                    if (!stack.empty() && stack.peek().equals("(")) {
                        stack.pop();
                    }
                } else if (string4.equals("[")) {
                    stack.push("[");
                } else if (string4.equals("]")) {
                    if (!stack.empty() && stack.peek().equals("[")) {
                        stack.pop();
                    }
                } else if (string4.equals(",") && (stack.empty() || !stack.peek().equals("(") && !stack.peek().equals("["))) {
                    stack.push(new Integer(n));
                }
                n += string4.length();
            }
            n = 0;
            objectArray = new Object[stack.size() + 1];
            for (int i = 0; i < stack.size() + 1; ++i) {
                String string5 = i < stack.size() ? string3.substring(n, (Integer)stack.elementAt(i)) : string3.substring(n);
                n += string5.length() + 1;
                objectArray[i] = LhaProperty.parse(string5, hashtable, stringArray);
            }
        } else {
            objectArray = new Object[]{};
        }
        try {
            return Factory.createInstance(string2, objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new InstantiationError(instantiationException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            throw new Error(invocationTargetException.getTargetException().getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private static Object[] parseArray(String string, Hashtable hashtable, String[] stringArray) {
        String string2 = string.substring(string.indexOf(91) + 1, string.lastIndexOf(93)).trim();
        if (!string2.equals("")) {
            Object[] objectArray;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",()[]", true);
            Stack<Object> stack = new Stack<Object>();
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                objectArray = stringTokenizer.nextToken();
                if (objectArray.equals("(")) {
                    stack.push("(");
                } else if (objectArray.equals(")")) {
                    if (!stack.empty() && stack.peek().equals("(")) {
                        stack.pop();
                    }
                } else if (objectArray.equals("[")) {
                    stack.push("[");
                } else if (objectArray.equals("]")) {
                    if (!stack.empty() && stack.peek().equals("[")) {
                        stack.pop();
                    }
                } else if (objectArray.equals(",") && (stack.empty() || !stack.peek().equals("(") && !stack.peek().equals("["))) {
                    stack.push(new Integer(n));
                }
                n += objectArray.length();
            }
            n = 0;
            objectArray = new Object[stack.size() + 1];
            for (int i = 0; i < stack.size() + 1; ++i) {
                String string3 = i < stack.size() ? string2.substring(n, (Integer)stack.elementAt(i)) : string2.substring(n);
                n += string3.length() + 1;
                objectArray[i] = LhaProperty.parse(string3, hashtable, stringArray);
            }
            return objectArray;
        }
        return new Object[0];
    }

    private static String applyPackages(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].equals("") ? string : stringArray[i] + "." + string;
            try {
                Class.forName(string2);
                return string2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return string;
    }

    private static final Properties createLhaProperty() {
        Object object;
        String string = "jp.gr.java_conf.dangan.util.lha.resources.lha";
        Properties properties = LhaProperty.createDefaultProperty();
        try {
            object = ResourceBundle.getBundle(string);
            Enumeration<String> enumeration = ((ResourceBundle)object).getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                properties.put(string2, ((ResourceBundle)object).getString(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (properties.getProperty("lha.encoding").equals("ShiftJISAuto")) {
            try {
                object = System.getProperty("file.encoding");
                if (LhaProperty.isCategoryOfShiftJIS((String)object)) {
                    properties.put("lha.encoding", object);
                } else {
                    properties.put("lha.encoding", "SJIS");
                }
            }
            catch (SecurityException securityException) {
                properties.put("lha.encoding", "SJIS");
            }
        }
        return properties;
    }

    private static final Properties createDefaultProperty() {
        Properties properties = new Properties();
        properties.put("lha.encoding", LhaProperty.getSystemEncoding());
        properties.put("lha.packages", "jp.gr.java_conf.dangan.util.lha");
        properties.put("lha.lzs.encoder", "LzssOutputStream( PostLzsEncoder( out ), HashAndChainedListSearch, [ HashShort ] )");
        properties.put("lha.lz4.encoder", "out");
        properties.put("lha.lz5.encoder", "LzssOutputStream( PostLz5Encoder( out ), HashAndChainedListSearch )");
        properties.put("lha.lhd.encoder", "out");
        properties.put("lha.lh0.encoder", "out");
        properties.put("lha.lh1.encoder", "LzssOutputStream( PostLh1Encoder( out ), HashAndChainedListSearch )");
        properties.put("lha.lh2.encoder", "LzssOutputStream( PostLh2Encoder( out ), HashAndChainedListSearch )");
        properties.put("lha.lh3.encoder", "LzssOutputStream( PostLh3Encoder( out ), HashAndChainedListSearch )");
        properties.put("lha.lh4.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh4- ), HashAndChainedListSearch )");
        properties.put("lha.lh5.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh5- ), HashAndChainedListSearch )");
        properties.put("lha.lh6.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh6- ), HashAndChainedListSearch )");
        properties.put("lha.lh7.encoder", "LzssOutputStream( PostLh5Encoder( out, -lh7- ), HashAndChainedListSearch )");
        properties.put("lha.lzs.decoder", "LzssInputStream( PreLzsDecoder( in ), length )");
        properties.put("lha.lz4.decoder", "in");
        properties.put("lha.lz5.decoder", "LzssInputStream( PreLz5Decoder( in ), length )");
        properties.put("lha.lhd.decoder", "in");
        properties.put("lha.lh0.decoder", "in");
        properties.put("lha.lh1.decoder", "LzssInputStream( PreLh1Decoder( in ), length )");
        properties.put("lha.lh2.decoder", "LzssInputStream( PreLh2Decoder( in ), length )");
        properties.put("lha.lh3.decoder", "LzssInputStream( PreLh3Decoder( in ), length )");
        properties.put("lha.lh4.decoder", "LzssInputStream( PreLh5Decoder( in, -lh4- ), length )");
        properties.put("lha.lh5.decoder", "LzssInputStream( PreLh5Decoder( in, -lh5- ), length )");
        properties.put("lha.lh6.decoder", "LzssInputStream( PreLh5Decoder( in, -lh6- ), length )");
        properties.put("lha.lh7.decoder", "LzssInputStream( PreLh5Decoder( in, -lh7- ), length )");
        properties.put("lha.header", "LhaHeader( data, encoding )");
        return properties;
    }

    private static final String getSystemEncoding() {
        try {
            String string = System.getProperty("file.encoding");
            if (LhaProperty.isJapanese(string) && !LhaProperty.isCategoryOfShiftJIS(string)) {
                return "SJIS";
            }
            return string;
        }
        catch (SecurityException securityException) {
            String string = "ISO8859_1";
            return string;
        }
    }

    private static final boolean isJapanese(String string) {
        String[] stringArray = new String[]{"Cp930", "Cp939", "Cp942", "Cp942C", "Cp943", "Cp943C", "Cp33722", "MS932", "SJIS", "EUC_JP", "ISO2022JP", "JIS0201", "JIS0208", "JIS0212", "JISAutoDetect"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        String[] stringArray2 = new String[]{"eucjis", "euc-jp", "eucjp", "x-euc-jp", "x-eucjp", "csEUCPkdFmtJapanese", "extended_unix_code_packed_format_for_japanese ", "shift_jis", "ms_kanji", "csShiftJIS", "csWindows31J", "windows-31j", "x-sjis", "jis", "iso-2022-jp", "csISO2022JP", "jis_encoding", "csJISEncoding", "jis auto detect", "cp930", "ibm-930", "ibm930", "930", "cp939", "ibm-939", "ibm939", "939", "cp942", "ibm-942", "ibm942", "942", "cp942c", "cp943", "ibm-943", "ibm943", "943", "cp943c", "cp33722", "ibm-33722", "ibm33722", "33722"};
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray2[i])) continue;
            return true;
        }
        return false;
    }

    private static final boolean isCategoryOfShiftJIS(String string) {
        String[] stringArray = new String[]{"Cp942", "Cp942C", "Cp943", "Cp943C", "MS932", "SJIS"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        String[] stringArray2 = new String[]{"shift_jis", "ms_kanji", "csShiftJIS", "csWindows31J", "windows-31j", "x-sjis", "cp942", "ibm-942", "ibm942", "942", "cp942c", "cp943", "ibm-943", "ibm943", "943", "cp943c"};
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray2[i])) continue;
            return true;
        }
        return false;
    }
}

