/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.util.Collection;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;

public class BindingUtil
implements ContainerConstants {
    protected BindingUtil() {
    }

    public static final boolean isAutoBindable(Class clazz) {
        return clazz.isInterface() && !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz);
    }

    public static final boolean isAutoBindableArray(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().isInterface();
    }

    public static final boolean isAutoBindable(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (BindingUtil.isAutoBindable(classes[i])) continue;
            return false;
        }
        return true;
    }

    public static BeanDesc getBeanDesc(ComponentDef componentDef, Object component) {
        return BeanDescFactory.getBeanDesc(BindingUtil.getComponentClass(componentDef, component));
    }

    public static Class getComponentClass(ComponentDef componentDef, Object component) {
        Class clazz = componentDef.getConcreteClass();
        if (clazz != null) {
            return clazz;
        }
        return component.getClass();
    }
}

