/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.analysis;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import java.util.Map;
import jp.sf.fess.suggest.analysis.SuggestTokenizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    private static final int DEFAULT_MAX_LENGTH = 1000000;
    private static final Logger logger = LoggerFactory.getLogger(SuggestTokenizerFactory.class);
    private static final String MODE = "mode";
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";
    private static final String BUFFER_SIZE = "bufferSize";
    private static final String INCLUDE_CHAR_TERM = "includeCharTerm";
    private static final String EXCLUDE_PART_OF_SPEECH = "excludePartOfSpeech";
    private static final String INCLUDE_PART_OF_SPEECH = "includePartOfSpeech";
    private static final String DISCARD_PUNCTUATION = "discardPunctuation";
    private static final String MAX_LENGTH = "maxLength";
    private UserDictionary userDictionary;
    private final JapaneseTokenizer.Mode mode;
    private final String userDictionaryPath;
    private final String userDictionaryEncoding;
    private final boolean discardPunctuation;
    private final int bufferSize;
    private final SuggestTokenizer.TermChecker termChecker;
    private final int maxLength;
    private static final String DEFAULT_INCLUDE_PARTOFSPEECH = "start:\u540d\u8a5e,start:\u63a5\u982d\u8a5e,start:\u5f62\u5bb9\u8a5e,middle:\u540d\u8a5e,middle:\u63a5\u982d\u8a5e,middle:\u5f62\u5bb9\u8a5e";
    private static final String DEFAULT_EXCLUDE_PARTOFSPEECH = "start:\u526f\u8a5e\u53ef\u80fd";
    private static final String DEFAULT_INCLUDE_CHAR_TERM = "middle:\u306a";

    public SuggestTokenizerFactory(Map<String, String> args) {
        super(args);
        String includeCharTerm;
        String excludePartOfSpeech;
        this.mode = this.getMode(args);
        this.userDictionaryPath = args.get(USER_DICT_PATH);
        this.userDictionaryEncoding = args.get(USER_DICT_ENCODING);
        this.bufferSize = this.getInt(args, BUFFER_SIZE, 256);
        this.discardPunctuation = this.getBoolean(args, DISCARD_PUNCTUATION, true);
        this.maxLength = this.getInt(args, MAX_LENGTH, 1000000);
        this.termChecker = new SuggestTokenizer.TermChecker();
        String includePartOfSpeech = this.get(args, INCLUDE_PART_OF_SPEECH, DEFAULT_INCLUDE_PARTOFSPEECH);
        if (includePartOfSpeech != null) {
            for (String text : includePartOfSpeech.split(",")) {
                String[] values;
                if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                this.termChecker.includePartOfSpeech(values[0].trim(), values[1].trim());
            }
        }
        if ((excludePartOfSpeech = this.get(args, EXCLUDE_PART_OF_SPEECH, DEFAULT_EXCLUDE_PARTOFSPEECH)) != null) {
            for (String text : excludePartOfSpeech.split(",")) {
                String[] values;
                if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                this.termChecker.excludePartOfSpeech(values[0].trim(), values[1].trim());
            }
        }
        if ((includeCharTerm = this.get(args, INCLUDE_CHAR_TERM, DEFAULT_INCLUDE_CHAR_TERM)) != null) {
            for (String text : includeCharTerm.split(",")) {
                String[] values;
                if ((text = text.trim()).length() <= 0 || (values = text.split(":")).length != 2) continue;
                this.termChecker.includeCharTerm(values[0].trim(), values[1].trim());
            }
        }
    }

    public Tokenizer create(AttributeFactory factory, Reader input) {
        return this.create(factory, input, false);
    }

    public Tokenizer create(Reader input, boolean allTokenMode) {
        return this.create(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, input, allTokenMode);
    }

    public Tokenizer create(AttributeFactory factory, Reader input, boolean allTokenMode) {
        return new SuggestTokenizer(input, this.bufferSize, this.userDictionary, this.discardPunctuation, this.mode, this.termChecker, this.maxLength, allTokenMode);
    }

    public void inform(ResourceLoader loader) {
        try {
            if (this.userDictionaryPath != null) {
                InputStream stream = loader.openResource(this.userDictionaryPath);
                String encoding = this.userDictionaryEncoding;
                if (encoding == null) {
                    encoding = IOUtils.UTF_8;
                }
                CharsetDecoder decoder = Charset.forName(encoding).newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                InputStreamReader reader = new InputStreamReader(stream, decoder);
                this.userDictionary = new UserDictionary((Reader)reader);
            } else {
                this.userDictionary = null;
            }
        }
        catch (Exception e) {
            logger.warn("Initialization failed.", (Throwable)e);
        }
    }

    private JapaneseTokenizer.Mode getMode(Map<String, String> args) {
        String modeArg = args.get(MODE);
        if (modeArg != null) {
            return JapaneseTokenizer.Mode.valueOf((String)modeArg.toUpperCase(Locale.ROOT));
        }
        return JapaneseTokenizer.Mode.NORMAL;
    }
}

