/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jp.sf.fess.suggest.entity.SuggestItem;
import jp.sf.fess.suggest.enums.RequestType;
import jp.sf.fess.suggest.server.SuggestSolrServer;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexUpdater
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IndexUpdater.class);
    protected Queue<Request> suggestRequestQueue = new ConcurrentLinkedQueue<Request>();
    protected final SuggestSolrServer suggestSolrServer;
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected AtomicLong updateInterval = new AtomicLong(10000L);
    protected AtomicInteger maxUpdateNum = new AtomicInteger(10000);
    protected AtomicInteger maxIDsBufferCapacity = new AtomicInteger(100000);

    public IndexUpdater(SuggestSolrServer suggestSolrServer) {
        super("SuggestIndexUpdater");
        this.suggestSolrServer = suggestSolrServer;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval.set(updateInterval);
    }

    public int getQueuingItemNum() {
        return this.suggestRequestQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuggestItem(SuggestItem item) {
        Request request = new Request(RequestType.ADD, item);
        this.suggestRequestQueue.add(request);
        SuggestSolrServer suggestSolrServer = this.suggestSolrServer;
        synchronized (suggestSolrServer) {
            this.suggestSolrServer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Request request = new Request(RequestType.COMMIT, null);
        this.suggestRequestQueue.add(request);
        SuggestSolrServer suggestSolrServer = this.suggestSolrServer;
        synchronized (suggestSolrServer) {
            this.suggestSolrServer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByQuery(String query) {
        Request request = new Request(RequestType.DELETE_BY_QUERY, query);
        this.suggestRequestQueue.add(request);
        SuggestSolrServer suggestSolrServer = this.suggestSolrServer;
        synchronized (suggestSolrServer) {
            this.suggestSolrServer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.running.set(false);
        SuggestSolrServer suggestSolrServer = this.suggestSolrServer;
        synchronized (suggestSolrServer) {
            this.suggestSolrServer.notify();
        }
        this.suggestSolrServer.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info("SuggestIndexer is started.");
        }
        long startTime = System.currentTimeMillis();
        StringBuilder ids = new StringBuilder(this.maxIDsBufferCapacity.get());
        Request[] requestArray = new Request[this.maxUpdateNum.get()];
        SuggestItem[] suggestItemArray = new SuggestItem[this.maxUpdateNum.get()];
        this.running.set(true);
        block17: while (this.running.get()) {
            Request request;
            int requestNum = 0;
            for (int i = 0; i < this.maxUpdateNum.get() && (request = this.suggestRequestQueue.peek()) != null; ++i) {
                if (request.type == RequestType.ADD) {
                    this.suggestRequestQueue.poll();
                    boolean exist = false;
                    SuggestItem item2 = (SuggestItem)request.obj;
                    for (int j = 0; j < requestNum; ++j) {
                        SuggestItem item1 = (SuggestItem)requestArray[j].obj;
                        if (!item1.equals(item2)) continue;
                        this.mergeSuggestItem(item1, item2);
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    requestArray[requestNum] = request;
                    ++requestNum;
                    continue;
                }
                if (requestNum != 0) break;
                requestArray[requestNum] = this.suggestRequestQueue.poll();
                ++requestNum;
                break;
            }
            if (requestNum == 0) {
                if (ids.capacity() > this.maxIDsBufferCapacity.get()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Clear IDs buffer string.");
                    }
                    ids = new StringBuilder(this.maxIDsBufferCapacity.get());
                }
                try {
                    SuggestSolrServer i = this.suggestSolrServer;
                    synchronized (i) {
                        this.suggestSolrServer.wait(this.updateInterval.get());
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    continue;
                }
            }
            switch (requestArray[0].type) {
                case ADD: {
                    SuggestItem item;
                    long start = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Add " + requestNum + " documents");
                    }
                    int itemSize = 0;
                    ids.setLength(0);
                    for (int i = 0; i < requestNum; ++i) {
                        Request request2 = requestArray[i];
                        suggestItemArray[itemSize] = item = (SuggestItem)request2.obj;
                        if (ids.length() > 0) {
                            ids.append(',');
                        }
                        ids.append(item.getDocumentId());
                        ++itemSize;
                    }
                    this.mergeSolrIndex(suggestItemArray, itemSize, ids.toString());
                    ArrayList<SolrInputDocument> solrInputDocumentList = new ArrayList<SolrInputDocument>(itemSize);
                    for (int i = 0; i < itemSize; ++i) {
                        item = suggestItemArray[i];
                        solrInputDocumentList.add(item.toSolrInputDocument());
                    }
                    try {
                        this.suggestSolrServer.add(solrInputDocumentList);
                        if (!logger.isDebugEnabled()) continue block17;
                        logger.debug("Done add " + itemSize + " terms. took: " + (System.currentTimeMillis() - start));
                    }
                    catch (Exception e) {
                        logger.warn("Failed to add document.", (Throwable)e);
                    }
                    break;
                }
                case COMMIT: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Commit.");
                    }
                    try {
                        this.suggestSolrServer.commit();
                    }
                    catch (Exception e) {
                        logger.warn("Failed to commit.", (Throwable)e);
                    }
                    break;
                }
                case DELETE_BY_QUERY: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("DeleteByQuery. query=" + requestArray[0].obj.toString());
                    }
                    try {
                        this.suggestSolrServer.deleteByQuery((String)requestArray[0].obj);
                        this.suggestSolrServer.commit();
                    }
                    catch (Exception e) {
                        logger.warn("Failed to deleteByQuery.", (Throwable)e);
                    }
                    break;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Finished SuggestIndexer: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        this.suggestRequestQueue.clear();
    }

    protected void mergeSolrIndex(SuggestItem[] suggestItemArray, int itemSize, String ids) {
        long startTime = System.currentTimeMillis();
        if (itemSize > 0) {
            SolrDocumentList documentList = null;
            try {
                documentList = this.suggestSolrServer.get(ids);
                if (logger.isDebugEnabled()) {
                    logger.debug("search end. getNum=" + documentList.size() + "  took:" + (System.currentTimeMillis() - startTime));
                }
            }
            catch (Exception e) {
                logger.warn("Failed merge solr index.", (Throwable)e);
            }
            if (documentList != null) {
                int itemCount = 0;
                block2: for (SolrDocument doc : documentList) {
                    Object idObj = doc.getFieldValue("id");
                    if (idObj == null) continue;
                    String id = idObj.toString();
                    while (itemCount < itemSize) {
                        SuggestItem item = suggestItemArray[itemCount];
                        if (item.getDocumentId().equals(id)) {
                            Object expiresObj;
                            Object segmentObj;
                            Collection fields;
                            Collection roles;
                            Collection labels;
                            Object count = doc.getFieldValue("count_i");
                            if (count != null) {
                                item.setCount(item.getCount() + Long.parseLong(count.toString()));
                            }
                            if ((labels = doc.getFieldValues("label_s_m")) != null) {
                                List<String> itemLabelList = item.getLabels();
                                for (Object label : labels) {
                                    if (itemLabelList.contains(label.toString())) continue;
                                    itemLabelList.add(label.toString());
                                }
                            }
                            if ((roles = doc.getFieldValues("role_s_m")) != null) {
                                List<String> itemRoleList = item.getRoles();
                                for (Object role : roles) {
                                    if (itemRoleList.contains(role.toString())) continue;
                                    itemRoleList.add(role.toString());
                                }
                            }
                            if ((fields = doc.getFieldValues("fieldname_s_m")) != null) {
                                List<String> fieldNameList = item.getFieldNameList();
                                for (Object field : fields) {
                                    if (fieldNameList.contains(field.toString())) continue;
                                    fieldNameList.add(field.toString());
                                }
                            }
                            if ((segmentObj = doc.getFieldValue("segment")) == null || !StringUtils.isNotBlank((String)segmentObj.toString())) continue block2;
                            long docType = Long.parseLong(segmentObj.toString());
                            long currentDocType = Long.parseLong(item.getSegment());
                            if (currentDocType > docType) {
                                item.setSegment(String.valueOf(docType));
                            }
                            if ((expiresObj = doc.getFieldValue("expires_dt")) != null || !"0".equals(segmentObj.toString())) continue block2;
                            item.setExpires("-1");
                            continue block2;
                        }
                        ++itemCount;
                    }
                }
            }
        }
    }

    protected void mergeSuggestItem(SuggestItem item1, SuggestItem item2) {
        item1.setCount(item1.getCount() + 1L);
        item1.setExpires(item2.getExpires());
        item1.setSegment(item2.getSegment());
        List<String> fieldNameList = item1.getFieldNameList();
        for (String fieldName : item2.getFieldNameList()) {
            if (fieldNameList.contains(fieldName)) continue;
            fieldNameList.add(fieldName);
        }
        List<String> labelList = item1.getLabels();
        for (String label : item2.getLabels()) {
            if (labelList.contains(label)) continue;
            labelList.add(label);
        }
        List<String> roleList = item1.getRoles();
        for (String role : item2.getRoles()) {
            if (roleList.contains(role)) continue;
            roleList.add(role);
        }
    }

    protected static class Request {
        public RequestType type;
        public Object obj;

        public Request(RequestType type, Object o) {
            this.type = type;
            this.obj = o;
        }
    }
}

