/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.IOException;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONDataType;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

public class JSONWriter {
    private JSON.Context context;
    private OutputSource out;
    private Stack stack = new Stack();

    JSONWriter(JSON.Context context, OutputSource outputSource) {
        this.context = context;
        this.out = outputSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter beginObject() throws IOException {
        State state = this.stack.peek();
        if (state == null) {
            if (this.context.isPrettyPrint()) {
                this.context.appendIndent(this.out, 0);
            }
            this.context.enter(JSON.ROOT, null);
        } else if (state.type == JSONDataType.OBJECT) {
            if (state.name == null) throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "beginObject"), 100);
            this.context.enter(state.name);
        } else {
            if (state.type != JSONDataType.ARRAY) throw new IllegalStateException();
            if (state.index > 0) {
                this.out.append(',');
            }
            if (this.context.isPrettyPrint()) {
                this.out.append('\n');
                this.context.appendIndent(this.out, this.context.getDepth() + 1);
            }
            this.context.enter(state.index);
        }
        this.stack.push(JSONDataType.OBJECT);
        this.out.append('{');
        return this;
    }

    public JSONWriter endObject() throws IOException {
        State state = this.stack.peek();
        if (state == null) {
            throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "endObject"), 100);
        }
        if (state.type == JSONDataType.OBJECT) {
            if (this.context.isPrettyPrint() && state.index > 0) {
                this.out.append('\n');
                this.context.appendIndent(this.out, this.context.getDepth());
            }
        } else {
            throw new JSONException(this.context.getMessage("json.format.ArrayNotClosedError", new Object[0]), 100);
        }
        this.stack.pop();
        this.out.append('}');
        this.context.exit();
        if (this.stack.size == 0) {
            this.out.flush();
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter beginArray() throws IOException {
        State state = this.stack.peek();
        if (state == null) {
            if (this.context.isPrettyPrint()) {
                this.context.appendIndent(this.out, 0);
            }
            this.context.enter(JSON.ROOT, null);
        } else if (state.type == JSONDataType.OBJECT) {
            if (state.name == null) throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "beginArray"), 100);
            this.context.enter(state.name);
        } else {
            if (state.type != JSONDataType.ARRAY) throw new IllegalStateException();
            if (state.index > 0) {
                this.out.append(',');
            }
            if (this.context.isPrettyPrint()) {
                this.out.append('\n');
                this.context.appendIndent(this.out, this.context.getDepth() + 1);
            }
            this.context.enter(state.index);
        }
        this.stack.push(JSONDataType.ARRAY);
        this.out.append('[');
        return this;
    }

    public JSONWriter endArray() throws IOException {
        State state = this.stack.peek();
        if (state == null) {
            throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "endArray"), 100);
        }
        if (state.type == JSONDataType.ARRAY) {
            if (this.context.isPrettyPrint() && state.index > 0) {
                this.out.append('\n');
                this.context.appendIndent(this.out, this.context.getDepth());
            }
        } else {
            throw new JSONException(this.context.getMessage("json.format.ObjectNotClosedError", new Object[0]), 100);
        }
        this.stack.pop();
        this.out.append(']');
        this.context.exit();
        if (this.stack.size == 0) {
            this.out.flush();
        }
        return this;
    }

    public JSONWriter name(String string) throws IOException {
        State state = this.stack.peek();
        if (state == null) {
            throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "name"), 100);
        }
        if (state.type == JSONDataType.OBJECT) {
            state.name = string;
            if (state.index > 0) {
                this.out.append(',');
            }
            if (this.context.isPrettyPrint()) {
                this.out.append('\n');
                this.context.appendIndent(this.out, this.context.getDepth() + 1);
            }
        } else {
            throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "name"), 100);
        }
        StringFormatter.serialize(this.context, string, this.out);
        this.out.append(':');
        if (this.context.isPrettyPrint()) {
            this.out.append(' ');
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(Object object) throws IOException {
        State state = this.stack.peek();
        if (state == null) {
            if (this.context.isPrettyPrint()) {
                this.context.appendIndent(this.out, 0);
            }
            this.context.enter(JSON.ROOT, null);
        } else if (state.type == JSONDataType.OBJECT) {
            if (state.name == null) throw new JSONException(this.context.getMessage("json.format.IllegalMethodCallError", "value"), 100);
            this.context.enter(state.name);
        } else {
            if (state.type != JSONDataType.ARRAY) throw new IllegalStateException();
            if (state.index > 0) {
                this.out.append(',');
            }
            if (this.context.isPrettyPrint()) {
                this.out.append('\n');
                this.context.appendIndent(this.out, this.context.getDepth() + 1);
            }
            this.context.enter(state.index);
        }
        object = this.context.preformatInternal(object);
        this.context.formatInternal(object, this.out);
        this.context.exit();
        if (state != null) {
            ++state.index;
        }
        if (this.stack.size != 0) return this;
        this.out.flush();
        return this;
    }

    public JSONWriter flush() throws IOException {
        this.out.flush();
        return this;
    }

    static final class State {
        public JSONDataType type;
        public String name;
        public int index = 0;

        State() {
        }
    }

    static final class Stack {
        private int size = 0;
        private State[] list = new State[8];

        Stack() {
        }

        public State push(JSONDataType jSONDataType) {
            Object object;
            ++this.size;
            if (this.size >= this.list.length) {
                object = new State[Math.max(this.size, this.list.length) * 2];
                System.arraycopy(this.list, 0, object, 0, this.list.length);
                this.list = object;
            }
            if (this.list[this.size] != null) {
                object = this.list[this.size];
                object.name = null;
                object.index = 0;
            } else {
                this.list[this.size] = object = new State();
            }
            object.type = jSONDataType;
            return object;
        }

        public State peek() {
            if (this.size < this.list.length) {
                return this.list[this.size];
            }
            return null;
        }

        public State pop() {
            if (this.size >= 0 && this.size < this.list.length) {
                return this.list[this.size--];
            }
            return null;
        }

        public int size() {
            return this.size;
        }
    }
}

