/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.Container;
import net.arnx.jsonic.web.ExternalContext;

public class RPCServlet
extends HttpServlet {
    protected Container container;
    Config config;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getInitParameter("config");
        JSON jSON = new JSON();
        if (string == null) {
            HashMap hashMap = new HashMap();
            Enumeration object = (Enumeration)Container.cast(servletConfig.getInitParameterNames());
            while (object.hasMoreElements()) {
                hashMap.put(object.nextElement(), servletConfig.getInitParameter((String)object.nextElement()));
            }
            string = jSON.format(hashMap);
        }
        try {
            this.config = jSON.parse((CharSequence)string, Config.class);
            if (this.config.container == null) {
                this.config.container = Container.class;
            }
            this.container = jSON.parse((CharSequence)string, this.config.container);
            this.container.init(this);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (this.config.errors == null) {
            this.config.errors = Collections.emptyMap();
        }
        if (this.config.mappings == null) {
            this.config.mappings = Collections.emptyMap();
        }
        for (Map.Entry entry : this.config.mappings.entrySet()) {
            ((RouteMapping)entry.getValue()).init((String)entry.getKey(), this.config);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRPC(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        List<Object> list;
        Object object;
        Object object2;
        JSON jSON = null;
        boolean bl = false;
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        try {
            RouteMapping routeMapping2;
            ExternalContext.start(this.getServletConfig(), this.getServletContext(), httpServletRequest, httpServletResponse);
            this.container.start(httpServletRequest, httpServletResponse);
            object2 = httpServletRequest.getContextPath().equals("/") ? httpServletRequest.getRequestURI() : httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
            object = null;
            for (RouteMapping routeMapping2 : this.config.mappings.values()) {
                object = routeMapping2.matches(httpServletRequest, (String)object2);
                if (object == null) continue;
                if (!this.container.isDebugMode()) break;
                this.container.debug("Route found: " + httpServletRequest.getMethod() + " " + (String)object2 + " -> " + object);
                break;
            }
            if (object == null || !Container.isJSONType(httpServletRequest.getContentType())) {
                httpServletResponse.sendError(404, "Not Found");
                return;
            }
            jSON = this.container.createJSON(httpServletRequest.getLocale());
            list = new ArrayList(0);
            routeMapping2 = jSON.parse(httpServletRequest.getReader());
            if (routeMapping2 instanceof List && !((List)((Object)routeMapping2)).isEmpty()) {
                list = (List)Container.cast(routeMapping2);
                bl = true;
            } else if (routeMapping2 instanceof Map && !((Map)((Object)routeMapping2)).isEmpty()) {
                list = Arrays.asList(routeMapping2);
            } else {
                throw new IllegalArgumentException("Request is empty.");
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object3;
                Object object4;
                LinkedHashMap<String, Object> linkedHashMap;
                Map map = (Map)list.get(i);
                String string = null;
                String string2 = null;
                ArrayList arrayList2 = null;
                Object v = null;
                Object object5 = null;
                LinkedHashMap<String, Object> linkedHashMap2 = null;
                try {
                    if (map.get("jsonrpc") != null && !"2.0".equals(map.get("jsonrpc"))) {
                        throw new IllegalArgumentException("jsonrpc is unrecognized version: " + map.get("jsonrpc"));
                    }
                    string = (String)map.get("jsonrpc");
                    if (map.get("method") instanceof String) {
                        string2 = (String)map.get("method");
                        if (string != null && string2.startsWith("rpc.")) {
                            this.container.warn("Method names that begin with 'rpc.' are reserved for system extensions.");
                        }
                    } else {
                        throw new IllegalArgumentException("method must " + (map.get("method") == null ? "not be null." : "be string."));
                    }
                    if (map.get("params") instanceof List || string != null && map.get("params") instanceof Map) {
                        arrayList2 = (ArrayList)map.get("params");
                    } else if (string != null && map.get("params") == null) {
                        arrayList2 = new ArrayList(0);
                    } else {
                        throw new IllegalArgumentException("params must be array" + (string != null ? " or object." : "."));
                    }
                    if (string != null && map.get("id") != null && !(map.get("id") instanceof String) && !(map.get("id") instanceof Number)) {
                        throw new IllegalArgumentException("id must be string, number or null.");
                    }
                    v = map.get("id");
                    linkedHashMap = null;
                    object4 = string2;
                    if (((Route)object).getParameter("class") == null) {
                        int n = string2.lastIndexOf(46);
                        linkedHashMap = n != -1 ? string2.substring(0, n) : null;
                        Object object6 = object4 = n != -1 ? string2.substring(n + 1) : string2;
                    }
                    if ((object3 = this.container.getComponent(((Route)object).getComponentClass(this.container, (String)((Object)linkedHashMap)))) == null) {
                        throw new NoSuchMethodException("Method not found: " + string2);
                    }
                    List<Object> list2 = arrayList2 instanceof List ? (List<Object>)arrayList2 : Arrays.asList(arrayList2);
                    Map.Entry<String, Integer> entry = this.container.getMethod(object3, (String)object4, list2);
                    if (entry == null) {
                        throw new NoSuchMethodException("Method not found: " + string2);
                    }
                    jSON.setContext(object3);
                    object5 = this.container.execute(jSON, object3, (Method)((Object)entry), list2);
                }
                catch (Exception exception) {
                    linkedHashMap2 = new LinkedHashMap<String, Object>();
                    if (exception instanceof IllegalArgumentException) {
                        this.container.debug("Invalid Request.", exception);
                        this.container.exception(exception, httpServletRequest, httpServletResponse);
                        linkedHashMap2.put("code", -32600);
                        linkedHashMap2.put("message", "Invalid Request.");
                    }
                    if (exception instanceof ClassNotFoundException) {
                        this.container.debug("Class Not Found.", exception);
                        this.container.exception(exception, httpServletRequest, httpServletResponse);
                        linkedHashMap2.put("code", -32601);
                        linkedHashMap2.put("message", "Method not found.");
                    }
                    if (exception instanceof NoSuchMethodException) {
                        this.container.debug("Method Not Found.", exception);
                        this.container.exception(exception, httpServletRequest, httpServletResponse);
                        linkedHashMap2.put("code", -32601);
                        linkedHashMap2.put("message", "Method not found.");
                    }
                    if (exception instanceof JSONException) {
                        this.container.debug("Invalid params.", exception);
                        this.container.exception(exception, httpServletRequest, httpServletResponse);
                        linkedHashMap2.put("code", -32602);
                        linkedHashMap2.put("message", "Invalid params.");
                    }
                    if (exception instanceof InvocationTargetException) {
                        object4 = exception.getCause();
                        if (object4 instanceof Error) {
                            throw (Error)object4;
                        }
                        this.container.debug("Fails to invoke method.", (Throwable)object4);
                        this.container.exception((Exception)object4, httpServletRequest, httpServletResponse);
                        if (object4 instanceof IllegalStateException || object4 instanceof UnsupportedOperationException) {
                            linkedHashMap2.put("code", -32601);
                            linkedHashMap2.put("message", "Method not found.");
                        } else if (object4 instanceof IllegalArgumentException) {
                            linkedHashMap2.put("code", -32602);
                            linkedHashMap2.put("message", "Invalid params.");
                        } else {
                            object3 = null;
                            for (Map.Entry<String, Integer> entry : this.config.errors.entrySet()) {
                                Class<?> clazz = ClassUtil.findClass(entry.getKey());
                                if (clazz == null || !clazz.isAssignableFrom(object4.getClass()) || entry.getValue() == null) continue;
                                object3 = (Integer)entry.getValue();
                                break;
                            }
                            if (object3 != null) {
                                linkedHashMap2.put("code", object3);
                                linkedHashMap2.put("message", object4.getClass().getSimpleName() + ": " + ((Throwable)object4).getMessage());
                                linkedHashMap2.put("data", this.container.getErrorData((Throwable)object4));
                            } else {
                                this.container.error("Internal error occurred.", (Throwable)object4);
                                linkedHashMap2.put("code", -32603);
                                linkedHashMap2.put("message", "Internal error.");
                            }
                        }
                    }
                    this.container.error("Internal error occurred.", exception);
                    this.container.exception(exception, httpServletRequest, httpServletResponse);
                    linkedHashMap2.put("code", -32603);
                    linkedHashMap2.put("message", "Internal error.");
                }
                if (string2 != null && string == null && v == null || string != null && map != null && !map.containsKey("id")) continue;
                linkedHashMap = new LinkedHashMap<String, Object>();
                if (string != null) {
                    linkedHashMap.put("jsonrpc", string);
                    if (object5 != null) {
                        linkedHashMap.put("result", object5);
                    }
                    if (linkedHashMap2 != null) {
                        linkedHashMap.put("error", linkedHashMap2);
                    }
                } else {
                    linkedHashMap.put("result", object5);
                    linkedHashMap.put("error", linkedHashMap2);
                }
                linkedHashMap.put("id", v);
                arrayList.add(linkedHashMap);
            }
        }
        catch (Exception exception) {
            object = new LinkedHashMap<String, Object>();
            if (exception instanceof JSONException) {
                this.container.debug("Fails to parse JSON.", exception);
                object.put("code", -32700);
                object.put("message", "Parse error.");
                object.put("data", this.container.getErrorData(exception));
            } else {
                this.container.debug("Invalid Request.", exception);
                object.put("code", -32600);
                object.put("message", "Invalid Request.");
            }
            list = new LinkedHashMap();
            list.put("jsonrpc", "2.0");
            list.put("error", object);
            list.put("id", null);
            arrayList.add((Cloneable)((Object)list));
        }
        finally {
            try {
                this.container.end(httpServletRequest, httpServletResponse);
            }
            finally {
                ExternalContext.end();
            }
        }
        if (httpServletResponse.isCommitted()) {
            return;
        }
        if (arrayList.isEmpty()) {
            httpServletResponse.setStatus(202);
            return;
        }
        httpServletResponse.setContentType("application/json");
        object2 = httpServletResponse.getWriter();
        object = bl ? arrayList : arrayList.get(0);
        jSON.setContext(object);
        jSON.format(object, (Appendable)object2);
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Route {
        static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        private String target;
        private Map<Object, Object> params;

        public Route(String string, Map<String, Object> map) throws IOException {
            this.target = string;
            this.params = (Map)Container.cast(map);
        }

        public String getParameter(String string) {
            Object object;
            Object object2 = this.params.get(string);
            if (object2 instanceof Map && (object = (Map)object2).containsKey(null)) {
                object2 = object.get(null);
            }
            if (object2 instanceof List && !(object = (List)object2).isEmpty()) {
                object2 = object.get(0);
            }
            return object2 instanceof String ? (String)object2 : null;
        }

        public Map<?, ?> getParameterMap() {
            return this.params;
        }

        public String getComponentClass(Container container, String string) {
            Matcher matcher = REPLACE_PATTERN.matcher(this.target);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = this.getParameter(string2);
                if (string2.equals("class") && container.namingConversion) {
                    string3 = ClassUtil.toUpperCamel(string3 != null ? string3 : (string != null ? string : "?"));
                } else if (string2.equals("package")) {
                    string3 = string3.replace('/', '.');
                }
                matcher.appendReplacement(stringBuffer, string3 != null ? string3 : "");
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        public Map<?, ?> mergeParameterMap(Map<?, ?> map) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (this.params.containsKey(entry.getKey())) {
                    Object object;
                    Object object2 = this.params.get(entry.getKey());
                    if (object2 instanceof Map) {
                        object = (Map)object2;
                        if (object.containsKey(null)) {
                            object2 = object.get(null);
                            if (object2 instanceof List) {
                                ((List)object2).add(entry.getValue());
                                continue;
                            }
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            arrayList.add(object2);
                            arrayList.add(entry.getValue());
                            object.put(null, arrayList);
                            continue;
                        }
                        object.put(null, entry.getValue());
                        continue;
                    }
                    if (object2 instanceof List) {
                        ((List)object2).add(entry.getValue());
                        continue;
                    }
                    object = new ArrayList();
                    object.add(object2);
                    object.add(entry.getValue());
                    this.params.put(entry.getKey(), object);
                    continue;
                }
                this.params.put(entry.getKey(), entry.getValue());
            }
            return this.params;
        }

        public String toString() {
            return "Route [target=" + this.target + ", params=" + this.params + "]";
        }
    }

    static class RouteMapping {
        static final Pattern PLACE_PATTERN = Pattern.compile("\\{\\s*(\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}\\.-]*)\\s*(?::\\s*((?:[^{}]|\\{[^{}]*\\})*)\\s*)?\\}");
        static final Pattern DEFAULT_PATTERN = Pattern.compile("[^/().]+");
        public String target;
        Config config;
        Pattern pattern;
        List<String> names;

        public void init(String string, Config config) {
            this.config = config;
            this.names = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer("^\\Q");
            Matcher matcher = PLACE_PATTERN.matcher(string);
            while (matcher.find()) {
                Pattern pattern;
                String string2 = matcher.group(1);
                this.names.add(string2);
                Pattern pattern2 = pattern = matcher.group(2) != null ? Pattern.compile(matcher.group(2)) : null;
                if (pattern == null && config.definitions.containsKey(string2)) {
                    pattern = config.definitions.get(string2);
                }
                if (pattern == null) {
                    pattern = DEFAULT_PATTERN;
                }
                matcher.appendReplacement(stringBuffer, "\\\\E(" + pattern.pattern().replaceAll("\\((?!\\?)", "(?:").replace("\\", "\\\\") + ")\\\\Q");
            }
            matcher.appendTail(stringBuffer);
            stringBuffer.append("\\E$");
            this.pattern = Pattern.compile(stringBuffer.toString());
        }

        public Route matches(HttpServletRequest httpServletRequest, String string) throws IOException {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                for (int i = 0; i < this.names.size(); ++i) {
                    String string2 = this.names.get(i);
                    String string3 = matcher.group(i + 1);
                    if (hashMap.containsKey(string2)) {
                        Object v = hashMap.get(string2);
                        if (v instanceof List) {
                            ((List)v).add(string3);
                            continue;
                        }
                        ArrayList<Object> arrayList = new ArrayList<Object>(2);
                        arrayList.add(v);
                        arrayList.add(string3);
                        continue;
                    }
                    hashMap.put(string2, string3);
                }
                return new Route(this.target, hashMap);
            }
            return null;
        }
    }

    static class Config {
        public Class<? extends Container> container;
        @JSONHint(anonym="target")
        public Map<String, RouteMapping> mappings;
        public Map<String, Pattern> definitions;
        public Map<String, Integer> errors;

        Config() {
        }
    }
}

