/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.sun.jndi.ldap.LdapCtxFactory;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class LdapGroupsMapping
implements GroupMappingServiceProvider,
Configurable {
    public static final String LDAP_CONFIG_PREFIX = "hadoop.security.group.mapping.ldap";
    public static final String LDAP_URL_KEY = "hadoop.security.group.mapping.ldap.url";
    public static final String LDAP_URL_DEFAULT = "";
    public static final String LDAP_USE_SSL_KEY = "hadoop.security.group.mapping.ldap.ssl";
    public static final Boolean LDAP_USE_SSL_DEFAULT = false;
    public static final String LDAP_KEYSTORE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore";
    public static final String LDAP_KEYSTORE_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password";
    public static final String LDAP_KEYSTORE_PASSWORD_DEFAULT = "";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.ssl.keystore.password.file";
    public static final String LDAP_KEYSTORE_PASSWORD_FILE_DEFAULT = "";
    public static final String BIND_USER_KEY = "hadoop.security.group.mapping.ldap.bind.user";
    public static final String BIND_USER_DEFAULT = "";
    public static final String BIND_PASSWORD_KEY = "hadoop.security.group.mapping.ldap.bind.password";
    public static final String BIND_PASSWORD_DEFAULT = "";
    public static final String BIND_PASSWORD_FILE_KEY = "hadoop.security.group.mapping.ldap.bind.password.file";
    public static final String BIND_PASSWORD_FILE_DEFAULT = "";
    public static final String BASE_DN_KEY = "hadoop.security.group.mapping.ldap.base";
    public static final String BASE_DN_DEFAULT = "";
    public static final String USER_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.user";
    public static final String USER_SEARCH_FILTER_DEFAULT = "(&(objectClass=user)(sAMAccountName={0}))";
    public static final String GROUP_SEARCH_FILTER_KEY = "hadoop.security.group.mapping.ldap.search.filter.group";
    public static final String GROUP_SEARCH_FILTER_DEFAULT = "(objectClass=group)";
    public static final String GROUP_MEMBERSHIP_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.member";
    public static final String GROUP_MEMBERSHIP_ATTR_DEFAULT = "member";
    public static final String GROUP_NAME_ATTR_KEY = "hadoop.security.group.mapping.ldap.search.attr.group.name";
    public static final String GROUP_NAME_ATTR_DEFAULT = "cn";
    public static final String DIRECTORY_SEARCH_TIMEOUT = "hadoop.security.group.mapping.ldap.directory.search.timeout";
    public static final int DIRECTORY_SEARCH_TIMEOUT_DEFAULT = 10000;
    private static final Log LOG = LogFactory.getLog(LdapGroupsMapping.class);
    private static final SearchControls SEARCH_CONTROLS = new SearchControls();
    private DirContext ctx;
    private Configuration conf;
    private String ldapUrl;
    private boolean useSsl;
    private String keystore;
    private String keystorePass;
    private String bindUser;
    private String bindPassword;
    private String baseDN;
    private String groupSearchFilter;
    private String userSearchFilter;
    private String groupMemberAttr;
    private String groupNameAttr;
    public static int RECONNECT_RETRY_COUNT;

    @Override
    public synchronized List<String> getGroups(String user) throws IOException {
        ArrayList<String> emptyResults = new ArrayList<String>();
        try {
            return this.doGetGroups(user);
        }
        catch (CommunicationException e) {
            LOG.warn((Object)"Connection is closed, will try to reconnect");
        }
        catch (NamingException e) {
            LOG.warn((Object)("Exception trying to get groups for user " + user), (Throwable)e);
            return emptyResults;
        }
        int retryCount = 0;
        while (retryCount++ < RECONNECT_RETRY_COUNT) {
            this.ctx = null;
            try {
                return this.doGetGroups(user);
            }
            catch (CommunicationException e) {
                LOG.warn((Object)("Connection being closed, reconnecting failed, retryCount = " + retryCount));
            }
            catch (NamingException e) {
                LOG.warn((Object)("Exception trying to get groups for user " + user), (Throwable)e);
                return emptyResults;
            }
        }
        return emptyResults;
    }

    List<String> doGetGroups(String user) throws NamingException {
        ArrayList<String> groups = new ArrayList<String>();
        DirContext ctx = this.getDirContext();
        NamingEnumeration<SearchResult> results = ctx.search(this.baseDN, this.userSearchFilter, new Object[]{user}, SEARCH_CONTROLS);
        if (results.hasMoreElements()) {
            SearchResult result = (SearchResult)results.nextElement();
            String userDn = result.getNameInNamespace();
            NamingEnumeration<SearchResult> groupResults = ctx.search(this.baseDN, "(&" + this.groupSearchFilter + "(" + this.groupMemberAttr + "={0}))", new Object[]{userDn}, SEARCH_CONTROLS);
            while (groupResults.hasMoreElements()) {
                SearchResult groupResult = (SearchResult)groupResults.nextElement();
                Attribute groupName = groupResult.getAttributes().get(this.groupNameAttr);
                groups.add(groupName.get().toString());
            }
        }
        return groups;
    }

    DirContext getDirContext() throws NamingException {
        if (this.ctx == null) {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", LdapCtxFactory.class.getName());
            env.put("java.naming.provider.url", this.ldapUrl);
            env.put("java.naming.security.authentication", "simple");
            if (this.useSsl) {
                env.put("java.naming.security.protocol", "ssl");
                System.setProperty("javax.net.ssl.keyStore", this.keystore);
                System.setProperty("javax.net.ssl.keyStorePassword", this.keystorePass);
            }
            env.put("java.naming.security.principal", this.bindUser);
            env.put("java.naming.security.credentials", this.bindPassword);
            this.ctx = new InitialDirContext(env);
        }
        return this.ctx;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    @Override
    public synchronized Configuration getConf() {
        return this.conf;
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        this.ldapUrl = conf.get(LDAP_URL_KEY, "");
        if (this.ldapUrl == null || this.ldapUrl.isEmpty()) {
            throw new RuntimeException("LDAP URL is not configured");
        }
        this.useSsl = conf.getBoolean(LDAP_USE_SSL_KEY, LDAP_USE_SSL_DEFAULT);
        this.keystore = conf.get(LDAP_KEYSTORE_KEY, "");
        this.keystorePass = conf.get(LDAP_KEYSTORE_PASSWORD_KEY, "");
        if (this.keystorePass.isEmpty()) {
            this.keystorePass = this.extractPassword(conf.get(LDAP_KEYSTORE_PASSWORD_KEY, ""));
        }
        this.bindUser = conf.get(BIND_USER_KEY, "");
        this.bindPassword = conf.get(BIND_PASSWORD_KEY, "");
        if (this.bindPassword.isEmpty()) {
            this.bindPassword = this.extractPassword(conf.get(BIND_PASSWORD_FILE_KEY, ""));
        }
        this.baseDN = conf.get(BASE_DN_KEY, "");
        this.groupSearchFilter = conf.get(GROUP_SEARCH_FILTER_KEY, GROUP_SEARCH_FILTER_DEFAULT);
        this.userSearchFilter = conf.get(USER_SEARCH_FILTER_KEY, USER_SEARCH_FILTER_DEFAULT);
        this.groupMemberAttr = conf.get(GROUP_MEMBERSHIP_ATTR_KEY, GROUP_MEMBERSHIP_ATTR_DEFAULT);
        this.groupNameAttr = conf.get(GROUP_NAME_ATTR_KEY, GROUP_NAME_ATTR_DEFAULT);
        int dirSearchTimeout = conf.getInt(DIRECTORY_SEARCH_TIMEOUT, 10000);
        SEARCH_CONTROLS.setTimeLimit(dirSearchTimeout);
        this.conf = conf;
    }

    String extractPassword(String pwFile) {
        if (pwFile.isEmpty()) {
            return "";
        }
        try {
            StringBuilder password = new StringBuilder();
            FileReader reader = new FileReader(pwFile);
            int c = ((Reader)reader).read();
            while (c > -1) {
                password.append((char)c);
                c = ((Reader)reader).read();
            }
            ((Reader)reader).close();
            return password.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not read password file: " + pwFile, ioe);
        }
    }

    static {
        SEARCH_CONTROLS.setSearchScope(2);
        RECONNECT_RETRY_COUNT = 3;
    }
}

