/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.util.stats.Snapshot;
import org.apache.solr.util.stats.Timer;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable,
Closeable {
    public static final String NUM_SLICES = "numShards";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    public static final String CREATEALIAS = "createalias";
    public static final String DELETEALIAS = "deletealias";
    public static final String SPLITSHARD = "splitshard";
    public static final String DELETESHARD = "deleteshard";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String ASYNC = "async";
    public static final String CREATESHARD = "createshard";
    public static final String DELETEREPLICA = "deletereplica";
    public static final String MIGRATE = "migrate";
    public static final String REQUESTID = "requestid";
    public static final String COLL_CONF = "collection.configName";
    public static final String COLL_PROP_PREFIX = "property.";
    public int maxParallelThreads = 10;
    public static final Set<String> KNOWN_CLUSTER_PROPS = ImmutableSet.of((Object)"legacyCloud", (Object)"urlScheme");
    public static final Map<String, Object> COLL_PROPS = ZkNodeProps.makeMap((Object[])new Object[]{"router", "compositeId", "replicationFactor", "1", "maxShardsPerNode", "1", "autoAddReplicas", "false"});
    public ExecutorService tpe;
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private DistributedMap runningMap;
    private DistributedMap completedMap;
    private DistributedMap failureMap;
    private final Set runningTasks;
    private final Set collectionWip;
    private final HashMap<String, DistributedQueue.QueueEvent> completedTasks;
    private String myId;
    private final ShardHandlerFactory shardHandlerFactory;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;
    private Overseer.Stats stats;
    private final Set<String> runningZKTasks;
    private final Object waitLock = new Object();

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, Overseer.Stats stats) {
        this(zkStateReader, myId, shardHandler.getShardHandlerFactory(), adminPath, stats, Overseer.getCollectionQueue(zkStateReader.getZkClient(), stats), Overseer.getRunningMap(zkStateReader.getZkClient()), Overseer.getCompletedMap(zkStateReader.getZkClient()), Overseer.getFailureMap(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandlerFactory shardHandlerFactory, String adminPath, Overseer.Stats stats, DistributedQueue workQueue, DistributedMap runningMap, DistributedMap completedMap, DistributedMap failureMap) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandlerFactory = shardHandlerFactory;
        this.adminPath = adminPath;
        this.workQueue = workQueue;
        this.runningMap = runningMap;
        this.completedMap = completedMap;
        this.failureMap = failureMap;
        this.stats = stats;
        this.runningZKTasks = new HashSet<String>();
        this.runningTasks = new HashSet();
        this.collectionWip = new HashSet();
        this.completedTasks = new HashMap();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkExclusivity(ZkNodeProps message, String id) throws KeeperException, InterruptedException {
        String collectionName;
        String string = collectionName = message.containsKey("collection") ? message.getStr("collection") : message.getStr("name");
        if (collectionName == null) {
            return true;
        }
        if (CollectionParams.CollectionAction.CLUSTERSTATUS.isEqual(message.getStr("operation"))) {
            return true;
        }
        if (this.collectionWip.contains(collectionName)) {
            return false;
        }
        return !this.runningZKTasks.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpWorkQueue() throws KeeperException, InterruptedException {
        HashMap<String, DistributedQueue.QueueEvent> hashMap = this.completedTasks;
        synchronized (hashMap) {
            for (String id : this.completedTasks.keySet()) {
                this.workQueue.remove(this.completedTasks.get(id));
                this.runningZKTasks.remove(id);
            }
            this.completedTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.isClosed = true;
        if (this.tpe != null && !this.tpe.isShutdown()) {
            this.tpe.shutdown();
            try {
                this.tpe.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Thread interrupted while waiting for OCP threadpool shutdown.");
                Thread.currentThread().interrupt();
            }
            finally {
                if (!this.tpe.isShutdown()) {
                    this.tpe.shutdownNow();
                }
            }
        }
    }

    private synchronized void prioritizeOverseerNodes() throws KeeperException, InterruptedException {
        SolrZkClient zk = this.zkStateReader.getZkClient();
        if (!zk.exists("/roles.json", true).booleanValue()) {
            return;
        }
        Map m = (Map)ZkStateReader.fromJSON((byte[])zk.getData("/roles.json", null, new Stat(), true));
        List overseerDesignates = (List)m.get("overseer");
        if (overseerDesignates == null || overseerDesignates.isEmpty()) {
            return;
        }
        String ldr = OverseerCollectionProcessor.getLeaderNode(zk);
        if (overseerDesignates.contains(ldr)) {
            return;
        }
        log.info("prioritizing overseer nodes at {} overseer designates are {}", (Object)this.myId, (Object)overseerDesignates);
        List<String> electionNodes = OverseerCollectionProcessor.getSortedElectionNodes(zk);
        if (electionNodes.size() < 2) {
            return;
        }
        log.info("sorted nodes {}", electionNodes);
        String designateNodeId = null;
        for (String electionNode : electionNodes) {
            if (!overseerDesignates.contains(LeaderElector.getNodeName(electionNode))) continue;
            designateNodeId = electionNode;
            break;
        }
        if (designateNodeId == null) {
            log.warn("No live overseer designate ");
            return;
        }
        if (!designateNodeId.equals(electionNodes.get(1))) {
            log.info("asking node {} to come join election at head", (Object)designateNodeId);
            this.invokeOverseerOp(designateNodeId, "rejoinAtHead");
            log.info("asking the old first in line {} to rejoin election  ", (Object)electionNodes.get(1));
            this.invokeOverseerOp(electionNodes.get(1), "rejoin");
        }
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)new ZkNodeProps(new String[]{"operation", "quit", "id", OverseerCollectionProcessor.getLeaderId(this.zkStateReader.getZkClient())})));
    }

    public static List<String> getSortedOverseerNodeNames(SolrZkClient zk) throws KeeperException, InterruptedException {
        List children = null;
        try {
            children = zk.getChildren("/overseer_elect/election", null, true);
        }
        catch (Exception e) {
            log.warn("error ", (Throwable)e);
            return new ArrayList<String>();
        }
        LeaderElector.sortSeqs(children);
        ArrayList<String> nodeNames = new ArrayList<String>(children.size());
        for (String c : children) {
            nodeNames.add(LeaderElector.getNodeName(c));
        }
        return nodeNames;
    }

    public static List<String> getSortedElectionNodes(SolrZkClient zk) throws KeeperException, InterruptedException {
        List children = null;
        children = zk.getChildren("/overseer_elect/election", null, true);
        LeaderElector.sortSeqs(children);
        return children;
    }

    public static String getLeaderNode(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        String id = OverseerCollectionProcessor.getLeaderId(zkClient);
        return id == null ? null : LeaderElector.getNodeName(id);
    }

    public static String getLeaderId(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        byte[] data = null;
        try {
            data = zkClient.getData("/overseer_elect/leader", null, new Stat(), true);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        Map m = (Map)ZkStateReader.fromJSON((byte[])data);
        return (String)m.get("id");
    }

    private void invokeOverseerOp(String electionNode, String op) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.OVERSEEROP.toString()});
        params.set("op", new String[]{op});
        params.set("qt", new String[]{this.adminPath});
        params.set("electionNode", new String[]{electionNode});
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        String replica = this.zkStateReader.getBaseUrlForNodeName(LeaderElector.getNodeName(electionNode));
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        shardHandler.submit(sreq, replica, sreq.params);
        shardHandler.takeCompletedOrError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Overseer.LeaderStatus amILeader() {
        TimerContext timerContext = this.stats.time("collection_am_i_leader");
        boolean success = true;
        try {
            ZkNodeProps props = ZkNodeProps.load((byte[])this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                Overseer.LeaderStatus leaderStatus = Overseer.LeaderStatus.YES;
                return leaderStatus;
            }
        }
        catch (KeeperException e) {
            success = false;
            if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                log.error("", (Throwable)e);
                Overseer.LeaderStatus leaderStatus = Overseer.LeaderStatus.DONT_KNOW;
                return leaderStatus;
            }
            if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                log.info("", (Throwable)e);
            } else {
                log.warn("", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            success = false;
            Thread.currentThread().interrupt();
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success("collection_am_i_leader");
            } else {
                this.stats.error("collection_am_i_leader");
            }
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return Overseer.LeaderStatus.NO;
    }

    protected SolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList results;
        block20: {
            log.warn("OverseerCollectionProcessor.processMessage : " + operation + " , " + message.toString());
            results = new NamedList();
            try {
                if (CREATECOLLECTION.equals(operation)) {
                    this.createCollection(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (DELETECOLLECTION.equals(operation)) {
                    this.deleteCollection(message, results);
                    break block20;
                }
                if (RELOADCOLLECTION.equals(operation)) {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RELOAD.toString()});
                    this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, "active");
                    break block20;
                }
                if (CREATEALIAS.equals(operation)) {
                    this.createAlias(this.zkStateReader.getAliases(), message);
                    break block20;
                }
                if (DELETEALIAS.equals(operation)) {
                    this.deleteAlias(this.zkStateReader.getAliases(), message);
                    break block20;
                }
                if (SPLITSHARD.equals(operation)) {
                    this.splitShard(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (CREATESHARD.equals(operation)) {
                    this.createShard(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (DELETESHARD.equals(operation)) {
                    this.deleteShard(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (DELETEREPLICA.equals(operation)) {
                    this.deleteReplica(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (MIGRATE.equals(operation)) {
                    this.migrate(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (CollectionParams.CollectionAction.REMOVEROLE.isEqual(operation) || CollectionParams.CollectionAction.ADDROLE.isEqual(operation)) {
                    this.processRoleCommand(message, operation);
                    break block20;
                }
                if (CollectionParams.CollectionAction.ADDREPLICA.isEqual(operation)) {
                    this.addReplica(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                if (CollectionParams.CollectionAction.OVERSEERSTATUS.isEqual(operation)) {
                    this.getOverseerStatus(message, results);
                    break block20;
                }
                if (CollectionParams.CollectionAction.LIST.isEqual(operation)) {
                    this.listCollections(this.zkStateReader.getClusterState(), results);
                    break block20;
                }
                if (CollectionParams.CollectionAction.CLUSTERSTATUS.isEqual(operation)) {
                    this.getClusterStatus(this.zkStateReader.getClusterState(), message, results);
                    break block20;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            catch (Exception e) {
                String collName = message.getStr("collection");
                if (collName == null) {
                    collName = message.getStr("name");
                }
                if (collName == null) {
                    SolrException.log((Logger)log, (String)("Operation " + operation + " failed"), (Throwable)e);
                } else {
                    SolrException.log((Logger)log, (String)("Collection: " + collName + " operation: " + operation + " failed"), (Throwable)e);
                }
                results.add("Operation " + operation + " caused exception:", (Object)e);
                SimpleOrderedMap nl = new SimpleOrderedMap();
                nl.add("msg", (Object)e.getMessage());
                nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
                results.add("exception", (Object)nl);
            }
        }
        return new OverseerSolrResponse(results);
    }

    private void getOverseerStatus(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String leaderNode = OverseerCollectionProcessor.getLeaderNode(this.zkStateReader.getZkClient());
        results.add("leader", (Object)leaderNode);
        Stat stat = new Stat();
        this.zkStateReader.getZkClient().getData("/overseer/queue", null, stat, true);
        results.add("overseer_queue_size", (Object)stat.getNumChildren());
        stat = new Stat();
        this.zkStateReader.getZkClient().getData("/overseer/queue-work", null, stat, true);
        results.add("overseer_work_queue_size", (Object)stat.getNumChildren());
        stat = new Stat();
        this.zkStateReader.getZkClient().getData("/overseer/collection-queue-work", null, stat, true);
        results.add("overseer_collection_queue_size", (Object)stat.getNumChildren());
        NamedList overseerStats = new NamedList();
        NamedList collectionStats = new NamedList();
        NamedList stateUpdateQueueStats = new NamedList();
        NamedList workQueueStats = new NamedList();
        NamedList collectionQueueStats = new NamedList();
        for (Map.Entry<String, Overseer.Stat> entry : this.stats.getStats().entrySet()) {
            String key = entry.getKey();
            SimpleOrderedMap lst = new SimpleOrderedMap();
            if (key.startsWith("collection_")) {
                collectionStats.add(key.substring(11), (Object)lst);
                int successes = this.stats.getSuccessCount(entry.getKey());
                int errors = this.stats.getErrorCount(entry.getKey());
                lst.add("requests", (Object)successes);
                lst.add("errors", (Object)errors);
                List<Overseer.FailedOp> failureDetails = this.stats.getFailureDetails(key);
                if (failureDetails != null) {
                    ArrayList<SimpleOrderedMap> failures = new ArrayList<SimpleOrderedMap>();
                    for (Overseer.FailedOp failedOp : failureDetails) {
                        SimpleOrderedMap fail = new SimpleOrderedMap();
                        fail.add("request", (Object)failedOp.req.getProperties());
                        fail.add("response", (Object)failedOp.resp.getResponse());
                        failures.add(fail);
                    }
                    lst.add("recent_failures", failures);
                }
            } else if (key.startsWith("/overseer/queue_")) {
                stateUpdateQueueStats.add(key.substring(16), (Object)lst);
            } else if (key.startsWith("/overseer/queue-work_")) {
                workQueueStats.add(key.substring(21), (Object)lst);
            } else if (key.startsWith("/overseer/collection-queue-work_")) {
                collectionQueueStats.add(key.substring(32), (Object)lst);
            } else {
                overseerStats.add(key, (Object)lst);
                int successes = this.stats.getSuccessCount(entry.getKey());
                int errors = this.stats.getErrorCount(entry.getKey());
                lst.add("requests", (Object)successes);
                lst.add("errors", (Object)errors);
            }
            Timer timer = entry.getValue().requestTime;
            Snapshot snapshot = timer.getSnapshot();
            lst.add("totalTime", (Object)timer.getSum());
            lst.add("avgRequestsPerMinute", (Object)timer.getMeanRate());
            lst.add("5minRateRequestsPerMinute", (Object)timer.getFiveMinuteRate());
            lst.add("15minRateRequestsPerMinute", (Object)timer.getFifteenMinuteRate());
            lst.add("avgTimePerRequest", (Object)timer.getMean());
            lst.add("medianRequestTime", (Object)snapshot.getMedian());
            lst.add("75thPctlRequestTime", (Object)snapshot.get75thPercentile());
            lst.add("95thPctlRequestTime", (Object)snapshot.get95thPercentile());
            lst.add("99thPctlRequestTime", (Object)snapshot.get99thPercentile());
            lst.add("999thPctlRequestTime", (Object)snapshot.get999thPercentile());
        }
        results.add("overseer_operations", (Object)overseerStats);
        results.add("collection_operations", (Object)collectionStats);
        results.add("overseer_queue", (Object)stateUpdateQueueStats);
        results.add("overseer_internal_queue", (Object)workQueueStats);
        results.add("collection_queue", (Object)collectionQueueStats);
    }

    private void getClusterStatus(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("collection");
        Aliases aliases = this.zkStateReader.getAliases();
        HashMap<String, ArrayList<String>> collectionVsAliases = new HashMap<String, ArrayList<String>>();
        Map aliasVsCollections = aliases.getCollectionAliasMap();
        if (aliasVsCollections != null) {
            for (Map.Entry entry : aliasVsCollections.entrySet()) {
                List colls = StrUtils.splitSmart((String)((String)entry.getValue()), (char)',');
                String alias = (String)entry.getKey();
                for (String coll : colls) {
                    if (collection != null && !collection.equals(coll)) continue;
                    ArrayList<String> list = (ArrayList<String>)collectionVsAliases.get(coll);
                    if (list == null) {
                        list = new ArrayList<String>();
                        collectionVsAliases.put(coll, list);
                    }
                    list.add(alias);
                }
            }
        }
        Map roles = null;
        if (this.zkStateReader.getZkClient().exists("/roles.json", true).booleanValue()) {
            roles = (Map)ZkStateReader.fromJSON((byte[])this.zkStateReader.getZkClient().getData("/roles.json", null, null, true));
        }
        byte[] bytes = ZkStateReader.toJSON((Object)clusterState);
        Map stateMap = (Map)ZkStateReader.fromJSON((byte[])bytes);
        String shard = message.getStr("shard");
        SimpleOrderedMap collectionProps = new SimpleOrderedMap();
        if (collection == null) {
            Set collections = clusterState.getCollections();
            for (String name : collections) {
                Map<String, Object> collectionStatus = this.getCollectionStatus(stateMap, name, shard);
                if (collectionVsAliases.containsKey(name) && !((List)collectionVsAliases.get(name)).isEmpty()) {
                    collectionStatus.put("aliases", collectionVsAliases.get(name));
                }
                collectionProps.add(name, collectionStatus);
            }
        } else {
            String routeKey = message.getStr("_route_");
            if (routeKey == null) {
                Map<String, Object> collectionStatus = this.getCollectionStatus(stateMap, collection, shard);
                if (collectionVsAliases.containsKey(collection) && !((List)collectionVsAliases.get(collection)).isEmpty()) {
                    collectionStatus.put("aliases", collectionVsAliases.get(collection));
                }
                collectionProps.add(collection, collectionStatus);
            } else {
                DocCollection docCollection = clusterState.getCollection(collection);
                DocRouter router = docCollection.getRouter();
                Collection slices = router.getSearchSlices(routeKey, null, docCollection);
                String s = "";
                for (Slice slice : slices) {
                    s = s + slice.getName() + ",";
                }
                if (shard != null) {
                    s = s + shard;
                }
                Map<String, Object> collectionStatus = this.getCollectionStatus(stateMap, collection, s);
                if (collectionVsAliases.containsKey(collection) && !((List)collectionVsAliases.get(collection)).isEmpty()) {
                    collectionStatus.put("aliases", collectionVsAliases.get(collection));
                }
                collectionProps.add(collection, collectionStatus);
            }
        }
        List liveNodes = this.zkStateReader.getZkClient().getChildren("/live_nodes", null, true);
        this.crossCheckReplicaStateWithLiveNodes(liveNodes, (NamedList<Object>)collectionProps);
        SimpleOrderedMap clusterStatus = new SimpleOrderedMap();
        clusterStatus.add("collections", (Object)collectionProps);
        Map clusterProps = this.zkStateReader.getClusterProps();
        if (clusterProps != null && !clusterProps.isEmpty()) {
            clusterStatus.add("properties", (Object)clusterProps);
        }
        if (aliasVsCollections != null && !aliasVsCollections.isEmpty()) {
            clusterStatus.add("aliases", (Object)aliasVsCollections);
        }
        if (roles != null) {
            clusterStatus.add("roles", (Object)roles);
        }
        clusterStatus.add("live_nodes", (Object)liveNodes);
        results.add("cluster", (Object)clusterStatus);
    }

    protected void crossCheckReplicaStateWithLiveNodes(List<String> liveNodes, NamedList<Object> collectionProps) {
        for (Map.Entry next : collectionProps) {
            Map collMap = (Map)next.getValue();
            Map shards = (Map)collMap.get(SHARDS_PROP);
            for (Object nextShard : shards.values()) {
                Map shardMap = (Map)nextShard;
                Map replicas = (Map)shardMap.get("replicas");
                for (Object nextReplica : replicas.values()) {
                    String node_name;
                    Map replicaMap = (Map)nextReplica;
                    if ("down".equals(replicaMap.get("state")) || liveNodes.contains(node_name = (String)replicaMap.get("node_name"))) continue;
                    replicaMap.put("state", "down");
                }
            }
        }
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> clusterState, String name, String shardStr) {
        Map docCollection = (Map)clusterState.get(name);
        if (docCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (shardStr == null) {
            return docCollection;
        }
        Map shards = (Map)docCollection.get(SHARDS_PROP);
        HashMap selected = new HashMap();
        List<String> selectedShards = Arrays.asList(shardStr.split(","));
        for (String selectedShard : selectedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            docCollection.put(SHARDS_PROP, selected);
        }
        return docCollection;
    }

    private void listCollections(ClusterState clusterState, NamedList results) {
        Set collections = clusterState.getCollections();
        ArrayList<String> collectionList = new ArrayList<String>();
        for (String collection : collections) {
            collectionList.add(collection);
        }
        results.add("collections", collectionList);
    }

    private void processRoleCommand(ZkNodeProps message, String operation) throws KeeperException, InterruptedException {
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        Map roles = null;
        String node = message.getStr("node");
        String roleName = message.getStr("role");
        boolean nodeExists = false;
        nodeExists = zkClient.exists("/roles.json", true);
        roles = nodeExists ? (Map)ZkStateReader.fromJSON((byte[])zkClient.getData("/roles.json", null, new Stat(), true)) : new LinkedHashMap(1);
        ArrayList<String> nodeList = (ArrayList<String>)roles.get(roleName);
        if (nodeList == null) {
            nodeList = new ArrayList<String>();
            roles.put(roleName, nodeList);
        }
        if (CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
            log.info("Overseer role added to {}", (Object)node);
            if (!nodeList.contains(node)) {
                nodeList.add(node);
            }
        } else if (CollectionParams.CollectionAction.REMOVEROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
            log.info("Overseer role removed from {}", (Object)node);
            nodeList.remove(node);
        }
        if (nodeExists) {
            zkClient.setData("/roles.json", ZkStateReader.toJSON(roles), true);
        } else {
            zkClient.create("/roles.json", ZkStateReader.toJSON(roles), CreateMode.PERSISTENT, true);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    OverseerCollectionProcessor.this.prioritizeOverseerNodes();
                }
                catch (Exception e) {
                    log.error("Error in prioritizing Overseer", (Throwable)e);
                }
            }
        }.start();
    }

    private void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "replica");
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        String replicaName = message.getStr("replica");
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = coll.getSlice(shard);
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        Replica replica = slice.getReplica(replicaName);
        if (replica == null) {
            ArrayList<String> l = new ArrayList<String>();
            for (Replica r : slice.getReplicas()) {
                l.add(r.getName());
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid replica : " + replicaName + " in shard/collection : " + shard + "/" + collectionName + " available replicas are " + StrUtils.join(l, (char)','));
        }
        String baseUrl = replica.getStr("base_url");
        String core = replica.getStr("core");
        Map m = ZkNodeProps.makeMap((Object[])new Object[]{"qt", this.adminPath, "action", CoreAdminParams.CoreAdminAction.UNLOAD.toString(), "core", core, "deleteInstanceDir", "true", "deleteDataDir", "true"});
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        sreq.shards = new String[]{baseUrl};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams((SolrParams)new MapSolrParams(m));
        try {
            shardHandler.submit(sreq, baseUrl, sreq.params);
        }
        catch (Exception e) {
            log.warn("Exception trying to unload core " + sreq, (Throwable)e);
        }
        this.collectShardResponses(!Slice.ACTIVE.equals(replica.getStr(Slice.STATE)) ? new NamedList() : results, false, null, shardHandler);
        if (this.waitForCoreNodeGone(collectionName, shard, replicaName, 5000)) {
            return;
        }
        this.deleteCoreNode(collectionName, replicaName, replica, core);
        if (this.waitForCoreNodeGone(collectionName, shard, replicaName, 30000)) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not  remove replica : " + collectionName + "/" + shard + "/" + replicaName);
    }

    private boolean waitForCoreNodeGone(String collectionName, String shard, String replicaName, int timeoutms) throws InterruptedException {
        long waitUntil = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        boolean deleted = false;
        while (System.nanoTime() < waitUntil) {
            Slice slice;
            Thread.sleep(100L);
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (docCollection != null && ((slice = docCollection.getSlice(shard)) == null || slice.getReplica(replicaName) == null)) {
                deleted = true;
            }
            if (docCollection != null && !deleted) continue;
            break;
        }
        return deleted;
    }

    private void deleteCoreNode(String collectionName, String replicaName, Replica replica, String core) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "deletecore", "core", core, "node_name", replica.getStr("node_name"), "collection", collectionName, "core_node_name", replicaName});
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
    }

    private void checkRequired(ZkNodeProps message, String ... props) {
        for (String prop : props) {
            if (message.get(prop) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(Arrays.asList(props), (char)',') + " are required params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCollection(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("name");
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, null);
            ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "removecollection", "name", collection});
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
            long now = System.nanoTime();
            long timeout = now + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
            boolean removed = false;
            while (System.nanoTime() < timeout) {
                Thread.sleep(100L);
                removed = !this.zkStateReader.getClusterState().hasCollection(collection);
                if (!removed) continue;
                Thread.sleep(300L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection);
            }
        }
        finally {
            try {
                if (this.zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                    this.zkStateReader.getZkClient().clean("/collections/" + collection);
                }
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
            }
        }
    }

    private void createAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        HashMap newAliasesMap = new HashMap();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        Map prevColAliases = aliases.getCollectionAliasMap();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAlias(String name, String value) {
        long now = System.nanoTime();
        long timeout = now + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
        boolean success = false;
        Aliases aliases = null;
        while (System.nanoTime() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void checkForAliasAbsence(String name) {
        long now = System.nanoTime();
        long timeout = now + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
        boolean success = false;
        Aliases aliases = null;
        while (System.nanoTime() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void deleteAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        HashMap newAliasesMap = new HashMap();
        HashMap newCollectionAliasesMap = new HashMap();
        newCollectionAliasesMap.putAll(aliases.getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON((Object)newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private boolean createShard(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        log.info("Create shard invoked: {}", (Object)message);
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        if (collectionName == null || shard == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        int numSlices = 1;
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        DocCollection collection = clusterState.getCollection(collectionName);
        int maxShardsPerNode = collection.getInt(MAX_SHARDS_PER_NODE, Integer.valueOf(1));
        int repFactor = message.getInt(REPLICATION_FACTOR, collection.getInt(REPLICATION_FACTOR, Integer.valueOf(1)));
        String createNodeSetStr = message.getStr(CREATE_NODE_SET);
        ArrayList<Assign.Node> sortedNodeList = Assign.getNodesForNewShard(clusterState, collectionName, numSlices, maxShardsPerNode, repFactor, createNodeSetStr);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)message));
        long waitUntil = System.nanoTime() + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
        boolean created = false;
        while (System.nanoTime() < waitUntil) {
            Thread.sleep(100L);
            created = this.zkStateReader.getClusterState().getCollection(collectionName).getSlice(shard) != null;
            if (!created) continue;
        }
        if (!created) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create shard: " + message.getStr("name"));
        }
        String configName = message.getStr(COLL_CONF);
        String sliceName = shard;
        for (int j = 1; j <= repFactor; ++j) {
            String nodeName = sortedNodeList.get((int)((j - 1) % sortedNodeList.size())).nodeName;
            String shardName = collectionName + "_" + sliceName + "_replica" + j;
            log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
            params.set("name", new String[]{shardName});
            params.set(COLL_CONF, new String[]{configName});
            params.set("collection", new String[]{collectionName});
            params.set("shard", new String[]{sliceName});
            params.set(NUM_SLICES, numSlices);
            this.addPropertyParams(message, params);
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
        }
        this.processResponses(results, shardHandler);
        log.info("Finished create command on all shards for collection: " + collectionName);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean splitShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Split shard invoked");
        String collectionName = message.getStr("collection");
        String slice = message.getStr("shard");
        String splitKey = message.getStr("split.key");
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        Slice parentSlice = null;
        if (slice == null) {
            if (!(router instanceof CompositeIdRouter)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Split by route key can only be used with CompositeIdRouter or subclass. Found router: " + router.getClass().getName());
            Collection searchSlices = router.getSearchSlicesSingle(splitKey, (SolrParams)new ModifiableSolrParams(), collection);
            if (searchSlices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an active shard for split.key: " + splitKey);
            }
            if (searchSlices.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Splitting a split.key: " + splitKey + " which spans multiple shards is not supported");
            }
            parentSlice = (Slice)searchSlices.iterator().next();
            slice = parentSlice.getName();
            log.info("Split by route.key: {}, parent shard is: {} ", (Object)splitKey, (Object)slice);
        } else {
            parentSlice = clusterState.getSlice(collectionName, slice);
        }
        if (parentSlice == null) {
            if (!clusterState.hasCollection(collectionName)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collectionName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
        }
        Replica parentShardLeader = null;
        try {
            parentShardLeader = this.zkStateReader.getLeaderRetry(collectionName, slice, 10000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        Object var13_14 = null;
        String rangesStr = message.getStr("ranges");
        if (rangesStr != null) {
            String[] ranges = rangesStr.split(",");
            if (ranges.length == 0 || ranges.length == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least two ranges specified to split a shard");
            }
            ArrayList<DocRouter.Range> arrayList = new ArrayList<DocRouter.Range>(ranges.length);
            for (int i = 0; i < ranges.length; ++i) {
                String r = ranges[i];
                try {
                    arrayList.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception in parsing hexadecimal hash range: " + r, (Throwable)e);
                }
                if (((DocRouter.Range)arrayList.get(i)).isSubsetOf(range)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash range: " + r + " is not a subset of parent shard's range: " + range.toString());
            }
            ArrayList temp = new ArrayList(arrayList);
            Collections.sort(temp);
            if (!range.equals((Object)new DocRouter.Range(((DocRouter.Range)temp.get((int)0)).min, ((DocRouter.Range)temp.get((int)(temp.size() - 1))).max))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " do not cover the entire range of parent shard: " + range);
            }
            for (int i = 1; i < temp.size(); ++i) {
                if (((DocRouter.Range)temp.get((int)(i - 1))).max + 1 == ((DocRouter.Range)temp.get((int)i)).min) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " either overlap with each other or " + "do not cover the entire range of parent shard: " + range);
            }
        } else if (splitKey != null) {
            if (router instanceof CompositeIdRouter) {
                CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
                List list = compositeIdRouter.partitionRangeByKey(splitKey, range);
                if (list.size() == 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " has a hash range that is exactly equal to hash range of shard: " + slice);
                }
                for (DocRouter.Range subRange : list) {
                    if (subRange.min != subRange.max) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " must be a compositeId");
                }
                log.info("Partitioning parent shard " + slice + " range: " + parentSlice.getRange() + " yields: " + list);
                rangesStr = "";
                for (int i = 0; i < list.size(); ++i) {
                    DocRouter.Range subRange;
                    subRange = (DocRouter.Range)list.get(i);
                    rangesStr = rangesStr + subRange.toString();
                    if (i >= list.size() - 1) continue;
                    rangesStr = rangesStr + ',';
                }
            }
        } else {
            List list = router.partitionRange(2, range);
        }
        try {
            HashMap<String, String> propMap;
            int i;
            String subShardName;
            HashMap<String, String> propMap2;
            void var13_18;
            ArrayList<String> subSlices = new ArrayList<String>(var13_18.size());
            ArrayList<String> subShardNames = new ArrayList<String>(var13_18.size());
            String nodeName = parentShardLeader.getNodeName();
            for (int i2 = 0; i2 < var13_18.size(); ++i2) {
                String subSlice = slice + "_" + i2;
                subSlices.add(subSlice);
                String subShardName2 = collectionName + "_" + subSlice + "_replica1";
                subShardNames.add(subShardName2);
                Slice oSlice = clusterState.getSlice(collectionName, subSlice);
                if (oSlice == null) continue;
                if (Slice.ACTIVE.equals(oSlice.getState())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (!Slice.CONSTRUCTION.equals(oSlice.getState()) && !Slice.RECOVERY.equals(oSlice.getState())) continue;
                for (String sub : subSlices) {
                    log.info("Sub-shard: {} already exists therefore requesting its deletion", (Object)sub);
                    propMap2 = new HashMap();
                    propMap2.put("operation", DELETESHARD);
                    propMap2.put("collection", collectionName);
                    propMap2.put("shard", sub);
                    ZkNodeProps m = new ZkNodeProps(propMap2);
                    try {
                        this.deleteShard(clusterState, m, new NamedList());
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to delete already existing sub shard: " + sub, (Throwable)e);
                    }
                }
            }
            this.collectShardResponses(results, false, null, shardHandler);
            String asyncId = message.getStr(ASYNC);
            HashMap<String, String> requestMap = new HashMap<String, String>();
            for (int i3 = 0; i3 < var13_18.size(); ++i3) {
                String subSlice = (String)subSlices.get(i3);
                subShardName = (String)subShardNames.get(i3);
                DocRouter.Range subRange = (DocRouter.Range)var13_18.get(i3);
                log.info("Creating slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                propMap2 = new HashMap<String, String>();
                propMap2.put("operation", CREATESHARD);
                propMap2.put("shard", subSlice);
                propMap2.put("collection", collectionName);
                propMap2.put("shard_range", subRange.toString());
                propMap2.put("shard_state", Slice.CONSTRUCTION);
                propMap2.put("shard_parent", parentSlice.getName());
                DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                inQueue.offer(ZkStateReader.toJSON((Object)new ZkNodeProps(propMap2)));
                this.waitForNewShard(collectionName, subSlice);
                clusterState = this.zkStateReader.getClusterState();
                log.info("Adding replica " + subShardName + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                propMap2 = new HashMap();
                propMap2.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap2.put("collection", collectionName);
                propMap2.put("shard", subSlice);
                propMap2.put("node", nodeName);
                propMap2.put("name", subShardName);
                for (String key : message.keySet()) {
                    if (!key.startsWith(COLL_PROP_PREFIX)) continue;
                    propMap2.put(key, message.getStr(key));
                }
                if (asyncId != null) {
                    propMap2.put(ASYNC, asyncId);
                }
                this.addReplica(clusterState, new ZkNodeProps(propMap2), results);
            }
            this.collectShardResponses(results, true, "SPLITSHARD failed to create subshard leaders", shardHandler);
            this.completeAsyncRequest(asyncId, requestMap, results);
            for (String subShardName3 : subShardNames) {
                log.info("Asking parent leader to wait for: " + subShardName3 + " to be alive on: " + nodeName);
                String coreNodeName = this.waitForCoreNodeName(collectionName, nodeName, subShardName3);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName3);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState("active");
                cmd.setCheckLive(Boolean.valueOf(true));
                cmd.setOnlyIfLeader(true);
                ModifiableSolrParams p = new ModifiableSolrParams(cmd.getParams());
                this.setupAsyncRequest(asyncId, requestMap, p, nodeName);
                this.sendShardRequest(nodeName, p, shardHandler);
            }
            this.collectShardResponses(results, true, "SPLITSHARD timed out waiting for subshard leaders to come up", shardHandler);
            this.completeAsyncRequest(asyncId, requestMap, results);
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
            params.set("core", new String[]{parentShardLeader.getStr("core")});
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", new String[]{subShardName});
            }
            params.set("ranges", new String[]{rangesStr});
            this.setupAsyncRequest(asyncId, requestMap, params, parentShardLeader.getNodeName());
            this.sendShardRequest(parentShardLeader.getNodeName(), params, shardHandler);
            this.collectShardResponses(results, true, "SPLITSHARD failed to invoke SPLIT core admin command", shardHandler);
            this.completeAsyncRequest(asyncId, requestMap, results);
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                params.set("name", new String[]{subShardName});
                this.setupAsyncRequest(asyncId, requestMap, params, nodeName);
                this.sendShardRequest(nodeName, params, shardHandler);
            }
            this.collectShardResponses(results, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates", shardHandler);
            this.completeAsyncRequest(asyncId, requestMap, results);
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = clusterState.getSlice(collectionName, slice).getReplicas().size();
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            Collections.shuffle(nodeList);
            nodeList.remove(nodeName);
            for (int i4 = 1; i4 <= subSlices.size(); ++i4) {
                Collections.shuffle(nodeList);
                String sliceName = (String)subSlices.get(i4 - 1);
                for (int j = 2; j <= repFactor; ++j) {
                    String subShardNodeName = (String)nodeList.get((repFactor * (i4 - 1) + (j - 2)) % nodeList.size());
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating replica shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + subShardNodeName);
                    HashMap<String, String> propMap3 = new HashMap<String, String>();
                    propMap3.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                    propMap3.put("collection", collectionName);
                    propMap3.put("shard", sliceName);
                    propMap3.put("node", subShardNodeName);
                    propMap3.put("name", shardName);
                    for (String key : message.keySet()) {
                        if (!key.startsWith(COLL_PROP_PREFIX)) continue;
                        propMap3.put(key, message.getStr(key));
                    }
                    if (asyncId != null) {
                        propMap3.put(ASYNC, asyncId);
                    }
                    this.addReplica(clusterState, new ZkNodeProps(propMap3), results);
                    String coreNodeName = this.waitForCoreNodeName(collectionName, subShardNodeName, shardName);
                    log.info("Asking sub shard leader to wait for: " + shardName + " to be alive on: " + subShardNodeName);
                    CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                    cmd.setCoreName((String)subShardNames.get(i4 - 1));
                    cmd.setNodeName(subShardNodeName);
                    cmd.setCoreNodeName(coreNodeName);
                    cmd.setState("recovering");
                    cmd.setCheckLive(Boolean.valueOf(true));
                    cmd.setOnlyIfLeader(true);
                    ModifiableSolrParams p = new ModifiableSolrParams(cmd.getParams());
                    this.setupAsyncRequest(asyncId, requestMap, p, nodeName);
                    this.sendShardRequest(nodeName, p, shardHandler);
                }
            }
            this.collectShardResponses(results, true, "SPLITSHARD failed to create subshard replicas or timed out waiting for them to come up", shardHandler);
            this.completeAsyncRequest(asyncId, requestMap, results);
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            this.commit(results, slice, parentShardLeader);
            if (repFactor == 1) {
                log.info("Replication factor is 1 so switching shard states");
                DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                propMap = new HashMap<String, String>();
                propMap.put("operation", "updateshardstate");
                propMap.put(slice, Slice.INACTIVE);
                for (String subSlice : subSlices) {
                    propMap.put(subSlice, Slice.ACTIVE);
                }
                propMap.put("collection", collectionName);
                ZkNodeProps m = new ZkNodeProps(propMap);
                inQueue.offer(ZkStateReader.toJSON((Object)m));
                return true;
            } else {
                log.info("Requesting shard state be set to 'recovery'");
                DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                propMap = new HashMap();
                propMap.put("operation", "updateshardstate");
                for (String subSlice : subSlices) {
                    propMap.put(subSlice, Slice.RECOVERY);
                }
                propMap.put("collection", collectionName);
                ZkNodeProps m = new ZkNodeProps(propMap);
                inQueue.offer(ZkStateReader.toJSON((Object)m));
            }
            return true;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }

    private void commit(NamedList results, String slice, Replica parentShardLeader) {
        log.info("Calling soft commit to make sub shard updates visible");
        String coreUrl = new ZkCoreNodeProps((ZkNodeProps)parentShardLeader).getCoreUrl();
        UpdateResponse updateResponse = null;
        try {
            updateResponse = OverseerCollectionProcessor.softCommit(coreUrl);
            this.processResponse(results, null, coreUrl, (SolrResponse)updateResponse, slice);
        }
        catch (Exception e) {
            this.processResponse(results, e, coreUrl, (SolrResponse)updateResponse, slice);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib softCommit on: " + coreUrl, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UpdateResponse softCommit(String url) throws SolrServerException, IOException {
        HttpSolrServer server = null;
        try {
            server = new HttpSolrServer(url);
            server.setConnectionTimeout(30000);
            server.setSoTimeout(120000);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true, true);
            UpdateResponse updateResponse = ureq.process((SolrServer)server);
            return updateResponse;
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
    }

    private String waitForCoreNodeName(String collectionName, String msgNodeName, String msgCore) {
        int retryCount = 320;
        while (retryCount-- > 0) {
            Map slicesMap = this.zkStateReader.getClusterState().getSlicesMap(collectionName);
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find coreNodeName");
    }

    private void waitForNewShard(String collectionName, String sliceName) throws KeeperException, InterruptedException {
        log.info("Waiting for slice {} of collection {} to be available", (Object)sliceName, (Object)collectionName);
        long startTime = System.currentTimeMillis();
        int retryCount = 320;
        while (retryCount-- > 0) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find collection: " + collectionName + " in clusterstate");
            }
            Slice slice = collection.getSlice(sliceName);
            if (slice != null) {
                log.info("Waited for {} seconds for slice {} of collection {} to be available", new Object[]{(System.currentTimeMillis() - startTime) / 1000L, sliceName, collectionName});
                return;
            }
            Thread.sleep(1000L);
            this.zkStateReader.updateClusterState(true);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find new slice " + sliceName + " in collection " + collectionName + " even after waiting for " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
    }

    private void collectShardResponses(NamedList results, boolean abortOnError, String msgOnError, ShardHandler shardHandler) {
        ShardResponse srsp;
        do {
            if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
            Throwable exception = srsp.getException();
            if (!abortOnError || exception == null) continue;
            while (srsp != null) {
                srsp = shardHandler.takeCompletedOrError();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
        } while (srsp != null);
    }

    private void deleteShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Delete shard invoked");
        String collection = message.getStr("collection");
        String sliceId = message.getStr("shard");
        Slice slice = clusterState.getSlice(collection, sliceId);
        if (slice == null) {
            if (clusterState.hasCollection(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collection);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collection);
        }
        if (!(slice.getRange() == null || slice.getState().equals(Slice.INACTIVE) || slice.getState().equals(Slice.RECOVERY) || slice.getState().equals(Slice.CONSTRUCTION))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The slice: " + slice.getName() + " is currently " + slice.getState() + ". Only non-active (or custom-hashed) slices can be deleted.");
        }
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteIndex", new String[]{"true"});
            this.sliceCmd(clusterState, params, null, slice, shardHandler);
            this.processResponses(results, shardHandler);
            ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "removeshard", "collection", collection, "shard", sliceId});
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
            long now = System.nanoTime();
            long timeout = now + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
            boolean removed = false;
            while (System.nanoTime() < timeout) {
                Thread.sleep(100L);
                removed = this.zkStateReader.getClusterState().getSlice(collection, sliceId) == null;
                if (!removed) continue;
                Thread.sleep(100L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection + " shard: " + sliceId);
            }
            log.info("Successfully deleted collection: " + collection + ", shard: " + sliceId);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing delete operation for collection: " + collection + " shard: " + sliceId, (Throwable)e);
        }
    }

    private void migrate(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String sourceCollectionName = message.getStr("collection");
        String splitKey = message.getStr("split.key");
        String targetCollectionName = message.getStr("target.collection");
        int timeout = message.getInt("forward.timeout", Integer.valueOf(600)) * 1000;
        DocCollection sourceCollection = clusterState.getCollection(sourceCollectionName);
        if (sourceCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown source collection: " + sourceCollectionName);
        }
        DocCollection targetCollection = clusterState.getCollection(targetCollectionName);
        if (targetCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown target collection: " + sourceCollectionName);
        }
        if (!(sourceCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection must use a compositeId router");
        }
        if (!(targetCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target collection must use a compositeId router");
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        CompositeIdRouter targetRouter = (CompositeIdRouter)targetCollection.getRouter();
        Collection sourceSlices = sourceRouter.getSearchSlicesSingle(splitKey, null, sourceCollection);
        if (sourceSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in source collection: " + sourceCollection + "for given split.key: " + splitKey);
        }
        Collection targetSlices = targetRouter.getSearchSlicesSingle(splitKey, null, targetCollection);
        if (targetSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in target collection: " + targetCollection + "for given split.key: " + splitKey);
        }
        String asyncId = null;
        if (message.containsKey(ASYNC) && message.get(ASYNC) != null) {
            asyncId = message.getStr(ASYNC);
        }
        for (Slice sourceSlice : sourceSlices) {
            for (Slice targetSlice : targetSlices) {
                log.info("Migrating source shard: {} to target shard: {} for split.key = " + splitKey, (Object)sourceSlice, (Object)targetSlice);
                this.migrateKey(clusterState, sourceCollection, sourceSlice, targetCollection, targetSlice, splitKey, timeout, results, asyncId, message);
            }
        }
    }

    private void migrateKey(ClusterState clusterState, DocCollection sourceCollection, Slice sourceSlice, DocCollection targetCollection, Slice targetSlice, String splitKey, int timeout, NamedList results, String asyncId, ZkNodeProps message) throws KeeperException, InterruptedException {
        String tempSourceCollectionName = "split_" + sourceSlice.getName() + "_temp_" + targetSlice.getName();
        if (clusterState.hasCollection(tempSourceCollectionName)) {
            log.info("Deleting temporary collection: " + tempSourceCollectionName);
            Map props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", DELETECOLLECTION, "name", tempSourceCollectionName});
            try {
                this.deleteCollection(new ZkNodeProps(props), results);
                clusterState = this.zkStateReader.getClusterState();
            }
            catch (Exception e) {
                log.warn("Unable to clean up existing temporary collection: " + tempSourceCollectionName, (Throwable)e);
            }
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        DocRouter.Range keyHashRange = sourceRouter.keyHashRange(splitKey);
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        log.info("Hash range for split.key: {} is: {}", (Object)splitKey, (Object)keyHashRange);
        DocRouter.Range splitRange = this.intersect(targetSlice.getRange(), this.intersect(sourceSlice.getRange(), keyHashRange));
        if (splitRange == null) {
            log.info("No common hashes between source shard: {} and target shard: {}", (Object)sourceSlice.getName(), (Object)targetSlice.getName());
            return;
        }
        log.info("Common hash range between source shard: {} and target shard: {} = " + splitRange, (Object)sourceSlice.getName(), (Object)targetSlice.getName());
        Replica targetLeader = this.zkStateReader.getLeaderRetry(targetCollection.getName(), targetSlice.getName(), 10000);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        log.info("Asking target leader node: " + targetLeader.getNodeName() + " core: " + targetLeader.getStr("core") + " to buffer updates");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES.toString()});
        params.set("name", new String[]{targetLeader.getStr("core")});
        String nodeName = targetLeader.getNodeName();
        this.setupAsyncRequest(asyncId, requestMap, params, nodeName);
        this.sendShardRequest(targetLeader.getNodeName(), params, shardHandler);
        this.collectShardResponses(results, true, "MIGRATE failed to request node to buffer updates", shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
        ZkNodeProps m = new ZkNodeProps(new String[]{"operation", "addroutingrule", "collection", sourceCollection.getName(), "shard", sourceSlice.getName(), "routeKey", SolrIndexSplitter.getRouteKey(splitKey) + "!", "range", splitRange.toString(), "targetCollection", targetCollection.getName(), "expireAt", String.valueOf(System.currentTimeMillis() + (long)timeout)});
        log.info("Adding routing rule: " + m);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)m));
        log.info("Waiting to see routing rule updated in clusterstate");
        long waitUntil = System.nanoTime() + TimeUnit.NANOSECONDS.convert(60L, TimeUnit.SECONDS);
        boolean added = false;
        while (System.nanoTime() < waitUntil) {
            RoutingRule rule;
            Thread.sleep(100L);
            Map rules = this.zkStateReader.getClusterState().getSlice(sourceCollection.getName(), sourceSlice.getName()).getRoutingRules();
            if (rules == null || (rule = (RoutingRule)rules.get(SolrIndexSplitter.getRouteKey(splitKey) + "!")) == null || !rule.getRouteRanges().contains(splitRange)) continue;
            added = true;
            break;
        }
        if (!added) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not add routing rule: " + m);
        }
        log.info("Routing rule added successfully");
        Replica sourceLeader = this.zkStateReader.getLeaderRetry(sourceCollection.getName(), sourceSlice.getName(), 10000);
        String configName = this.zkStateReader.readConfigName(sourceCollection.getName());
        Map<String, String> props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", CREATECOLLECTION, "name", tempSourceCollectionName, REPLICATION_FACTOR, 1, NUM_SLICES, 1, COLL_CONF, configName, CREATE_NODE_SET, sourceLeader.getNodeName()});
        if (asyncId != null) {
            String internalAsyncId = asyncId + Math.abs(System.nanoTime());
            props.put(ASYNC, internalAsyncId);
        }
        log.info("Creating temporary collection: " + props);
        this.createCollection(clusterState, new ZkNodeProps((Map)props), results);
        clusterState = this.zkStateReader.getClusterState();
        Slice tempSourceSlice = (Slice)clusterState.getCollection(tempSourceCollectionName).getSlices().iterator().next();
        Replica tempSourceLeader = this.zkStateReader.getLeaderRetry(tempSourceCollectionName, tempSourceSlice.getName(), 120000);
        String tempCollectionReplica1 = tempSourceCollectionName + "_" + tempSourceSlice.getName() + "_replica1";
        String coreNodeName = this.waitForCoreNodeName(tempSourceCollectionName, sourceLeader.getNodeName(), tempCollectionReplica1);
        log.info("Asking source leader to wait for: " + tempCollectionReplica1 + " to be alive on: " + sourceLeader.getNodeName());
        CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempCollectionReplica1);
        cmd.setNodeName(sourceLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState("active");
        cmd.setCheckLive(Boolean.valueOf(true));
        cmd.setOnlyIfLeader(true);
        this.sendShardRequest(tempSourceLeader.getNodeName(), new ModifiableSolrParams(cmd.getParams()), shardHandler);
        this.collectShardResponses(results, true, "MIGRATE failed to create temp collection leader or timed out waiting for it to come up", shardHandler);
        log.info("Asking source leader to split index");
        params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
        params.set("core", new String[]{sourceLeader.getStr("core")});
        params.add("targetCore", new String[]{tempSourceLeader.getStr("core")});
        params.set("ranges", new String[]{splitRange.toString()});
        params.set("split.key", new String[]{splitKey});
        String tempNodeName = sourceLeader.getNodeName();
        this.setupAsyncRequest(asyncId, requestMap, params, tempNodeName);
        this.sendShardRequest(tempNodeName, params, shardHandler);
        this.collectShardResponses(results, true, "MIGRATE failed to invoke SPLIT core admin command", shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
        log.info("Creating a replica of temporary collection: {} on the target leader node: {}", (Object)tempSourceCollectionName, (Object)targetLeader.getNodeName());
        String tempCollectionReplica2 = tempSourceCollectionName + "_" + tempSourceSlice.getName() + "_replica2";
        props = new HashMap<String, String>();
        props.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
        props.put("collection", tempSourceCollectionName);
        props.put("shard", tempSourceSlice.getName());
        props.put("node", targetLeader.getNodeName());
        props.put("name", tempCollectionReplica2);
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            props.put(key, message.getStr(key));
        }
        if (asyncId != null) {
            props.put(ASYNC, asyncId);
        }
        this.addReplica(clusterState, new ZkNodeProps(props), results);
        this.collectShardResponses(results, true, "MIGRATE failed to create replica of temporary collection in target leader node.", shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
        coreNodeName = this.waitForCoreNodeName(tempSourceCollectionName, targetLeader.getNodeName(), tempCollectionReplica2);
        log.info("Asking temp source leader to wait for: " + tempCollectionReplica2 + " to be alive on: " + targetLeader.getNodeName());
        cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempSourceLeader.getStr("core"));
        cmd.setNodeName(targetLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState("active");
        cmd.setCheckLive(Boolean.valueOf(true));
        cmd.setOnlyIfLeader(true);
        params = new ModifiableSolrParams(cmd.getParams());
        this.setupAsyncRequest(asyncId, requestMap, params, tempSourceLeader.getNodeName());
        this.sendShardRequest(tempSourceLeader.getNodeName(), params, shardHandler);
        this.collectShardResponses(results, true, "MIGRATE failed to create temp collection replica or timed out waiting for them to come up", shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
        log.info("Successfully created replica of temp source collection on target leader node");
        log.info("Requesting merge of temp source collection replica to target leader");
        params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.MERGEINDEXES.toString()});
        params.set("core", new String[]{targetLeader.getStr("core")});
        params.set("srcCore", new String[]{tempCollectionReplica2});
        this.setupAsyncRequest(asyncId, requestMap, params, sourceLeader.getNodeName());
        this.sendShardRequest(targetLeader.getNodeName(), params, shardHandler);
        this.collectShardResponses(results, true, "MIGRATE failed to merge " + tempCollectionReplica2 + " to " + targetLeader.getStr("core") + " on node: " + targetLeader.getNodeName(), shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
        log.info("Asking target leader to apply buffered updates");
        params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
        params.set("name", new String[]{targetLeader.getStr("core")});
        this.setupAsyncRequest(asyncId, requestMap, params, targetLeader.getNodeName());
        this.sendShardRequest(targetLeader.getNodeName(), params, shardHandler);
        this.collectShardResponses(results, true, "MIGRATE failed to request node to apply buffered updates", shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
        try {
            log.info("Deleting temporary collection: " + tempSourceCollectionName);
            props = ZkNodeProps.makeMap((Object[])new Object[]{"operation", DELETECOLLECTION, "name", tempSourceCollectionName});
            this.deleteCollection(new ZkNodeProps(props), results);
        }
        catch (Exception e) {
            log.error("Unable to delete temporary collection: " + tempSourceCollectionName + ". Please remove it manually", (Throwable)e);
        }
    }

    private void completeAsyncRequest(String asyncId, HashMap<String, String> requestMap, NamedList results) {
        if (asyncId != null) {
            this.waitForAsyncCallsToComplete(requestMap, results);
            requestMap.clear();
        }
    }

    private void setupAsyncRequest(String asyncId, HashMap<String, String> requestMap, ModifiableSolrParams params, String nodeName) {
        if (asyncId != null) {
            String coreAdminAsyncId = asyncId + Math.abs(System.nanoTime());
            params.set(ASYNC, new String[]{coreAdminAsyncId});
            requestMap.put(nodeName, coreAdminAsyncId);
        }
    }

    private DocRouter.Range intersect(DocRouter.Range a, DocRouter.Range b) {
        if (a == null || b == null || !a.overlaps(b)) {
            return null;
        }
        if (a.isSubsetOf(b)) {
            return a;
        }
        if (b.isSubsetOf(a)) {
            return b;
        }
        if (b.includes(a.max)) {
            return new DocRouter.Range(b.min, a.max);
        }
        return new DocRouter.Range(a.min, b.max);
    }

    private void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler) {
        ShardRequest sreq = new ShardRequest();
        params.set("qt", new String[]{this.adminPath});
        sreq.purpose = 1;
        String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        shardHandler.submit(sreq, replica, sreq.params);
    }

    private void addPropertyParams(ZkNodeProps message, ModifiableSolrParams params) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            params.set(key, new String[]{message.getStr(key)});
        }
    }

    private void createCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("name");
        if (clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        String configName = this.getConfigName(collectionName, message);
        if (configName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No config set found to associate with the collection.");
        }
        if (!this.validateConfig(configName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find the specified config set: " + configName);
        }
        try {
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            List createNodeList;
            int repFactor = message.getInt(REPLICATION_FACTOR, Integer.valueOf(1));
            ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
            String async = null;
            async = message.getStr(ASYNC);
            Integer numSlices = message.getInt(NUM_SLICES, null);
            String router = message.getStr("router.name", "compositeId");
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(router)) {
                Overseer.getShardNames(shardNames, message.getStr(SHARDS_PROP, null));
                numSlices = shardNames.size();
            } else {
                Overseer.getShardNames(numSlices, shardNames);
            }
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param (when using CompositeId router).");
            }
            int maxShardsPerNode = message.getInt(MAX_SHARDS_PER_NODE, Integer.valueOf(1));
            String createNodeSetStr = message.getStr(CREATE_NODE_SET);
            List list = createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart((String)createNodeSetStr, (String)",", (boolean)true);
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "replicationFactor must be greater than 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            if (createNodeList != null) {
                nodeList.retainAll(createNodeList);
            }
            Collections.shuffle(nodeList);
            if (nodeList.size() <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". No live Solr-instances" + (createNodeList != null ? " among Solr-instances specified in createNodeSet:" + createNodeSetStr : ""));
            }
            if (repFactor > nodeList.size()) {
                log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or part of your " + CREATE_NODE_SET + "(" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + MAX_SHARDS_PER_NODE + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + REPLICATION_FACTOR + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
            }
            boolean isLegacyCloud = Overseer.isLegacy(this.zkStateReader.getClusterProps());
            this.createConfNode(configName, collectionName, isLegacyCloud);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)message));
            long waitUntil = System.nanoTime() + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
            boolean created = false;
            while (System.nanoTime() < waitUntil) {
                Thread.sleep(100L);
                created = this.zkStateReader.getClusterState().getCollections().contains(message.getStr("name"));
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully createcollection: " + message.getStr("name"));
            }
            HashMap<String, String> requestMap = new HashMap<String, String>();
            log.info("Creating SolrCores for new collection {}, shardNames {} , replicationFactor : {}", new Object[]{collectionName, shardNames, repFactor});
            LinkedHashMap<String, ShardRequest> coresToCreate = new LinkedHashMap<String, ShardRequest>();
            for (int i = 1; i <= shardNames.size(); ++i) {
                String sliceName = (String)shardNames.get(i - 1);
                for (int j = 1; j <= repFactor; ++j) {
                    String nodeName = (String)nodeList.get((repFactor * (i - 1) + (j - 1)) % nodeList.size());
                    String coreName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating shard " + coreName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    String baseUrl = this.zkStateReader.getBaseUrlForNodeName(nodeName);
                    if (!isLegacyCloud) {
                        ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collectionName, "shard", sliceName, "core", coreName, "state", "down", "base_url", baseUrl});
                        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)props));
                    }
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
                    params.set("name", new String[]{coreName});
                    params.set(COLL_CONF, new String[]{configName});
                    params.set("collection", new String[]{collectionName});
                    params.set("shard", new String[]{sliceName});
                    params.set(NUM_SLICES, numSlices.intValue());
                    this.setupAsyncRequest(async, requestMap, params, nodeName);
                    this.addPropertyParams(message, params);
                    ShardRequest sreq = new ShardRequest();
                    params.set("qt", new String[]{this.adminPath});
                    sreq.purpose = 1;
                    sreq.shards = new String[]{baseUrl};
                    sreq.actualShards = sreq.shards;
                    sreq.params = params;
                    if (isLegacyCloud) {
                        shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                        continue;
                    }
                    coresToCreate.put(coreName, sreq);
                }
            }
            if (!isLegacyCloud) {
                Map<String, Replica> replicas = this.waitToSeeReplicasInState(collectionName, coresToCreate.keySet());
                for (Map.Entry e : coresToCreate.entrySet()) {
                    ShardRequest sreq = (ShardRequest)e.getValue();
                    sreq.params.set("coreNodeName", new String[]{replicas.get(e.getKey()).getName()});
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                }
            }
            this.processResponses(results, shardHandler);
            this.completeAsyncRequest(async, requestMap, results);
            log.info("Finished create command on all shards for collection: " + collectionName);
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private Map<String, Replica> waitToSeeReplicasInState(String collectionName, Collection<String> coreNames) throws InterruptedException {
        HashMap<String, Replica> result = new HashMap<String, Replica>();
        long endTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
        while (true) {
            DocCollection coll = this.zkStateReader.getClusterState().getCollection(collectionName);
            for (String coreName : coreNames) {
                if (result.containsKey(coreName)) continue;
                block2: for (Slice slice : coll.getSlices()) {
                    for (Replica replica : slice.getReplicas()) {
                        if (!coreName.equals(replica.getStr("core"))) continue;
                        result.put(coreName, replica);
                        continue block2;
                    }
                }
            }
            if (result.size() == coreNames.size()) {
                return result;
            }
            if (System.nanoTime() > endTime) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out waiting to see all replicas in cluster state.");
            }
            Thread.sleep(100L);
        }
    }

    private void addReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("collection");
        String node = message.getStr("node");
        String shard = message.getStr("shard");
        String coreName = message.getStr("name");
        String asyncId = message.getStr(ASYNC);
        DocCollection coll = clusterState.getCollection(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " does not exist");
        }
        if (coll.getSlice(shard) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " shard: " + shard + " does not exist");
        }
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        if (node == null) {
            node = Assign.getNodesForNewShard((ClusterState)clusterState, (String)collection, (int)coll.getSlices().size(), (int)coll.getInt((String)MAX_SHARDS_PER_NODE, (Integer)Integer.valueOf((int)1)).intValue(), (int)coll.getInt((String)REPLICATION_FACTOR, (Integer)Integer.valueOf((int)1)).intValue(), null).get((int)0).nodeName;
            log.info("Node not provided, Identified {} for creating new replica", (Object)node);
        }
        if (!clusterState.liveNodesContain(node)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Node: " + node + " is not live");
        }
        if (coreName == null) {
            Slice slice = coll.getSlice(shard);
            int replicaNum = slice.getReplicas().size();
            while (true) {
                String replicaName = collection + "_" + shard + "_replica" + replicaNum;
                boolean exists = false;
                for (Replica replica : slice.getReplicas()) {
                    if (!replicaName.equals(replica.getStr("core"))) continue;
                    exists = true;
                    break;
                }
                if (!exists) break;
                ++replicaNum;
            }
            coreName = collection + "_" + shard + "_replica" + replicaNum;
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (!Overseer.isLegacy(this.zkStateReader.getClusterProps())) {
            ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collection, "shard", shard, "core", coreName, "state", "down", "base_url", this.zkStateReader.getBaseUrlForNodeName(node)});
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON((Object)props));
            params.set("coreNodeName", new String[]{this.waitToSeeReplicasInState(collection, Collections.singletonList(coreName)).get(coreName).getName()});
        }
        String configName = this.zkStateReader.readConfigName(collection);
        String routeKey = message.getStr("_route_");
        String dataDir = message.getStr("dataDir");
        String instanceDir = message.getStr("instanceDir");
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.CREATE.toString()});
        params.set("name", new String[]{coreName});
        params.set(COLL_CONF, new String[]{configName});
        params.set("collection", new String[]{collection});
        if (shard != null) {
            params.set("shard", new String[]{shard});
        } else if (routeKey != null) {
            Collection slices = coll.getRouter().getSearchSlicesSingle(routeKey, null, coll);
            if (slices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active shard serving _route_=" + routeKey + " found");
            }
            params.set("shard", new String[]{((Slice)slices.iterator().next()).getName()});
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify either 'shard' or _route_ param");
        }
        if (dataDir != null) {
            params.set("dataDir", new String[]{dataDir});
        }
        if (instanceDir != null) {
            params.set("instanceDir", new String[]{instanceDir});
        }
        this.addPropertyParams(message, params);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        this.setupAsyncRequest(asyncId, requestMap, params, node);
        this.sendShardRequest(node, params, shardHandler);
        this.collectShardResponses(results, true, "ADDREPLICA failed to create replica", shardHandler);
        this.completeAsyncRequest(asyncId, requestMap, results);
    }

    private void processResponses(NamedList results, ShardHandler shardHandler) {
        ShardResponse srsp;
        do {
            if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
    }

    private String getConfigName(String coll, ZkNodeProps message) throws KeeperException, InterruptedException {
        String configName = message.getStr(COLL_CONF);
        if (configName == null) {
            List configNames = null;
            try {
                configNames = this.zkStateReader.getZkClient().getChildren("/configs", null, true);
                if (configNames != null && configNames.size() == 1) {
                    configName = (String)configNames.get(0);
                    log.info("Only one config set found in zk - using it:" + configName);
                }
            }
            catch (KeeperException.NoNodeException e) {
                // empty catch block
            }
        }
        return configName;
    }

    private boolean validateConfig(String configName) throws KeeperException, InterruptedException {
        return this.zkStateReader.getZkClient().exists("/configs/" + configName, true);
    }

    private void createConfNode(String configName, String coll, boolean isLegacyCloud) throws KeeperException, InterruptedException {
        if (configName != null) {
            log.info("creating collections conf node {} ", (Object)("/collections/" + coll));
            this.zkStateReader.getZkClient().makePath("/collections/" + coll, ZkStateReader.toJSON((Object)ZkNodeProps.makeMap((Object[])new Object[]{"configName", configName})), true);
        } else if (isLegacyCloud) {
            log.warn("Could not obtain config name");
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to get config name");
        }
    }

    private void collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params, NamedList results, String stateMatcher) {
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        DocCollection coll = clusterState.getCollection(collectionName);
        for (Map.Entry entry : coll.getSlicesMap().entrySet()) {
            Slice slice = (Slice)entry.getValue();
            this.sliceCmd(clusterState, params, stateMatcher, slice, shardHandler);
        }
        this.processResponses(results, shardHandler);
    }

    private void sliceCmd(ClusterState clusterState, ModifiableSolrParams params, String stateMatcher, Slice slice, ShardHandler shardHandler) {
        Map shards = slice.getReplicasMap();
        Set shardEntries = shards.entrySet();
        for (Map.Entry shardEntry : shardEntries) {
            ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
            if (!clusterState.liveNodesContain(node.getStr("node_name")) || stateMatcher != null && !node.getStr("state").equals(stateMatcher)) continue;
            ModifiableSolrParams cloneParams = new ModifiableSolrParams();
            cloneParams.add((SolrParams)params);
            cloneParams.set("core", new String[]{node.getStr("core")});
            String replica = node.getStr("base_url");
            ShardRequest sreq = new ShardRequest();
            sreq.nodeName = node.getStr("node_name");
            cloneParams.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = cloneParams;
            log.info("Collection Admin sending CoreAdmin cmd to " + replica + " params:" + sreq.params);
            shardHandler.submit(sreq, replica, sreq.params);
        }
    }

    private void processResponse(NamedList results, ShardResponse srsp) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        this.processResponse(results, e, nodeName, solrResponse, shard);
    }

    private void processResponse(NamedList results, Throwable e, String nodeName, SolrResponse solrResponse, String shard) {
        if (e != null) {
            log.error("Error from shard: " + shard, e);
            SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap();
                results.add("failure", (Object)failure);
            }
            failure.add(nodeName, (Object)(e.getClass().getName() + ":" + e.getMessage()));
        } else {
            SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap();
                results.add("success", (Object)success);
            }
            success.add(nodeName, (Object)solrResponse.getResponse());
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void waitForAsyncCallsToComplete(Map<String, String> requestMap, NamedList results) {
        for (String k : requestMap.keySet()) {
            log.debug("I am Waiting for :{}/{}", (Object)k, (Object)requestMap.get(k));
            results.add(requestMap.get(k), (Object)this.waitForCoreAdminAsyncCallToComplete(k, requestMap.get(k)));
        }
    }

    private NamedList waitForCoreAdminAsyncCallToComplete(String nodeName, String requestId) {
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTSTATUS.toString()});
        params.set(REQUESTID, new String[]{requestId});
        int counter = 0;
        block4: while (true) {
            ShardResponse srsp;
            ShardRequest sreq = new ShardRequest();
            params.set("qt", new String[]{this.adminPath});
            sreq.purpose = 1;
            String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                NamedList results = new NamedList();
                this.processResponse(results, srsp);
                String r = (String)srsp.getSolrResponse().getResponse().get("STATUS");
                if (r.equals("running")) {
                    log.debug("The task is still RUNNING, continuing to wait.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (r.equals("completed")) {
                    log.debug("The task is COMPLETED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("failed")) {
                    log.debug("The task is FAILED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("notfound")) {
                    log.debug("The task is notfound, retry");
                    if (counter++ < 5) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                        continue block4;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request: " + srsp.getSolrResponse().getResponse().get("STATUS") + "retried " + counter + "times");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request " + srsp.getSolrResponse().getResponse().get("STATUS"));
            } while (srsp != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markTaskAsRunning(DistributedQueue.QueueEvent head, String collectionName, String asyncId, ZkNodeProps message) throws KeeperException, InterruptedException {
        Set set = this.runningZKTasks;
        synchronized (set) {
            this.runningZKTasks.add(head.getId());
        }
        set = this.runningTasks;
        synchronized (set) {
            this.runningTasks.add(head.getId());
        }
        if (!CollectionParams.CollectionAction.CLUSTERSTATUS.isEqual(message.getStr("operation")) && collectionName != null) {
            set = this.collectionWip;
            synchronized (set) {
                this.collectionWip.add(collectionName);
            }
        }
        if (asyncId != null) {
            this.runningMap.put(asyncId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTrackingMaps() {
        if (log.isDebugEnabled()) {
            Set<String> set = this.runningTasks;
            synchronized (set) {
                log.debug("RunningTasks: {}", (Object)this.runningTasks.toString());
            }
            set = this.completedTasks;
            synchronized (set) {
                log.debug("CompletedTasks: {}", (Object)this.completedTasks.keySet().toString());
            }
            set = this.runningZKTasks;
            synchronized (set) {
                log.debug("RunningZKTasks: {}", (Object)this.runningZKTasks.toString());
            }
        }
    }

    String getId() {
        return this.myId;
    }

    protected class Runner
    implements Runnable {
        ZkNodeProps message;
        String operation;
        SolrResponse response;
        DistributedQueue.QueueEvent head;

        public Runner(ZkNodeProps message, String operation, DistributedQueue.QueueEvent head) {
            this.message = message;
            this.operation = operation;
            this.head = head;
            this.response = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimerContext timerContext = OverseerCollectionProcessor.this.stats.time("collection_" + this.operation);
            boolean success = false;
            String asyncId = this.message.getStr(OverseerCollectionProcessor.ASYNC);
            String collectionName = this.message.containsKey("collection") ? this.message.getStr("collection") : this.message.getStr("name");
            try {
                try {
                    log.debug("Runner processing {}", (Object)this.head.getId());
                    this.response = OverseerCollectionProcessor.this.processMessage(this.message, this.operation);
                }
                finally {
                    timerContext.stop();
                    this.updateStats();
                }
                if (asyncId != null) {
                    if (this.response != null && (this.response.getResponse().get("failure") != null || this.response.getResponse().get("exception") != null)) {
                        OverseerCollectionProcessor.this.failureMap.put(asyncId, null);
                        log.debug("Updated failed map for task with zkid:[{}]", (Object)this.head.getId());
                    } else {
                        OverseerCollectionProcessor.this.completedMap.put(asyncId, null);
                        log.debug("Updated completed map for task with zkid:[{}]", (Object)this.head.getId());
                    }
                } else {
                    this.head.setBytes(SolrResponse.serializable((SolrResponse)this.response));
                    log.debug("Completed task:[{}]", (Object)this.head.getId());
                }
                this.markTaskComplete(this.head.getId(), asyncId, collectionName);
                log.debug("Marked task [{}] as completed.", (Object)this.head.getId());
                OverseerCollectionProcessor.this.printTrackingMaps();
                log.info("Overseer Collection Processor: Message id:" + this.head.getId() + " complete, response:" + this.response.getResponse().toString());
                success = true;
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)"", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.resetTaskWithException(this.head.getId(), asyncId, collectionName);
                log.warn("Resetting task {} as the thread was interrupted.", (Object)this.head.getId());
                Thread.currentThread().interrupt();
            }
            finally {
                if (!success) {
                    this.resetTaskWithException(this.head.getId(), asyncId, collectionName);
                }
                Object e = OverseerCollectionProcessor.this.waitLock;
                synchronized (e) {
                    OverseerCollectionProcessor.this.waitLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markTaskComplete(String id, String asyncId, String collectionName) throws KeeperException, InterruptedException {
            Object object = OverseerCollectionProcessor.this.completedTasks;
            synchronized (object) {
                OverseerCollectionProcessor.this.completedTasks.put(id, this.head);
            }
            object = OverseerCollectionProcessor.this.runningTasks;
            synchronized (object) {
                OverseerCollectionProcessor.this.runningTasks.remove(id);
            }
            if (asyncId != null) {
                OverseerCollectionProcessor.this.runningMap.remove(asyncId);
            }
            if (!CollectionParams.CollectionAction.CLUSTERSTATUS.isEqual(this.operation) && collectionName != null) {
                object = OverseerCollectionProcessor.this.collectionWip;
                synchronized (object) {
                    OverseerCollectionProcessor.this.collectionWip.remove(collectionName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetTaskWithException(String id, String asyncId, String collectionName) {
            block10: {
                log.warn("Resetting task: {}, requestid: {}, collectionName: {}", new Object[]{id, asyncId, collectionName});
                try {
                    if (asyncId != null) {
                        OverseerCollectionProcessor.this.runningMap.remove(asyncId);
                    }
                    Set set = OverseerCollectionProcessor.this.runningTasks;
                    synchronized (set) {
                        OverseerCollectionProcessor.this.runningTasks.remove(id);
                    }
                    if (CollectionParams.CollectionAction.CLUSTERSTATUS.isEqual(this.operation) || collectionName == null) break block10;
                    set = OverseerCollectionProcessor.this.collectionWip;
                    synchronized (set) {
                        OverseerCollectionProcessor.this.collectionWip.remove(collectionName);
                    }
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, (String)"", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private void updateStats() {
            if (this.isSuccessful()) {
                OverseerCollectionProcessor.this.stats.success("collection_" + this.operation);
            } else {
                OverseerCollectionProcessor.this.stats.error("collection_" + this.operation);
                OverseerCollectionProcessor.this.stats.storeFailureDetails("collection_" + this.operation, this.message, this.response);
            }
        }

        private boolean isSuccessful() {
            if (this.response == null) {
                return false;
            }
            return this.response.getResponse().get("failure") == null && this.response.getResponse().get("exception") == null;
        }
    }
}

