/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.SnapPuller;
import org.apache.solr.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapShooter {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapShooter.class.getName());
    private String snapDir = null;
    private SolrCore solrCore;
    private SimpleFSLockFactory lockFactory;
    private String snapshotName = null;
    private String directoryName = null;
    private File snapShotDir = null;
    private Lock lock = null;
    public static final String DATE_FMT = "yyyyMMddHHmmssSSS";

    public SnapShooter(SolrCore core, String location, String snapshotName) {
        this.solrCore = core;
        if (location == null) {
            this.snapDir = core.getDataDir();
        } else {
            File base = new File(core.getCoreDescriptor().getRawInstanceDir());
            this.snapDir = FileUtils.resolvePath(base, location).getAbsolutePath();
            File dir = new File(this.snapDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        this.lockFactory = new SimpleFSLockFactory(this.snapDir);
        this.snapshotName = snapshotName;
        if (snapshotName != null) {
            this.directoryName = "snapshot." + snapshotName;
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat(DATE_FMT, Locale.ROOT);
            this.directoryName = "snapshot." + fmt.format(new Date());
        }
    }

    void createSnapAsync(final IndexCommit indexCommit, final int numberToKeep, final ReplicationHandler replicationHandler) {
        replicationHandler.core.getDeletionPolicy().saveCommitPoint(indexCommit.getGeneration());
        new Thread(){

            @Override
            public void run() {
                if (SnapShooter.this.snapshotName != null) {
                    SnapShooter.this.createSnapshot(indexCommit, replicationHandler);
                } else {
                    SnapShooter.this.deleteOldBackups(numberToKeep);
                    SnapShooter.this.createSnapshot(indexCommit, replicationHandler);
                }
            }
        }.start();
    }

    public void validateDeleteSnapshot() {
        File[] files;
        boolean dirFound = false;
        for (File f : files = new File(this.snapDir).listFiles()) {
            if (!f.getName().equals("snapshot." + this.snapshotName)) continue;
            dirFound = true;
            break;
        }
        if (!dirFound) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot cannot be found in directory: " + this.snapDir);
        }
    }

    protected void deleteSnapAsync(final ReplicationHandler replicationHandler) {
        new Thread(){

            @Override
            public void run() {
                SnapShooter.this.deleteNamedSnapshot(replicationHandler);
            }
        }.start();
    }

    void validateCreateSnapshot() throws IOException {
        Lock lock = this.lockFactory.makeLock(this.directoryName + ".lock");
        this.snapShotDir = new File(this.snapDir, this.directoryName);
        if (lock.isLocked()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to acquire lock for snapshot directory: " + this.snapShotDir.getAbsolutePath());
        }
        if (this.snapShotDir.exists()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot directory already exists: " + this.snapShotDir.getAbsolutePath());
        }
        if (!this.snapShotDir.mkdirs()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to create snapshot directory: " + this.snapShotDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSnapshot(IndexCommit indexCommit, ReplicationHandler replicationHandler) {
        LOG.info("Creating backup snapshot...");
        NamedList details = new NamedList();
        details.add("startTime", (Object)new Date().toString());
        String directoryName = null;
        try {
            Collection files = indexCommit.getFileNames();
            FileCopier fileCopier = new FileCopier();
            Directory dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
            try {
                fileCopier.copyFiles(dir, files, this.snapShotDir);
            }
            finally {
                this.solrCore.getDirectoryFactory().release(dir);
            }
            details.add("fileCount", (Object)files.size());
            details.add("status", (Object)"success");
            String date = new Date().toString();
            details.add("snapshotCompletedAt", (Object)date);
            LOG.info("Done creating backup snapshot, completed at: " + date);
            details.add("snapshotName", (Object)this.snapshotName);
            LOG.info("Done creating backup snapshot: " + (this.snapshotName == null ? "<not named>" : this.snapshotName));
        }
        catch (Exception e) {
            SnapPuller.delTree(this.snapShotDir);
            LOG.error("Exception while creating snapshot", (Throwable)e);
            details.add("snapShootException", (Object)e.getMessage());
        }
        finally {
            replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getGeneration());
            replicationHandler.snapShootDetails = details;
            if (this.lock != null) {
                try {
                    this.lock.close();
                }
                catch (IOException e) {
                    LOG.error("Unable to release snapshoot lock: " + directoryName + ".lock");
                }
            }
        }
    }

    private void deleteOldBackups(int numberToKeep) {
        File[] files = new File(this.snapDir).listFiles();
        ArrayList<OldBackupDirectory> dirs = new ArrayList<OldBackupDirectory>();
        for (File f : files) {
            OldBackupDirectory obd = new OldBackupDirectory(f);
            if (obd.dir == null) continue;
            dirs.add(obd);
        }
        if (numberToKeep > dirs.size()) {
            return;
        }
        Collections.sort(dirs);
        int i = 1;
        for (OldBackupDirectory dir : dirs) {
            if (i++ <= numberToKeep - 1) continue;
            SnapPuller.delTree(dir.dir);
        }
    }

    protected void deleteNamedSnapshot(ReplicationHandler replicationHandler) {
        LOG.info("Deleting snapshot: " + this.snapshotName);
        NamedList details = new NamedList();
        File f = new File(this.snapDir, "snapshot." + this.snapshotName);
        boolean isSuccess = SnapPuller.delTree(f);
        if (isSuccess) {
            details.add("status", (Object)"success");
            details.add("snapshotDeletedAt", (Object)new Date().toString());
        } else {
            details.add("status", (Object)("Unable to delete snapshot: " + this.snapshotName));
            LOG.warn("Unable to delete snapshot: " + this.snapshotName);
        }
        replicationHandler.snapShootDetails = details;
    }

    private class FileCopier {
        private FileCopier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyFiles(Directory sourceDir, Collection<String> files, File destDir) throws IOException {
            if (destDir != null && !destDir.exists()) {
                destDir.mkdirs();
            }
            try (FSDirectory dir = FSDirectory.open((File)destDir);){
                for (String indexFile : files) {
                    this.copyFile(sourceDir, indexFile, new File(destDir, indexFile), (Directory)dir);
                }
            }
        }

        public void copyFile(Directory sourceDir, String indexFile, File destination, Directory destDir) throws IOException {
            if (destination.exists() && !destination.canWrite()) {
                String message = "Unable to open file " + destination + " for writing.";
                throw new IOException(message);
            }
            sourceDir.copy(destDir, indexFile, indexFile, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }
    }

    private class OldBackupDirectory
    implements Comparable<OldBackupDirectory> {
        File dir;
        Date timestamp;
        final Pattern dirNamePattern = Pattern.compile("^snapshot[.](.*)$");

        OldBackupDirectory(File dir) {
            Matcher m;
            if (dir.isDirectory() && (m = this.dirNamePattern.matcher(dir.getName())).find()) {
                try {
                    this.dir = dir;
                    this.timestamp = new SimpleDateFormat(SnapShooter.DATE_FMT, Locale.ROOT).parse(m.group(1));
                }
                catch (Exception e) {
                    this.dir = null;
                    this.timestamp = null;
                }
            }
        }

        @Override
        public int compareTo(OldBackupDirectory that) {
            return that.timestamp.compareTo(this.timestamp);
        }
    }
}

