/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.ext.EntityResolver2;

public final class SystemIdResolver
implements EntityResolver,
EntityResolver2 {
    private static final Logger log = LoggerFactory.getLogger(SystemIdResolver.class);
    public static final String RESOURCE_LOADER_URI_SCHEME = "solrres";
    public static final String RESOURCE_LOADER_AUTHORITY_ABSOLUTE = "@";
    private final ResourceLoader loader;

    public SystemIdResolver(ResourceLoader loader) {
        this.loader = loader;
    }

    public EntityResolver asEntityResolver() {
        return this;
    }

    public URIResolver asURIResolver() {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                try {
                    InputSource src = SystemIdResolver.this.resolveEntity(null, null, base, href);
                    return src == null ? null : new SAXSource(src);
                }
                catch (IOException ioe) {
                    throw new TransformerException("Cannot resolve entity", ioe);
                }
            }
        };
    }

    public XMLResolver asXMLResolver() {
        return new XMLResolver(){

            @Override
            public Object resolveEntity(String publicId, String systemId, String baseURI, String namespace) throws XMLStreamException {
                try {
                    InputSource src = SystemIdResolver.this.resolveEntity(null, publicId, baseURI, systemId);
                    return src == null ? null : src.getByteStream();
                }
                catch (IOException ioe) {
                    throw new XMLStreamException("Cannot resolve entity", ioe);
                }
            }
        };
    }

    URI resolveRelativeURI(String baseURI, String systemId) throws URISyntaxException {
        URI uri = systemId.startsWith("/") ? new URI(RESOURCE_LOADER_URI_SCHEME, RESOURCE_LOADER_AUTHORITY_ABSOLUTE, "/", null, null).resolve(systemId) : new URI(systemId);
        if (baseURI != null) {
            uri = new URI(baseURI).resolve(uri);
        }
        return uri;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws IOException {
        if (systemId == null) {
            return null;
        }
        try {
            URI uri = this.resolveRelativeURI(baseURI, systemId);
            if (RESOURCE_LOADER_URI_SCHEME.equals(uri.getScheme())) {
                String path = uri.getPath();
                String authority = uri.getAuthority();
                if (!RESOURCE_LOADER_AUTHORITY_ABSOLUTE.equals(authority)) {
                    path = path.substring(1);
                }
                try {
                    InputSource is = new InputSource(this.loader.openResource(path));
                    is.setSystemId(uri.toASCIIString());
                    is.setPublicId(publicId);
                    return is;
                }
                catch (RuntimeException re) {
                    throw new IOException(re.getMessage(), re);
                }
            }
            return null;
        }
        catch (URISyntaxException use) {
            log.warn("An URI systax problem occurred during resolving SystemId, falling back to default resolver", (Throwable)use);
            return null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public static String createSystemIdFromResourceName(String name) {
        String authority;
        if ((name = name.replace(File.separatorChar, '/')).startsWith("/")) {
            authority = RESOURCE_LOADER_AUTHORITY_ABSOLUTE;
        } else {
            authority = null;
            name = "/" + name;
        }
        try {
            return new URI(RESOURCE_LOADER_URI_SCHEME, authority, name, null, null).toASCIIString();
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid syntax of Solr Resource URI", use);
        }
    }
}

