/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.sastruts.core.util;

import javax.servlet.http.HttpServletRequest;
import org.codelibs.core.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"activity");

    public static void login(String username, HttpServletRequest request) {
        ActivityUtil.log(Action.LOGIN, username + ' ' + ActivityUtil.getRemoteAddr(request));
    }

    public static void logout(String username, HttpServletRequest request) {
        ActivityUtil.log(Action.LOGOUT, username + ' ' + ActivityUtil.getRemoteAddr(request));
    }

    public static void access(String username, HttpServletRequest request) {
        ActivityUtil.log(Action.ACCESS, username + ' ' + ActivityUtil.getRemoteAddr(request) + ' ' + request.getRequestURL());
    }

    protected static void log(Action action, String msg) {
        logger.info("[" + (Object)((Object)action) + "] " + msg);
    }

    protected static String getRemoteAddr(HttpServletRequest request) {
        String clientIp = request.getHeader("x-forwarded-for");
        if (StringUtil.isNotBlank((String)clientIp)) {
            return clientIp;
        }
        return request.getRemoteAddr();
    }

    protected static enum Action {
        LOGIN,
        LOGOUT,
        ACCESS;

    }
}

