/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.source.xml.XmlDocumentSourceHelperDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;
import org.carrot2.util.resource.IResource;

public final class XmlDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.xml.XmlDocumentSource";
    public final String prefix = "XmlDocumentSource";
    public final String title = "Fetches documents from XML files and streams";
    public final String label = "";
    public final String description = "For additional flexibility, an XSLT stylesheet can be applied to the XML stream before it is deserialized into Carrot2 data.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    public String getPrefix() {
        return "XmlDocumentSource";
    }

    public String getTitle() {
        return "Fetches documents from XML files and streams";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "For additional flexibility, an XSLT stylesheet can be applied to the XML stream before it is deserialized into Carrot2 data.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.xml);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.xslt);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.xmlParameters);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.xsltParameters);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.query);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.results);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.readClusters);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.readAll);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.title);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.documents);
        ownAttrs.add(XmlDocumentSourceDescriptor.attributes.clusters);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.xml);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.xslt);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.xmlParameters);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.xsltParameters);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.query);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.results);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.readClusters);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.readAll);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.title);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.documents);
        allAttrs.add(XmlDocumentSourceDescriptor.attributes.clusters);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder xml(IResource value) {
            this.map.put("XmlDocumentSource.xml", value);
            return this;
        }

        public AttributeBuilder xml(Class<?> clazz) {
            this.map.put("XmlDocumentSource.xml", clazz);
            return this;
        }

        public AttributeBuilder xml(IObjectFactory<? extends IResource> value) {
            this.map.put("XmlDocumentSource.xml", value);
            return this;
        }

        public AttributeBuilder xslt(IResource value) {
            this.map.put("XmlDocumentSource.xslt", value);
            return this;
        }

        public AttributeBuilder xslt(Class<?> clazz) {
            this.map.put("XmlDocumentSource.xslt", clazz);
            return this;
        }

        public AttributeBuilder xslt(IObjectFactory<? extends IResource> value) {
            this.map.put("XmlDocumentSource.xslt", value);
            return this;
        }

        public AttributeBuilder xmlParameters(Map<String, String> value) {
            this.map.put("XmlDocumentSource.xmlParameters", value);
            return this;
        }

        public AttributeBuilder xmlParameters(IObjectFactory<? extends Map<String, String>> value) {
            this.map.put("XmlDocumentSource.xmlParameters", value);
            return this;
        }

        public AttributeBuilder xsltParameters(Map<String, String> value) {
            this.map.put("XmlDocumentSource.xsltParameters", value);
            return this;
        }

        public AttributeBuilder xsltParameters(IObjectFactory<? extends Map<String, String>> value) {
            this.map.put("XmlDocumentSource.xsltParameters", value);
            return this;
        }

        public AttributeBuilder query(String value) {
            this.map.put("query", value);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> value) {
            this.map.put("query", value);
            return this;
        }

        public String query() {
            return (String)this.map.get("query");
        }

        public AttributeBuilder results(int value) {
            this.map.put("results", value);
            return this;
        }

        public AttributeBuilder results(IObjectFactory<? extends Integer> value) {
            this.map.put("results", value);
            return this;
        }

        public AttributeBuilder readClusters(boolean value) {
            this.map.put("XmlDocumentSource.readClusters", value);
            return this;
        }

        public AttributeBuilder readClusters(IObjectFactory<? extends Boolean> value) {
            this.map.put("XmlDocumentSource.readClusters", value);
            return this;
        }

        public AttributeBuilder readAll(boolean value) {
            this.map.put("XmlDocumentSource.readAll", value);
            return this;
        }

        public AttributeBuilder readAll(IObjectFactory<? extends Boolean> value) {
            this.map.put("XmlDocumentSource.readAll", value);
            return this;
        }

        public String title() {
            return (String)this.map.get("processing-result.title");
        }

        public List<Document> documents() {
            return (List)this.map.get("documents");
        }

        public AttributeBuilder clusters(List<Cluster> value) {
            this.map.put("clusters", value);
            return this;
        }

        public AttributeBuilder clusters(IObjectFactory<? extends List<Cluster>> value) {
            this.map.put("clusters", value);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public XmlDocumentSourceHelperDescriptor.AttributeBuilder xmlDocumentSourceHelper() {
            return XmlDocumentSourceHelperDescriptor.attributeBuilder(this.map);
        }
    }

    public static final class Attributes {
        public final AttributeInfo xml = new AttributeInfo("XmlDocumentSource.xml", "org.carrot2.source.xml.XmlDocumentSource", "xml", "The resource to load XML data from. You can either create instances of\n{@link org.carrot2.util.resource.IResource} implementations directly or use \n{@link org.carrot2.util.resource.ResourceLookup} to look up\n{@link org.carrot2.util.resource.IResource} instances from a variety of locations.\n<p>\nOne special {@link org.carrot2.util.resource.IResource} implementation you can use is\n{@link org.carrot2.util.resource.URLResourceWithParams}. It allows you to specify attribute placeholders in\nthe URL that will be replaced with actual values at runtime. The placeholder format\nis <code>${attribute}</code>. The following common attributes will be substituted:\n</p>\n<ul>\n<li><code>query</code> will be replaced with the current query being processed. If\nthe query has not been provided, this attribute will fall back to an empty string.</li>\n<li><code>results</code> will be replaced with the number of results requested. If\nthe number of results has not been provided, this attribute will be substituted\nwith an empty string.</li>\n</ul>\n<p>\nAdditionally, custom placeholders can be used. Values for the custom placeholders\nshould be provided in the {@link org.carrot2.source.xml.XmlDocumentSource#xmlParameters} attribute.\n</p>", "XML resource", "The resource to load XML data from", "You can either create instances of <code>org.carrot2.util.resource.IResource</code> implementations directly or use <code>org.carrot2.util.resource.ResourceLookup</code> to look up <code>org.carrot2.util.resource.IResource</code> instances from a variety of locations. <p> One special <code>org.carrot2.util.resource.IResource</code> implementation you can use is <code>org.carrot2.util.resource.URLResourceWithParams</code>. It allows you to specify attribute placeholders in the URL that will be replaced with actual values at runtime. The placeholder format is <code>${attribute}</code>. The following common attributes will be substituted: </p> <ul> <li><code>query</code> will be replaced with the current query being processed. If the query has not been provided, this attribute will fall back to an empty string.</li> <li><code>results</code> will be replaced with the number of results requested. If the number of results has not been provided, this attribute will be substituted with an empty string.</li> </ul> <p> Additionally, custom placeholders can be used. Values for the custom placeholders should be provided in the <code>org.carrot2.source.xml.XmlDocumentSource.xmlParameters</code> attribute. </p>", "XML data", AttributeLevel.BASIC, null);
        public final AttributeInfo xslt = new AttributeInfo("XmlDocumentSource.xslt", "org.carrot2.source.xml.XmlDocumentSource", "xslt", "The resource to load XSLT stylesheet from. The XSLT stylesheet is optional and is\nuseful when the source XML stream does not follow the Carrot2 format. The XSLT\ntransformation will be applied to the source XML stream, the transformed XML stream\nwill be deserialized into {@link org.carrot2.core.Document}s.\n<p>\nThe XSLT {@link org.carrot2.util.resource.IResource} can be provided both on initialization and processing\ntime. The stylesheet provided on initialization will be cached for the life time of\nthe component, while processing-time style sheets will be compiled every time\nprocessing is requested and will override the initialization-time stylesheet.\n</p>\n<p>\nTo pass additional parameters to the XSLT transformer, use the\n{@link org.carrot2.source.xml.XmlDocumentSource#xsltParameters} attribute.\n</p>", "XSLT stylesheet", "The resource to load XSLT stylesheet from", "The XSLT stylesheet is optional and is useful when the source XML stream does not follow the Carrot2 format. The XSLT transformation will be applied to the source XML stream, the transformed XML stream will be deserialized into <code>org.carrot2.core.Document</code>s. <p> The XSLT <code>org.carrot2.util.resource.IResource</code> can be provided both on initialization and processing time. The stylesheet provided on initialization will be cached for the life time of the component, while processing-time style sheets will be compiled every time processing is requested and will override the initialization-time stylesheet. </p> <p> To pass additional parameters to the XSLT transformer, use the <code>org.carrot2.source.xml.XmlDocumentSource.xsltParameters</code> attribute. </p>", "XML transformation", AttributeLevel.MEDIUM, null);
        public final AttributeInfo xmlParameters = new AttributeInfo("XmlDocumentSource.xmlParameters", "org.carrot2.source.xml.XmlDocumentSource", "xmlParameters", "Values for custom placeholders in the XML URL. If the type of resource provided in\nthe {@link org.carrot2.source.xml.XmlDocumentSource#xml} attribute is {@link org.carrot2.util.resource.URLResourceWithParams}, this map provides\nvalues for custom placeholders found in the XML URL. Keys of the map correspond to\nplaceholder names, values of the map will be used to replace the placeholders.\nPlease see {@link org.carrot2.source.xml.XmlDocumentSource#xml} for the placeholder syntax.", "XML parameters", "Values for custom placeholders in the XML URL", "If the type of resource provided in the <code>org.carrot2.source.xml.XmlDocumentSource.xml</code> attribute is <code>org.carrot2.util.resource.URLResourceWithParams</code>, this map provides values for custom placeholders found in the XML URL. Keys of the map correspond to placeholder names, values of the map will be used to replace the placeholders. Please see <code>org.carrot2.source.xml.XmlDocumentSource.xml</code> for the placeholder syntax.", "XML data", AttributeLevel.ADVANCED, null);
        public final AttributeInfo xsltParameters = new AttributeInfo("XmlDocumentSource.xsltParameters", "org.carrot2.source.xml.XmlDocumentSource", "xsltParameters", "Parameters to be passed to the XSLT transformer. Keys of the map will be used as\nparameter names, values of the map as parameter values.", "XSLT parameters", "Parameters to be passed to the XSLT transformer", "Keys of the map will be used as parameter names, values of the map as parameter values.", "XML transformation", AttributeLevel.ADVANCED, null);
        public final AttributeInfo query;
        public final AttributeInfo results;
        public final AttributeInfo readClusters;
        public final AttributeInfo readAll;
        public final AttributeInfo title;
        public final AttributeInfo documents;
        public final AttributeInfo clusters;
        public final XmlDocumentSourceHelperDescriptor.Attributes xmlDocumentSourceHelper;

        private Attributes() {
            this.query = new AttributeInfo("query", "org.carrot2.source.xml.XmlDocumentSource", "query", "After processing this field may hold the query read from the XML data, if any. For\nthe semantics of this field on input, see {@link org.carrot2.source.xml.XmlDocumentSource#xml}.", null, "After processing this field may hold the query read from the XML data, if any", "For the semantics of this field on input, see <code>org.carrot2.source.xml.XmlDocumentSource.xml</code>.", null, null, CommonAttributesDescriptor.attributes.query);
            this.results = new AttributeInfo("results", "org.carrot2.source.xml.XmlDocumentSource", "results", "The maximum number of documents to read from the XML data if {@link org.carrot2.source.xml.XmlDocumentSource#readAll} is\n<code>false</code>.", null, "The maximum number of documents to read from the XML data if <code>org.carrot2.source.xml.XmlDocumentSource.readAll</code> is <code>false</code>", null, null, null, CommonAttributesDescriptor.attributes.results);
            this.readClusters = new AttributeInfo("XmlDocumentSource.readClusters", "org.carrot2.source.xml.XmlDocumentSource", "readClusters", "If clusters are present in the input XML they will be read and exposed to components\nfurther down the processing chain.", "Read clusters from input", "If clusters are present in the input XML they will be read and exposed to components further down the processing chain", null, "XML transformation", AttributeLevel.BASIC, null);
            this.readAll = new AttributeInfo("XmlDocumentSource.readAll", "org.carrot2.source.xml.XmlDocumentSource", "readAll", "If <code>true</code>, all documents are read from the input XML stream, regardless\nof the limit set by {@link org.carrot2.source.xml.XmlDocumentSource#results}.", "Read all documents", "If <code>true</code>, all documents are read from the input XML stream, regardless of the limit set by <code>org.carrot2.source.xml.XmlDocumentSource.results</code>", null, "Search query", AttributeLevel.BASIC, null);
            this.title = new AttributeInfo("processing-result.title", "org.carrot2.source.xml.XmlDocumentSource", "title", "The title (file name or query attribute, if present) for the search result fetched\nfrom the resource.", null, "The title (file name or query attribute, if present) for the search result fetched from the resource", null, null, null, CommonAttributesDescriptor.attributes.processingResultTitle);
            this.documents = new AttributeInfo("documents", "org.carrot2.source.xml.XmlDocumentSource", "documents", "Documents read from the XML data.", null, "Documents read from the XML data", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.clusters = new AttributeInfo("clusters", "org.carrot2.source.xml.XmlDocumentSource", "clusters", "If {@link org.carrot2.source.xml.XmlDocumentSource#readClusters} is <code>true</code> and clusters are present in the input\nXML, they will be deserialized and exposed to components further down the processing\nchain.", null, "If <code>org.carrot2.source.xml.XmlDocumentSource.readClusters</code> is <code>true</code> and clusters are present in the input XML, they will be deserialized and exposed to components further down the processing chain", null, null, null, CommonAttributesDescriptor.attributes.clusters);
            this.xmlDocumentSourceHelper = XmlDocumentSourceHelperDescriptor.attributes;
        }
    }

    public static class Keys {
        public static final String XML = "XmlDocumentSource.xml";
        public static final String XSLT = "XmlDocumentSource.xslt";
        public static final String XML_PARAMETERS = "XmlDocumentSource.xmlParameters";
        public static final String XSLT_PARAMETERS = "XmlDocumentSource.xsltParameters";
        public static final String QUERY = "query";
        public static final String RESULTS = "results";
        public static final String READ_CLUSTERS = "XmlDocumentSource.readClusters";
        public static final String READ_ALL = "XmlDocumentSource.readAll";
        public static final String TITLE = "processing-result.title";
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";

        protected Keys() {
        }
    }
}

