/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.carrotsearch.hppc.ObjectOpenHashSet;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.DefaultLexicalData;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.linguistic.ILexicalDataFactory;
import org.carrot2.text.linguistic.LexicalDataLoader;
import org.carrot2.text.util.MutableCharArray;
import org.carrot2.util.CharArrayUtils;
import org.carrot2.util.annotations.AspectModified;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.ResourceCache;
import org.carrot2.util.resource.ResourceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(inherit={LexicalDataLoader.class})
public class DefaultLexicalDataFactory
implements ILexicalDataFactory {
    static final Logger logger = LoggerFactory.getLogger(DefaultLexicalDataFactory.class);
    private static final Function<ResourceLookup, HashMap<LanguageCode, ILexicalData>> resourceLoader = new Function<ResourceLookup, HashMap<LanguageCode, ILexicalData>>(){

        public HashMap<LanguageCode, ILexicalData> apply(ResourceLookup resourceLookup) {
            return DefaultLexicalDataFactory.reloadResources(resourceLookup);
        }

        public boolean equals(Object other) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    };
    private static final ResourceCache<HashMap<LanguageCode, ILexicalData>> cache = new ResourceCache<HashMap<LanguageCode, ILexicalData>>(resourceLoader);
    @Processing
    @Input
    @Attribute(key="reload-resources", inherit=true)
    public boolean reloadResources = false;
    @Init
    @Processing
    @Input
    @Attribute(key="merge-resources")
    @Label(value="Merge lexical resources")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Preprocessing")
    public boolean mergeResources = true;
    @Init
    @Processing
    @Input
    @Internal
    @Attribute(key="resource-lookup", inherit=true)
    @ImplementingClasses(classes={}, strict=false)
    @AspectModified(value="Substituted with an assembly lookup in .NET release")
    public ResourceLookup resourceLookup = new ResourceLookup(ResourceLookup.Location.CONTEXT_CLASS_LOADER);

    @Override
    public ILexicalData getLexicalData(LanguageCode languageCode) {
        if (this.mergeResources) {
            languageCode = null;
        }
        ILexicalData lexicalData = cache.get(this.resourceLookup, this.reloadResources).get((Object)languageCode);
        this.reloadResources = false;
        return lexicalData;
    }

    private static HashMap<LanguageCode, ILexicalData> reloadResources(ResourceLookup resourceLookup) {
        ObjectOpenHashSet mergedStopwords = ObjectOpenHashSet.newInstance();
        ArrayList mergedStoplabels = Lists.newArrayList();
        HashMap resourceMap = Maps.newHashMap();
        for (LanguageCode languageCode : LanguageCode.values()) {
            String isoCode = languageCode.getIsoCode();
            ObjectOpenHashSet<MutableCharArray> stopwords = DefaultLexicalDataFactory.toLower(DefaultLexicalDataFactory.load(resourceLookup, "stopwords." + isoCode));
            ArrayList<Pattern> stoplabels = DefaultLexicalDataFactory.compile(DefaultLexicalDataFactory.load(resourceLookup, "stoplabels." + isoCode));
            mergedStopwords.addAll(stopwords);
            mergedStoplabels.addAll(stoplabels);
            resourceMap.put(languageCode, new DefaultLexicalData(stopwords, stoplabels));
        }
        resourceMap.put(null, new DefaultLexicalData((ObjectOpenHashSet<MutableCharArray>)mergedStopwords, mergedStoplabels));
        return resourceMap;
    }

    private static ObjectOpenHashSet<MutableCharArray> toLower(Set<String> input) {
        ObjectOpenHashSet cloned = new ObjectOpenHashSet(input.size());
        for (String entry : input) {
            char[] chars = entry.toCharArray();
            CharArrayUtils.toLowerCaseInPlace(chars);
            cloned.add((Object)new MutableCharArray(chars));
        }
        return cloned;
    }

    private static ArrayList<Pattern> compile(HashSet<String> patterns) {
        ArrayList<Pattern> compiled = new ArrayList<Pattern>(patterns.size());
        for (String pattern : patterns) {
            try {
                compiled.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                logger.warn("Ignoring invalid regular expression: " + pattern);
            }
        }
        return compiled;
    }

    private static HashSet<String> load(ResourceLookup resourceLookup, String resourceName) {
        IResource resource = resourceLookup.getFirst(resourceName);
        if (resource == null) {
            throw new RuntimeException("No resource named " + resourceName + " in resource lookup locations: " + Arrays.toString(resourceLookup.getLocators()));
        }
        try {
            return DefaultLexicalDataFactory.load(resource);
        }
        catch (IOException e) {
            throw new RuntimeException("Resource named " + resourceName + " failed to load from: " + resource.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<String> load(IResource resource) throws IOException {
        HashSet words = Sets.newHashSet();
        InputStream is = resource.open();
        if (is == null) {
            throw new IOException("Resource returned null stream: " + resource);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                words.add(line);
            }
        }
        finally {
            reader.close();
        }
        return words;
    }
}

