/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ForwardingExecutorService;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceUtils {
    public static ExecutorService createExecutorService(int maxConcurrentThreads, Class<?> clazz) {
        String baseName = clazz.getSimpleName();
        ClassLoader classLoader = clazz.getClassLoader();
        AccountingThreadFactory threadFactory = new AccountingThreadFactory(classLoader, baseName);
        return new AccountingExecutorService(maxConcurrentThreads, threadFactory);
    }

    static final class AccountingExecutorService
    extends ForwardingExecutorService {
        private ExecutorService delegate;
        private AccountingThreadFactory threadFactory;

        public AccountingExecutorService(int maxConcurrentThreads, AccountingThreadFactory threadFactory) {
            this.delegate = Executors.newFixedThreadPool(maxConcurrentThreads, threadFactory);
            this.threadFactory = threadFactory;
        }

        public void shutdown() {
            super.shutdown();
            this.threadFactory.join();
        }

        public List<Runnable> shutdownNow() {
            List result = super.shutdownNow();
            this.threadFactory.join();
            return result;
        }

        protected ExecutorService delegate() {
            return this.delegate;
        }
    }

    static final class AccountingThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;
        private final String baseName;
        private final AtomicInteger counter = new AtomicInteger();
        private final List<WeakReference<Thread>> threads = Collections.synchronizedList(Lists.newArrayList());

        public AccountingThreadFactory(ClassLoader classLoader, String baseName) {
            this.classLoader = classLoader;
            this.baseName = baseName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "SharedExecutor-" + this.baseName + "-" + this.counter.getAndIncrement());
            t.setDaemon(true);
            t.setContextClassLoader(this.classLoader);
            this.threads.add(new WeakReference<Thread>(t));
            return t;
        }

        void join() {
            for (WeakReference<Thread> r : this.threads) {
                Thread t = (Thread)r.get();
                if (t == null) continue;
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

