/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Class<?> classForName(String clazzName) throws ClassNotFoundException {
        return ReflectionUtils.classForName(clazzName, true);
    }

    public static Class<?> classForName(String clazzName, boolean logWarning) throws ClassNotFoundException {
        try {
            return Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (logWarning) {
                LoggerFactory.getLogger(ReflectionUtils.class).warn("Could not load class: " + clazzName + " (" + e.getMessage() + ").");
            }
            throw e;
        }
    }
}

