/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.solr.lib.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrLibHttpSolrServer
extends HttpSolrServer {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(SolrLibHttpSolrServer.class);
    protected final HttpClientWrapper internalHttpClient;
    protected RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
    protected List<HttpRequestInterceptor> httpRequestInterceptorList = new ArrayList<HttpRequestInterceptor>();
    protected IdleConnectionMonitorThread idleConnectionMonitorThread;
    private boolean allowCompression;
    private boolean followRedirects = false;
    private int defaultMaxConnectionsPerHost = 32;
    private int maxTotalConnections = 128;
    private long connectionIdelTimeout = 60L;
    private long connectionMonitorInterval = 10L;
    private transient HttpClientConnectionManager clientConnectionManager;

    public SolrLibHttpSolrServer(String solrServerUrl) throws MalformedURLException {
        this(solrServerUrl, (ResponseParser)new BinaryResponseParser());
    }

    public SolrLibHttpSolrServer(String solrServerUrl, ResponseParser parser) throws MalformedURLException {
        super(solrServerUrl, (HttpClient)new HttpClientWrapper(), parser);
        this.internalHttpClient = (HttpClientWrapper)this.getHttpClient();
    }

    public void setCredentials(AuthScope authScope, Credentials credentials) {
        this.internalHttpClient.setCredentials(authScope, credentials);
    }

    public void addRequestInterceptor(HttpRequestInterceptor iterceptor) {
        this.httpRequestInterceptorList.add(iterceptor);
    }

    public void setConnectionTimeout(int timeout) {
        this.requestConfigBuilder.setConnectTimeout(timeout);
    }

    public void setSoTimeout(int timeout) {
        this.requestConfigBuilder.setSocketTimeout(timeout);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setAllowCompression(boolean allowCompression) {
        this.allowCompression = allowCompression;
    }

    public void setDefaultMaxConnectionsPerHost(int defaultMaxConnectionsPerHost) {
        this.defaultMaxConnectionsPerHost = defaultMaxConnectionsPerHost;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setConnectionIdelTimeout(long connectionIdelTimeout) {
        this.connectionIdelTimeout = connectionIdelTimeout;
    }

    public void setConnectionMonitorInterval(long connectionMonitorInterval) {
        this.connectionMonitorInterval = connectionMonitorInterval;
    }

    public void setClientConnectionManager(HttpClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public void init() {
        if (this.clientConnectionManager == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(this.defaultMaxConnectionsPerHost);
            connectionManager.setMaxTotal(this.maxTotalConnections);
            this.idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)connectionManager, this.connectionMonitorInterval, this.connectionIdelTimeout);
            this.idleConnectionMonitorThread.start();
            this.clientConnectionManager = connectionManager;
        }
        this.requestConfigBuilder.setRedirectsEnabled(this.followRedirects);
        HttpClientBuilder builder = HttpClients.custom();
        if (this.allowCompression) {
            builder.addInterceptorLast((HttpRequestInterceptor)new UseCompressionRequestInterceptor());
            builder.addInterceptorLast((HttpResponseInterceptor)new UseCompressionResponseInterceptor());
        }
        for (HttpRequestInterceptor iterceptor : this.httpRequestInterceptorList) {
            builder.addInterceptorLast(iterceptor);
        }
        this.init(builder.setConnectionManager(this.clientConnectionManager).setDefaultRequestConfig(this.requestConfigBuilder.build()).build());
    }

    public void init(CloseableHttpClient closeableHttpClient) {
        this.internalHttpClient.closeableHttpClient = closeableHttpClient;
    }

    public void shutdown() {
        if (this.getHttpClient() instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.getHttpClient()).close();
            }
            catch (IOException e) {
                logger.error("Failed to close HttpClient", (Throwable)e);
            }
        }
        if (this.idleConnectionMonitorThread != null) {
            this.idleConnectionMonitorThread.shutdown();
        }
    }

    protected static class UseCompressionResponseInterceptor
    implements HttpResponseInterceptor {
        protected UseCompressionResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs;
                for (HeaderElement codec : codecs = ceheader.getElements()) {
                    if ("gzip".equalsIgnoreCase(codec.getName())) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!"deflate".equalsIgnoreCase(codec.getName())) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }

        private static class DeflateDecompressingEntity
        extends GzipDecompressingEntity {
            public DeflateDecompressingEntity(HttpEntity entity) {
                super(entity);
            }

            @Override
            public InputStream getContent() throws IOException, IllegalStateException {
                return new InflaterInputStream(this.wrappedEntity.getContent());
            }
        }

        private static class GzipDecompressingEntity
        extends HttpEntityWrapper {
            public GzipDecompressingEntity(HttpEntity entity) {
                super(entity);
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                return new GZIPInputStream(this.wrappedEntity.getContent());
            }

            public long getContentLength() {
                return -1L;
            }
        }
    }

    protected static class UseCompressionRequestInterceptor
    implements HttpRequestInterceptor {
        protected UseCompressionRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip, deflate");
            }
        }
    }

    protected static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private boolean stopped;
        private final long monitorInterval;
        private final long idelTimeout;

        protected IdleConnectionMonitorThread(HttpClientConnectionManager connMgr, long monitorInterval, long idelTimeout) {
            super("SolrLibConnMonitor");
            this.connMgr = connMgr;
            this.monitorInterval = monitorInterval * 1000L;
            this.idelTimeout = idelTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(this.monitorInterval);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(this.idelTimeout, TimeUnit.SECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.stopped = true;
                this.notifyAll();
            }
        }
    }

    protected static class HttpClientWrapper
    extends CloseableHttpClient {
        protected CloseableHttpClient closeableHttpClient;
        protected CredentialsProvider credsProvider;

        protected HttpClientWrapper() {
        }

        public void setCredentials(AuthScope authScope, Credentials credentials) {
            if (authScope != null & credentials != null) {
                this.credsProvider = new BasicCredentialsProvider();
                this.credsProvider.setCredentials(authScope, credentials);
            }
        }

        protected HttpContext updateHttpContext(HttpContext context) {
            if (this.credsProvider == null) {
                return context;
            }
            Object newContext = context == null ? HttpClientContext.create() : context;
            newContext.setAttribute("http.auth.credentials-provider", (Object)this.credsProvider);
            return newContext;
        }

        public void close() throws IOException {
            this.closeableHttpClient.close();
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
            return this.closeableHttpClient.execute(target, request, this.updateHttpContext(context));
        }

        public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
            return this.closeableHttpClient.execute(request, this.updateHttpContext(context));
        }

        public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
            return this.execute(request, (HttpContext)null);
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
            return this.closeableHttpClient.execute(target, request, (HttpContext)null);
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
            return this.execute(request, responseHandler, null);
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
            return (T)this.closeableHttpClient.execute(request, responseHandler, this.updateHttpContext(context));
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
            return this.execute(target, request, responseHandler, null);
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
            return (T)this.closeableHttpClient.execute(target, request, responseHandler, this.updateHttpContext(context));
        }

        public String toString() {
            return this.closeableHttpClient.toString();
        }

        public int hashCode() {
            return this.closeableHttpClient.hashCode();
        }

        public boolean equals(Object obj) {
            return this.closeableHttpClient.equals(obj);
        }

        public HttpParams getParams() {
            return this.closeableHttpClient.getParams();
        }

        public ClientConnectionManager getConnectionManager() {
            return this.closeableHttpClient.getConnectionManager();
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return null;
        }
    }
}

