/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.db.allcommon;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codelibs.robot.db.allcommon.DBMetaInstanceHandler;
import org.codelibs.robot.dbflute.BehaviorSelector;
import org.codelibs.robot.dbflute.bhv.BehaviorReadable;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.exception.IllegalBehaviorStateException;
import org.codelibs.robot.dbflute.util.DfTraceViewUtil;
import org.codelibs.robot.dbflute.util.DfTypeUtil;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;

public class ImplementedBehaviorSelector
implements BehaviorSelector {
    private static final Log _log = LogFactory.getLog(ImplementedBehaviorSelector.class);
    protected final Map<Class<? extends BehaviorReadable>, BehaviorReadable> _behaviorCache = this.newHashMap();
    protected S2Container _container;

    @Override
    public void initializeConditionBeanMetaData() {
        Map<String, DBMeta> dbmetaMap = DBMetaInstanceHandler.getUnmodifiableDBMetaMap();
        Collection<DBMeta> dbmetas = dbmetaMap.values();
        long before = 0L;
        if (_log.isInfoEnabled()) {
            before = System.currentTimeMillis();
            _log.info((Object)"...Initializing condition-bean meta data");
        }
        int count = 0;
        for (DBMeta dbmeta : dbmetas) {
            try {
                BehaviorReadable bhv = this.byName(dbmeta.getTableDbName());
                bhv.warmUpCommand();
                ++count;
            }
            catch (IllegalBehaviorStateException ignored) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("No behavior for " + dbmeta.getTableDbName()));
            }
        }
        if (_log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            _log.info((Object)("CB initialized: " + count + " [" + DfTraceViewUtil.convertToPerformanceView(after - before) + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <BEHAVIOR extends BehaviorReadable> BEHAVIOR select(Class<BEHAVIOR> behaviorType) {
        BehaviorReadable bhv = this._behaviorCache.get(behaviorType);
        if (bhv != null) {
            return (BEHAVIOR)bhv;
        }
        Map<Class<? extends BehaviorReadable>, BehaviorReadable> map = this._behaviorCache;
        synchronized (map) {
            bhv = this._behaviorCache.get(behaviorType);
            if (bhv != null) {
                return (BEHAVIOR)bhv;
            }
            bhv = (BehaviorReadable)this.getComponent(behaviorType);
            this._behaviorCache.put(behaviorType, bhv);
            return (BEHAVIOR)bhv;
        }
    }

    @Override
    public BehaviorReadable byName(String tableFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("tableFlexibleName", tableFlexibleName);
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(tableFlexibleName);
        return this.select(this.getBehaviorType(dbmeta));
    }

    protected Class<BehaviorReadable> getBehaviorType(DBMeta dbmeta) {
        Class<BehaviorReadable> behaviorType;
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        if (behaviorTypeName == null) {
            String msg = "The dbmeta.getBehaviorTypeName() should not return null: dbmeta=" + dbmeta;
            throw new IllegalStateException(msg);
        }
        try {
            behaviorType = Class.forName(behaviorTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalBehaviorStateException("The class does not exist: " + behaviorTypeName, e);
        }
        return behaviorType;
    }

    protected <COMPONENT> COMPONENT getComponent(Class<COMPONENT> componentType) {
        this.assertObjectNotNull("componentType", componentType);
        this.assertObjectNotNull("_container", this._container);
        try {
            return (COMPONENT)this._container.getComponent(componentType);
        }
        catch (ComponentNotFoundRuntimeException e) {
            Object component;
            try {
                component = this._container.getRoot().getComponent(componentType);
            }
            catch (ComponentNotFoundRuntimeException ignored) {
                throw e;
            }
            this._container = this._container.getRoot();
            return (COMPONENT)component;
        }
    }

    protected String initUncap(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    protected String toClassTitle(Object obj) {
        return DfTypeUtil.toClassTitle(obj);
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public void setContainer(S2Container container) {
        this._container = container;
    }
}

