/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.bhv.core;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelibs.robot.dbflute.CallbackContext;
import org.codelibs.robot.dbflute.DBDef;
import org.codelibs.robot.dbflute.Entity;
import org.codelibs.robot.dbflute.XLog;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommand;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommandComponentSetup;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommandHook;
import org.codelibs.robot.dbflute.bhv.core.ContextStack;
import org.codelibs.robot.dbflute.bhv.core.InvokerAssistant;
import org.codelibs.robot.dbflute.bhv.core.SqlExecution;
import org.codelibs.robot.dbflute.bhv.core.SqlExecutionCreator;
import org.codelibs.robot.dbflute.bhv.core.supplement.SequenceCacheHandler;
import org.codelibs.robot.dbflute.bhv.logging.invoke.BehaviorInvokeNameExtractor;
import org.codelibs.robot.dbflute.bhv.logging.invoke.BehaviorInvokeNameResult;
import org.codelibs.robot.dbflute.bhv.logging.invoke.BehaviorInvokePathBuilder;
import org.codelibs.robot.dbflute.bhv.logging.invoke.BehaviorInvokePathResult;
import org.codelibs.robot.dbflute.bhv.logging.result.BehaviorResultBuilder;
import org.codelibs.robot.dbflute.cbean.FetchAssistContext;
import org.codelibs.robot.dbflute.cbean.FetchNarrowingBean;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.exception.SQLFailureException;
import org.codelibs.robot.dbflute.exception.handler.SQLExceptionResource;
import org.codelibs.robot.dbflute.exception.thrower.BehaviorExceptionThrower;
import org.codelibs.robot.dbflute.jdbc.ExecutionTimeInfo;
import org.codelibs.robot.dbflute.jdbc.SQLExceptionDigger;
import org.codelibs.robot.dbflute.jdbc.SqlLogInfo;
import org.codelibs.robot.dbflute.jdbc.SqlResultHandler;
import org.codelibs.robot.dbflute.jdbc.SqlResultInfo;
import org.codelibs.robot.dbflute.jdbc.StatementConfig;
import org.codelibs.robot.dbflute.outsidesql.OutsideSqlContext;
import org.codelibs.robot.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;
import org.codelibs.robot.dbflute.outsidesql.factory.OutsideSqlExecutorFactory;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.resource.InternalMapContext;
import org.codelibs.robot.dbflute.resource.ResourceContext;
import org.codelibs.robot.dbflute.util.DfTraceViewUtil;
import org.codelibs.robot.dbflute.util.DfTypeUtil;
import org.codelibs.robot.dbflute.util.Srl;

public class BehaviorCommandInvoker {
    protected InvokerAssistant _invokerAssistant;
    protected final Map<String, SqlExecution> _executionMap = this.newHashMap();
    protected final InvokerAssistant.DisposableProcess _disposableProcess = new InvokerAssistant.DisposableProcess(){

        @Override
        public void dispose() {
            BehaviorCommandInvoker.this.clearExecutionCache();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExecutionCache() {
        Map<String, SqlExecution> map = this._executionMap;
        synchronized (map) {
            this._executionMap.clear();
        }
    }

    public boolean isExecutionCacheEmpty() {
        return this._executionMap.isEmpty();
    }

    public int getExecutionCacheSize() {
        return this._executionMap.size();
    }

    public void injectComponentProperty(BehaviorCommandComponentSetup behaviorCommand) {
        this.assertInvokerAssistant();
        behaviorCommand.setDataSource(this._invokerAssistant.assistDataSource());
        behaviorCommand.setStatementFactory(this._invokerAssistant.assistStatementFactory());
        behaviorCommand.setBeanMetaDataFactory(this._invokerAssistant.assistBeanMetaDataFactory());
        behaviorCommand.setSqlFileEncoding(this.getSqlFileEncoding());
    }

    protected String getSqlFileEncoding() {
        this.assertInvokerAssistant();
        return this._invokerAssistant.assistSqlFileEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> RESULT invoke(BehaviorCommand<RESULT> behaviorCommand) {
        RuntimeException cause = null;
        RESULT result = null;
        try {
            ResourceContext parentContext = this.getParentContext();
            this.initializeContext();
            this.setupResourceContext(behaviorCommand, parentContext);
            this.processBeforeHook(behaviorCommand);
            result = this.dispatchInvoking(behaviorCommand);
        }
        catch (RuntimeException e) {
            cause = e;
        }
        finally {
            this.processFinallyHook(behaviorCommand, cause);
            this.closeContext();
        }
        if (cause != null) {
            throw cause;
        }
        return result;
    }

    protected <RESULT> void setupResourceContext(BehaviorCommand<RESULT> behaviorCommand, ResourceContext parentContext) {
        this.assertInvokerAssistant();
        ResourceContext resourceContext = new ResourceContext();
        resourceContext.setParentContext(parentContext);
        resourceContext.setBehaviorCommand(behaviorCommand);
        resourceContext.setCurrentDBDef(this._invokerAssistant.assistCurrentDBDef());
        resourceContext.setDBMetaProvider(this._invokerAssistant.assistDBMetaProvider());
        resourceContext.setSqlClauseCreator(this._invokerAssistant.assistSqlClauseCreator());
        resourceContext.setSqlAnalyzerFactory(this._invokerAssistant.assistSqlAnalyzerFactory());
        resourceContext.setSQLExceptionHandlerFactory(this._invokerAssistant.assistSQLExceptionHandlerFactory());
        resourceContext.setGearedCipherManager(this._invokerAssistant.assistGearedCipherManager());
        resourceContext.setResourceParameter(this._invokerAssistant.assistResourceParameter());
        ResourceContext.setResourceContextOnThread(resourceContext);
    }

    protected <RESULT> void processBeforeHook(BehaviorCommand<RESULT> behaviorCommand) {
        if (!CallbackContext.isExistBehaviorCommandHookOnThread()) {
            return;
        }
        BehaviorCommandHook hook = CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook();
        hook.hookBefore(behaviorCommand);
    }

    protected <RESULT> void processFinallyHook(BehaviorCommand<RESULT> behaviorCommand, RuntimeException cause) {
        if (!CallbackContext.isExistBehaviorCommandHookOnThread()) {
            return;
        }
        BehaviorCommandHook hook = CallbackContext.getCallbackContextOnThread().getBehaviorCommandHook();
        hook.hookFinally(behaviorCommand, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT dispatchInvoking(BehaviorCommand<RESULT> behaviorCommand) {
        boolean logEnabled = this.isLogEnabled();
        if (behaviorCommand.isInitializeOnly()) {
            this.initializeSqlExecution(behaviorCommand);
            return null;
        }
        behaviorCommand.beforeGettingSqlExecution();
        SqlExecution execution = this.findSqlExecution(behaviorCommand);
        SqlResultHandler sqlResultHander = this.getSqlResultHander();
        boolean hasSqlResultHandler = sqlResultHander != null;
        long before = this.deriveCommandBeforeAfterTimeIfNeeds(logEnabled, hasSqlResultHandler);
        Long after = null;
        Object ret = null;
        RuntimeException cause = null;
        try {
            Object[] args = behaviorCommand.getSqlExecutionArgument();
            ret = this.executeSql(execution, args);
            Class<?> retType = behaviorCommand.getCommandReturnType();
            this.assertRetType(retType, ret);
            after = this.deriveCommandBeforeAfterTimeIfNeeds(logEnabled, hasSqlResultHandler);
            if (logEnabled) {
                this.logResult(behaviorCommand, retType, ret, before, after);
            }
            ret = this.convertReturnValueIfNeeds(ret, retType);
        }
        catch (RuntimeException e) {
            try {
                try {
                    this.handleExecutionException(e);
                }
                catch (RuntimeException handled) {
                    cause = handled;
                    throw handled;
                }
                behaviorCommand.afterExecuting();
                if (hasSqlResultHandler) {
                    this.callbackSqlResultHanler(behaviorCommand, sqlResultHander, ret, before, after, cause);
                }
            }
            catch (Throwable throwable) {
                behaviorCommand.afterExecuting();
                if (hasSqlResultHandler) {
                    this.callbackSqlResultHanler(behaviorCommand, sqlResultHander, ret, before, after, cause);
                }
                throw throwable;
            }
        }
        behaviorCommand.afterExecuting();
        if (hasSqlResultHandler) {
            this.callbackSqlResultHanler(behaviorCommand, sqlResultHander, ret, before, after, cause);
        }
        Object result = ret;
        return (RESULT)result;
    }

    protected long deriveCommandBeforeAfterTimeIfNeeds(boolean logEnabled, boolean hasSqlResultHandler) {
        long time = 0L;
        if (logEnabled || hasSqlResultHandler) {
            time = this.systemTime();
        }
        return time;
    }

    protected long systemTime() {
        return DBFluteSystem.currentTimeMillis();
    }

    protected Object convertReturnValueIfNeeds(Object ret, Class<?> retType) {
        if (retType.isPrimitive()) {
            return this.convertPrimitiveWrapper(ret, retType);
        }
        if (Number.class.isAssignableFrom(retType)) {
            return this.convertNumber(ret, retType);
        }
        return ret;
    }

    protected void handleExecutionException(RuntimeException cause) {
        if (cause instanceof SQLFailureException) {
            throw cause;
        }
        SQLExceptionDigger digger = this.getSQLExceptionDigger();
        SQLException sqlEx = digger.digUp(cause);
        if (sqlEx == null) {
            throw cause;
        }
        this.handleSQLException(sqlEx);
    }

    protected void handleSQLException(SQLException e) {
        SQLExceptionResource resource = new SQLExceptionResource();
        ResourceContext.createSQLExceptionHandler().handleSQLException(e, resource);
    }

    protected <RESULT> void callbackSqlResultHanler(BehaviorCommand<RESULT> behaviorCommand, SqlResultHandler sqlResultHander, Object ret, Long commandBefore, Long commandAfter, RuntimeException cause) {
        SqlLogInfo sqlLogInfo = this.getResultSqlLogInfo(behaviorCommand);
        Long sqlBefore = InternalMapContext.getSqlBeforeTimeMillis();
        Long sqlAfter = InternalMapContext.getSqlAfterTimeMillis();
        ExecutionTimeInfo timeInfo = new ExecutionTimeInfo(commandBefore, commandAfter, sqlBefore, sqlAfter);
        SqlResultInfo info = new SqlResultInfo(behaviorCommand, ret, sqlLogInfo, timeInfo, cause);
        sqlResultHander.handle(info);
    }

    protected <RESULT> SqlLogInfo getResultSqlLogInfo(BehaviorCommand<RESULT> behaviorCommand) {
        SqlLogInfo sqlLogInfo = InternalMapContext.getResultSqlLogInfo();
        if (sqlLogInfo != null) {
            return sqlLogInfo;
        }
        return new SqlLogInfo(behaviorCommand, null, new Object[0], new Class[0], new SqlLogInfo.SqlLogDisplaySqlBuilder(){

            @Override
            public String build(String executedSql, Object[] bindArgs, Class<?>[] bindArgTypes) {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> SqlExecution findSqlExecution(BehaviorCommand<RESULT> behaviorCommand) {
        boolean logEnabled = this.isLogEnabled();
        SqlExecution execution = null;
        try {
            String key = behaviorCommand.buildSqlExecutionKey();
            execution = this.getSqlExecution(key);
            if (execution == null) {
                long afterCmd;
                long beforeCmd = 0L;
                if (logEnabled) {
                    beforeCmd = this.systemTime();
                }
                SqlExecutionCreator creator = behaviorCommand.createSqlExecutionCreator();
                execution = this.getOrCreateSqlExecution(key, creator);
                if (logEnabled && beforeCmd != (afterCmd = this.systemTime())) {
                    this.logSqlExecution(behaviorCommand, execution, beforeCmd, afterCmd);
                }
            }
            SqlExecution sqlExecution = execution;
            return sqlExecution;
        }
        finally {
            if (logEnabled) {
                this.logInvocation(behaviorCommand, false);
            }
            this.readyInvokePath(behaviorCommand);
        }
    }

    protected <RESULT> void initializeSqlExecution(BehaviorCommand<RESULT> behaviorCommand) {
        String key = behaviorCommand.buildSqlExecutionKey();
        SqlExecutionCreator creator = behaviorCommand.createSqlExecutionCreator();
        SqlExecution execution = this.getSqlExecution(key);
        if (execution != null) {
            return;
        }
        this.getOrCreateSqlExecution(key, creator);
    }

    protected SqlExecution getSqlExecution(String key) {
        return this._executionMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlExecution getOrCreateSqlExecution(String key, SqlExecutionCreator executionCreator) {
        SqlExecution execution = null;
        Map<String, SqlExecution> map = this._executionMap;
        synchronized (map) {
            execution = this.getSqlExecution(key);
            if (execution != null) {
                return execution;
            }
            if (this.isLogEnabled()) {
                this.log("...Initializing sqlExecution for the key '" + key + "'");
            }
            execution = executionCreator.createSqlExecution();
            this._executionMap.put(key, execution);
        }
        if (execution == null) {
            String msg = "sqlExecutionCreator.createSqlCommand() should not return null:";
            msg = msg + " sqlExecutionCreator=" + executionCreator + " key=" + key;
            throw new IllegalStateException(msg);
        }
        this.toBeDisposable();
        return execution;
    }

    protected Object executeSql(SqlExecution execution, Object[] args) {
        return execution.execute(args);
    }

    protected <RESULT> void logSqlExecution(BehaviorCommand<RESULT> behaviorCommand, SqlExecution execution, long beforeCmd, long afterCmd) {
        String view = DfTraceViewUtil.convertToPerformanceView(afterCmd - beforeCmd);
        this.log("SqlExecution Initialization Cost: [" + view + "]");
    }

    protected <RESULT> void logInvocation(BehaviorCommand<RESULT> behaviorCommand, boolean saveOnly) {
        OutsideSqlContext outsideSqlContext;
        String invokePath;
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        BehaviorInvokeNameResult behaviorInvokeNameResult = this.extractBehaviorInvoke(behaviorCommand, stackTrace);
        this.saveBehaviorInvokeName(behaviorInvokeNameResult);
        BehaviorInvokePathResult invokePathResult = this.buildInvokePath(behaviorCommand, stackTrace, behaviorInvokeNameResult);
        if (invokePathResult != null) {
            this.saveClientInvokeName(invokePathResult);
            this.saveByPassInvokeName(invokePathResult);
            this.saveInvokePath(invokePathResult);
        }
        if (saveOnly) {
            return;
        }
        String expNoMethodSuffix = behaviorInvokeNameResult.getInvocationExpNoMethodSuffix();
        String equalBorder = this.buildFitBorder("", "=", expNoMethodSuffix, false);
        String frameBase = "/=====================================================";
        String spaceBase = "                                                      ";
        this.log("/=====================================================" + equalBorder + "==");
        this.log("                                                      " + behaviorInvokeNameResult.getInvocationExp());
        this.log("                                                      " + equalBorder + "=/");
        if (invokePathResult != null && Srl.is_NotNull_and_NotTrimmedEmpty(invokePath = invokePathResult.getInvokePath())) {
            this.log(invokePath);
        }
        if (behaviorCommand.isOutsideSql() && !behaviorCommand.isProcedure() && (outsideSqlContext = this.getOutsideSqlContext()) != null) {
            this.log("path: " + behaviorCommand.getOutsideSqlPath());
            this.log("option: " + behaviorCommand.getOutsideSqlOption());
        }
    }

    protected <RESULT> BehaviorInvokeNameResult extractBehaviorInvoke(BehaviorCommand<RESULT> behaviorCommand, StackTraceElement[] stackTrace) {
        DBMeta dbmeta = ResourceContext.provideDBMeta(behaviorCommand.getTableDbName());
        Class<?> outsideSqlResultType = null;
        boolean outsideSqlAutoPaging = false;
        if (behaviorCommand.isOutsideSql()) {
            OutsideSqlContext outsideSqlContext = this.getOutsideSqlContext();
            outsideSqlResultType = outsideSqlContext.getResultType();
            outsideSqlAutoPaging = outsideSqlContext.isAutoPagingLogging();
        }
        BehaviorInvokeNameExtractor extractor = this.createBehaviorInvokeNameExtractor(dbmeta, outsideSqlResultType, outsideSqlAutoPaging);
        return extractor.extractBehaviorInvoke(stackTrace);
    }

    protected BehaviorInvokeNameExtractor createBehaviorInvokeNameExtractor(DBMeta dbmeta, Class<?> outsideSqlResultType, boolean outsideSqlAutoPaging) {
        return new BehaviorInvokeNameExtractor(dbmeta, outsideSqlResultType, outsideSqlAutoPaging);
    }

    protected String buildFitBorder(String prefix, String element, String lengthTargetString, boolean space) {
        int length = space ? lengthTargetString.length() / 2 : lengthTargetString.length();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        for (int i = 0; i < length; ++i) {
            sb.append(element);
            if (!space) continue;
            sb.append(" ");
        }
        if (space) {
            sb.append(element);
        }
        return sb.toString();
    }

    protected <RESULT> BehaviorInvokePathResult buildInvokePath(BehaviorCommand<RESULT> behaviorCommand, StackTraceElement[] stackTrace, BehaviorInvokeNameResult behaviorInvokeNameResult) {
        String[] clientNames = this._invokerAssistant.assistClientInvokeNames();
        String[] byPassNames = this._invokerAssistant.assistByPassInvokeNames();
        BehaviorInvokePathBuilder invokePathBuilder = new BehaviorInvokePathBuilder(clientNames, byPassNames);
        return invokePathBuilder.buildInvokePath(stackTrace, behaviorInvokeNameResult);
    }

    protected void saveBehaviorInvokeName(BehaviorInvokeNameResult behaviorInvokeNameResult) {
        String behaviorInvokeName = behaviorInvokeNameResult.getInvocationExp();
        InternalMapContext.setBehaviorInvokeName(behaviorInvokeName);
    }

    protected void saveClientInvokeName(BehaviorInvokePathResult invokePathResult) {
        String clientInvokeName;
        String string = clientInvokeName = invokePathResult != null ? invokePathResult.getClientInvokeName() : null;
        if (clientInvokeName != null && clientInvokeName.trim().length() > 0) {
            InternalMapContext.setClientInvokeName(clientInvokeName);
        }
    }

    protected void saveByPassInvokeName(BehaviorInvokePathResult invokePathResult) {
        String byPassInvokeName;
        String string = byPassInvokeName = invokePathResult != null ? invokePathResult.getByPassInvokeName() : null;
        if (byPassInvokeName != null && byPassInvokeName.trim().length() > 0) {
            InternalMapContext.setByPassInvokeName(byPassInvokeName);
        }
    }

    protected void saveInvokePath(BehaviorInvokePathResult invokePathResult) {
        BehaviorInvokeNameResult behaviorInvokeNameResult = invokePathResult.getBehaviorInvokeNameResult();
        String invokePath = invokePathResult.getInvokePath();
        String callerExp = behaviorInvokeNameResult.getInvocationExp();
        String omitMark = "...";
        InternalMapContext.setSavedInvokePath(Srl.substringLastFront(invokePath, "...") + callerExp);
    }

    protected <RESULT> void logResult(BehaviorCommand<RESULT> behaviorCommand, Class<?> retType, Object ret, long before, long after) {
        BehaviorResultBuilder behaviorResultBuilder = this.createBehaviorResultBuilder();
        String resultExp = behaviorResultBuilder.buildResultExp(retType, ret, before, after);
        this.log(resultExp);
        this.log(" ");
    }

    protected BehaviorResultBuilder createBehaviorResultBuilder() {
        return new BehaviorResultBuilder();
    }

    protected <RESULT> void readyInvokePath(final BehaviorCommand<RESULT> behaviorCommand) {
        InternalMapContext.setInvokePathProvider(new InternalMapContext.InvokePathProvider(){

            @Override
            public String provide() {
                String invokePath = InternalMapContext.getSavedInvokePath();
                if (invokePath != null) {
                    return invokePath;
                }
                BehaviorCommandInvoker.this.logInvocation(behaviorCommand, true);
                return InternalMapContext.getSavedInvokePath();
            }
        });
    }

    protected ResourceContext getParentContext() {
        if (this.isRecursiveInvoking()) {
            return ResourceContext.getResourceContextOnThread();
        }
        return null;
    }

    protected void initializeContext() {
        if (this.isRecursiveInvoking()) {
            this.saveAllContextOnThread();
        }
        this.clearAllCurrentContext();
    }

    protected boolean isRecursiveInvoking() {
        return ResourceContext.isExistResourceContextOnThread();
    }

    protected void closeContext() {
        if (FetchAssistContext.isExistFetchNarrowingBeanOnThread()) {
            FetchNarrowingBean fnbean = FetchAssistContext.getFetchNarrowingBeanOnThread();
            fnbean.restoreIgnoredFetchNarrowing();
        }
        this.clearAllCurrentContext();
        this.restoreAllContextOnThreadIfExists();
    }

    protected void saveAllContextOnThread() {
        ContextStack.saveAllContextOnThread();
    }

    protected void restoreAllContextOnThreadIfExists() {
        ContextStack.restoreAllContextOnThreadIfExists();
    }

    protected void clearAllCurrentContext() {
        ContextStack.clearAllCurrentContext();
    }

    protected OutsideSqlContext getOutsideSqlContext() {
        if (!OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
            return null;
        }
        return OutsideSqlContext.getOutsideSqlContextOnThread();
    }

    protected SqlResultHandler getSqlResultHander() {
        if (!CallbackContext.isExistCallbackContextOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlResultHandler();
    }

    protected void log(String msg) {
        XLog.log(msg);
    }

    protected boolean isLogEnabled() {
        return XLog.isLogEnabled();
    }

    protected void toBeDisposable() {
        this.assertInvokerAssistant();
        this._invokerAssistant.toBeDisposable(this._disposableProcess);
    }

    public <BEHAVIOR> OutsideSqlBasicExecutor<BEHAVIOR> createOutsideSqlBasicExecutor(String tableDbName) {
        OutsideSqlExecutorFactory factory = this._invokerAssistant.assistOutsideSqlExecutorFactory();
        DBDef dbdef = this._invokerAssistant.assistCurrentDBDef();
        StatementConfig config = this._invokerAssistant.assistDefaultStatementConfig();
        return factory.createBasic(this, tableDbName, dbdef, config, null);
    }

    public SQLExceptionDigger getSQLExceptionDigger() {
        return this._invokerAssistant.assistSQLExceptionDigger();
    }

    public SequenceCacheHandler getSequenceCacheHandler() {
        return this._invokerAssistant.assistSequenceCacheHandler();
    }

    public BehaviorExceptionThrower createBehaviorExceptionThrower() {
        return this._invokerAssistant.assistBehaviorExceptionThrower();
    }

    protected Object convertPrimitiveWrapper(Object ret, Class<?> retType) {
        return DfTypeUtil.toWrapper(ret, retType);
    }

    protected Object convertNumber(Object ret, Class<?> retType) {
        return DfTypeUtil.toNumber(ret, retType);
    }

    protected void assertRetType(Class<?> retType, Object ret) {
        if (List.class.isAssignableFrom(retType)) {
            if (ret != null && !(ret instanceof List)) {
                String msg = "The retType is difference from actual return: ";
                msg = msg + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
                throw new IllegalStateException(msg);
            }
        } else if (Entity.class.isAssignableFrom(retType) && ret != null && !(ret instanceof Entity)) {
            String msg = "The retType is difference from actual return: ";
            msg = msg + "retType=" + retType + " ret.getClass()=" + ret.getClass() + " ref=" + ret;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertInvokerAssistant() {
        if (this._invokerAssistant == null) {
            String msg = "The attribute 'invokerAssistant' should not be null!";
            throw new IllegalStateException(msg);
        }
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return new HashMap();
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public void setInvokerAssistant(InvokerAssistant invokerAssistant) {
        this._invokerAssistant = invokerAssistant;
    }
}

