/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.bhv.proposal.callback;

import java.lang.reflect.Method;
import org.codelibs.robot.dbflute.bhv.SqlStringFilter;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommandMeta;
import org.codelibs.robot.dbflute.bhv.proposal.callback.ExecutedSqlCounter;
import org.codelibs.robot.dbflute.bhv.proposal.callback.TraceableSqlAdditionalInfoProvider;
import org.codelibs.robot.dbflute.util.Srl;

public class SimpleTraceableSqlStringFilter
implements SqlStringFilter,
ExecutedSqlCounter {
    protected final Method _actionMethod;
    protected final TraceableSqlAdditionalInfoProvider _additionalInfoProvider;
    protected boolean _markingAtFront;
    protected boolean _suppressMarking;
    protected int _countOfSelectCB;
    protected int _countOfEntityUpdate;
    protected int _countOfQueryUpdate;
    protected int _countOfOutsideSql;
    protected int _countOfProcedure;

    public SimpleTraceableSqlStringFilter(Method actionMethod, TraceableSqlAdditionalInfoProvider additionalInfoProvider) {
        this._actionMethod = actionMethod;
        this._additionalInfoProvider = additionalInfoProvider;
    }

    @Override
    public String filterSelectCB(BehaviorCommandMeta meta, String executedSql) {
        ++this._countOfSelectCB;
        return this.markingSql(executedSql);
    }

    @Override
    public String filterEntityUpdate(BehaviorCommandMeta meta, String executedSql) {
        ++this._countOfEntityUpdate;
        return this.markingSql(executedSql);
    }

    @Override
    public String filterQueryUpdate(BehaviorCommandMeta meta, String executedSql) {
        ++this._countOfQueryUpdate;
        return this.markingSql(executedSql);
    }

    @Override
    public String filterOutsideSql(BehaviorCommandMeta meta, String executedSql) {
        ++this._countOfOutsideSql;
        return null;
    }

    @Override
    public String filterProcedure(BehaviorCommandMeta meta, String executedSql) {
        ++this._countOfProcedure;
        return null;
    }

    protected String markingSql(String executedSql) {
        if (this._suppressMarking) {
            return null;
        }
        String filtered = this._markingAtFront ? "-- " + this.buildInvokeMark() + "\n" + executedSql : executedSql + "\n-- " + this.buildInvokeMark();
        return filtered;
    }

    protected String buildInvokeMark() {
        String addiitonalInfo;
        StringBuilder sb = new StringBuilder();
        sb.append(this._actionMethod.getDeclaringClass().getName());
        sb.append("#").append(this._actionMethod.getName()).append("()");
        if (this._additionalInfoProvider != null && (addiitonalInfo = this._additionalInfoProvider.provide()) != null) {
            sb.append(": ").append(this.resolveUnsupportedMark(addiitonalInfo));
        }
        return sb.toString();
    }

    protected String resolveUnsupportedMark(String info) {
        String resolved = Srl.replace(info, "?", "Q");
        resolved = Srl.replace(resolved, "{", "(");
        resolved = Srl.replace(resolved, "}", ")");
        resolved = Srl.replace(resolved, "'", "\"");
        return resolved;
    }

    public SimpleTraceableSqlStringFilter markingAtFront() {
        this._markingAtFront = true;
        return this;
    }

    public SimpleTraceableSqlStringFilter suppressMarking() {
        this._suppressMarking = true;
        return this;
    }

    @Override
    public int getTotalCountOfSql() {
        return this._countOfSelectCB + this._countOfEntityUpdate + this._countOfQueryUpdate + this._countOfOutsideSql + this._countOfProcedure;
    }

    @Override
    public int getCountOfSelectCB() {
        return this._countOfSelectCB;
    }

    @Override
    public int getCountOfEntityUpdate() {
        return this._countOfEntityUpdate;
    }

    @Override
    public int getCountOfQueryUpdate() {
        return this._countOfQueryUpdate;
    }

    @Override
    public int getCountOfOutsideSql() {
        return this._countOfOutsideSql;
    }

    @Override
    public int getCountOfProcedure() {
        return this._countOfProcedure;
    }

    @Override
    public String toLineDisp() {
        StringBuilder sb = new StringBuilder();
        sb.append("{total=").append(this.getTotalCountOfSql());
        sb.append(", selectCB=").append(this.getCountOfSelectCB());
        sb.append(", entityUpdate=").append(this.getCountOfEntityUpdate());
        sb.append(", queryUpdate=").append(this.getCountOfQueryUpdate());
        sb.append(", outsideSql=").append(this.getCountOfOutsideSql());
        sb.append(", procedure=").append(this.getCountOfProcedure());
        sb.append("}");
        return sb.toString();
    }
}

