/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.cbean.cipher;

import java.util.Map;
import org.codelibs.robot.dbflute.cbean.cipher.CipherFunctionFilter;
import org.codelibs.robot.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.helper.StringKeyMap;

public class GearedCipherManager {
    protected final Map<String, Map<String, ColumnFunctionCipher>> _cipherMap = StringKeyMap.createAsFlexibleConcurrent();

    public void addFunctionFilter(ColumnInfo columnInfo, CipherFunctionFilter filter) {
        ColumnFunctionCipher function;
        this.assertFunctionFilterArgument(columnInfo, filter);
        String tableDbName = columnInfo.getDBMeta().getTableDbName();
        String columnDbName = columnInfo.getColumnDbName();
        Map<String, ColumnFunctionCipher> elementMap = this._cipherMap.get(tableDbName);
        if (elementMap == null) {
            elementMap = StringKeyMap.createAsFlexible();
            this._cipherMap.put(tableDbName, elementMap);
        }
        if ((function = elementMap.get(columnDbName)) == null) {
            function = new ColumnFunctionCipher(columnInfo);
            elementMap.put(columnDbName, function);
        }
        function.addFunctionFilter(filter);
    }

    protected void assertFunctionFilterArgument(ColumnInfo columnInfo, CipherFunctionFilter filter) {
        if (columnInfo == null) {
            String msg = "The argument 'columnInfo' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (filter == null) {
            String msg = "The argument 'filter' should not be null: " + columnInfo;
            throw new IllegalArgumentException(msg);
        }
        if (columnInfo.isPrimary()) {
            String msg = "You cannot set a primary key column for cipher: " + columnInfo;
            throw new IllegalArgumentException(msg);
        }
        if (columnInfo.isForeignKey()) {
            String msg = "You cannot set a foreign key column for cipher: " + columnInfo;
            throw new IllegalArgumentException(msg);
        }
        if (columnInfo.isOptimisticLock()) {
            String msg = "You cannot set an optimistic lock column for cipher: " + columnInfo;
            throw new IllegalArgumentException(msg);
        }
    }

    public ColumnFunctionCipher findColumnFunctionCipher(ColumnInfo columnInfo) {
        return this.findColumnFunctionCipher(columnInfo.getDBMeta().getTableDbName(), columnInfo.getColumnDbName());
    }

    public ColumnFunctionCipher findColumnFunctionCipher(String tableDbName, String columnDbName) {
        Map<String, ColumnFunctionCipher> elementMap = this._cipherMap.get(tableDbName);
        if (elementMap == null) {
            return null;
        }
        return elementMap.get(columnDbName);
    }
}

