/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.dbmeta.alter;

import java.math.BigDecimal;
import java.util.Map;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.alter.AbstractAlterGenerator;
import org.codelibs.robot.dbflute.dbmeta.info.ColumnInfo;
import org.codelibs.robot.dbflute.dbmeta.info.ForeignInfo;

public class AlterGeneratorMySql
extends AbstractAlterGenerator {
    @Override
    public String generateTableRename(String oldTableName, DBMeta newMeta) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, oldTableName);
        sb.append(" rename to ").append(newMeta.getTableSqlName());
        return sb.toString();
    }

    @Override
    public String generateTableRename(DBMeta oldMeta, String newTableName) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, oldMeta);
        sb.append(" rename to ").append(newTableName);
        return sb.toString();
    }

    @Override
    public String generateColumnDefChange(ColumnInfo columnInfo) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, columnInfo.getDBMeta());
        sb.append(" modify ").append(columnInfo.getColumnSqlName());
        this.doBuildColumnDef(sb, columnInfo, null);
        return sb.toString();
    }

    public String generateColumnDefChange(ColumnInfo columnInfo, String afterColumnName) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, columnInfo.getDBMeta());
        sb.append(" modify ").append(columnInfo.getColumnSqlName());
        this.doBuildColumnDef(sb, columnInfo, afterColumnName);
        return sb.toString();
    }

    public String generateColumnDrop(ColumnInfo columnInfo) {
        return this.generateColumnDrop(columnInfo.getDBMeta(), columnInfo.getColumnSqlName().toString());
    }

    public String generateColumnDrop(DBMeta dbmeta, String columnName) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, dbmeta);
        sb.append(" drop column ").append(columnName);
        return sb.toString();
    }

    @Override
    public String generateColumnRename(String oldColumnName, ColumnInfo newColumnInfo) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, newColumnInfo.getDBMeta());
        sb.append(" change column ").append(oldColumnName);
        sb.append(" ").append(newColumnInfo.getColumnSqlName());
        this.doBuildColumnDef(sb, newColumnInfo, null);
        return sb.toString();
    }

    @Override
    public String generateColumnRename(ColumnInfo oldColumnInfo, String newColumnName) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, oldColumnInfo.getDBMeta());
        sb.append(" change column ").append(oldColumnInfo.getColumnSqlName());
        sb.append(" ").append(newColumnName);
        this.doBuildColumnDef(sb, oldColumnInfo, null);
        return sb.toString();
    }

    protected void doBuildColumnDef(StringBuilder sb, ColumnInfo columnInfo, String afterColumnName) {
        sb.append(" ").append(columnInfo.getColumnDbType());
        Integer columnSize = columnInfo.getColumnSize();
        Integer decimalDigits = columnInfo.getDecimalDigits();
        if (columnSize != null && this.needsColumnSize(columnInfo)) {
            sb.append("(").append(columnSize);
            if (decimalDigits != null && decimalDigits > 0) {
                sb.append(", ").append(decimalDigits);
            }
            sb.append(")");
        }
        if (columnInfo.isNotNull()) {
            sb.append(" NOT NULL");
        }
        if (columnInfo.isAutoIncrement()) {
            sb.append(" AUTO_INCREMENT");
        } else {
            String defaultValue = columnInfo.getDefaultValue();
            if (defaultValue != null) {
                if (columnInfo.isObjectNativeTypeString()) {
                    sb.append(" DEFAULT '").append(defaultValue).append("'");
                } else {
                    sb.append(" DEFAULT ").append(defaultValue);
                }
            }
        }
        if (afterColumnName != null) {
            sb.append(" after ").append(afterColumnName);
        }
    }

    protected boolean needsColumnSize(ColumnInfo columnInfo) {
        boolean decimalType = BigDecimal.class.isAssignableFrom(columnInfo.getObjectNativeType());
        if (columnInfo.isObjectNativeTypeNumber() && !decimalType) {
            return false;
        }
        if (columnInfo.isObjectNativeTypeDate()) {
            return false;
        }
        return !columnInfo.getColumnDbType().toLowerCase().endsWith("text");
    }

    @Override
    public String generatePrimaryKeyAdd(ColumnInfo columnInfo) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, columnInfo.getDBMeta());
        sb.append(" add primary key (").append(columnInfo.getColumnSqlName()).append(")");
        return sb.toString();
    }

    @Override
    public String generatePrimaryKeyDrop(DBMeta dbmeta) {
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, dbmeta);
        sb.append(" drop primary key");
        return sb.toString();
    }

    @Override
    public String generateForeignKeyAdd(ForeignInfo foreignInfo) {
        if (!foreignInfo.isPureFK()) {
            String msg = "The foreign info should be from pure FK: " + foreignInfo;
            throw new IllegalArgumentException(msg);
        }
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, foreignInfo.getLocalDBMeta());
        sb.append(" add constraint ").append(foreignInfo.getConstraintName());
        sb.append(" foreign key (");
        Map<ColumnInfo, ColumnInfo> columnInfoMap = foreignInfo.getLocalForeignColumnInfoMap();
        int index = 0;
        for (ColumnInfo columnInfo : columnInfoMap.keySet()) {
            if (index > 0) {
                sb.append(", ");
            }
            sb.append(columnInfo.getColumnSqlName());
            ++index;
        }
        sb.append(") references ").append(foreignInfo.getForeignDBMeta().getTableSqlName()).append("(");
        index = 0;
        for (ColumnInfo columnInfo : columnInfoMap.values()) {
            if (index > 0) {
                sb.append(", ");
            }
            sb.append(columnInfo.getColumnSqlName());
            ++index;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String generateForeignKeyDrop(ForeignInfo foreignInfo) {
        if (!foreignInfo.isPureFK()) {
            String msg = "The foreign info should be from pure FK: " + foreignInfo;
            throw new IllegalArgumentException(msg);
        }
        StringBuilder sb = new StringBuilder();
        this.doBuildAlterTable(sb, foreignInfo.getLocalDBMeta());
        sb.append(" drop foreign key ").append(foreignInfo.getConstraintName());
        return sb.toString();
    }
}

