/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.optional;

import org.codelibs.robot.dbflute.exception.EntityAlreadyDeletedException;
import org.codelibs.robot.dbflute.optional.BaseOptional;
import org.codelibs.robot.dbflute.optional.OptionalObjectConsumer;
import org.codelibs.robot.dbflute.optional.OptionalObjectExceptionThrower;
import org.codelibs.robot.dbflute.optional.OptionalObjectFunction;
import org.codelibs.robot.dbflute.optional.OptionalObjectPredicate;

public class OptionalObject<OBJ>
extends BaseOptional<OBJ> {
    protected static final OptionalObject<Object> EMPTY_INSTANCE = new OptionalObject<Object>(null, new OptionalObjectExceptionThrower(){

        @Override
        public void throwNotFoundException() {
            String msg = "The empty optional so the value is null.";
            throw new EntityAlreadyDeletedException(msg);
        }
    });
    protected static final OptionalObjectExceptionThrower NOWAY_THROWER = new OptionalObjectExceptionThrower(){

        @Override
        public void throwNotFoundException() {
            throw new EntityAlreadyDeletedException("no way");
        }
    };

    public OptionalObject(OBJ object, OptionalObjectExceptionThrower thrower) {
        super(object, thrower);
    }

    public static <EMPTY> OptionalObject<EMPTY> empty() {
        return EMPTY_INSTANCE;
    }

    public static <ENTITY> OptionalObject<ENTITY> of(ENTITY object) {
        if (object == null) {
            String msg = "The argument 'object' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalObject<ENTITY>(object, NOWAY_THROWER);
    }

    public static <ENTITY> OptionalObject<ENTITY> ofNullable(ENTITY object, OptionalObjectExceptionThrower thrower) {
        if (object != null) {
            return OptionalObject.of(object);
        }
        return new OptionalObject<ENTITY>(object, thrower);
    }

    public OBJ get() {
        return this.directlyGet();
    }

    public void ifPresent(OptionalObjectConsumer<OBJ> consumer) {
        this.callbackIfPresent(consumer);
    }

    public boolean isPresent() {
        return this.exists();
    }

    public OptionalObject<OBJ> filter(OptionalObjectPredicate<OBJ> predicate) {
        return (OptionalObject)this.callbackFilter(predicate);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalFilteredObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    public <RESULT> OptionalObject<RESULT> map(OptionalObjectFunction<? super OBJ, ? extends RESULT> mapper) {
        return (OptionalObject)this.callbackMapping(mapper);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalMappedObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    public <RESULT> OptionalObject<RESULT> flatMap(OptionalObjectFunction<? super OBJ, OptionalObject<RESULT>> mapper) {
        return this.callbackFlatMapping(mapper);
    }

    public OBJ orElse(OBJ other) {
        return this.directlyGetOrElse(other);
    }

    public OBJ orElseNull() {
        return this.directlyGetOrElse(null);
    }

    public void required(OptionalObjectConsumer<OBJ> consumer) {
        this.callbackRequired(consumer);
    }
}

