/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.outsidesql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.DBMetaProvider;
import org.codelibs.robot.dbflute.exception.OutsideSqlNotFoundException;
import org.codelibs.robot.dbflute.exception.OutsideSqlReadFailureException;
import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.jdbc.CursorHandler;
import org.codelibs.robot.dbflute.jdbc.StatementConfig;
import org.codelibs.robot.dbflute.outsidesql.OutsideSqlFilter;
import org.codelibs.robot.dbflute.outsidesql.OutsideSqlOption;
import org.codelibs.robot.dbflute.resource.DBFluteSystem;
import org.codelibs.robot.dbflute.util.DfResourceUtil;
import org.codelibs.robot.dbflute.util.Srl;

public class OutsideSqlContext {
    private static final Log _log = LogFactory.getLog(OutsideSqlContext.class);
    private static final ThreadLocal<OutsideSqlContext> _threadLocal = new ThreadLocal();
    protected final DBMetaProvider _dbmetaProvider;
    protected final String _outsideSqlPackage;
    protected String _outsideSqlPath;
    protected Object _parameterBean;
    protected Class<?> _resultType;
    protected CursorHandler _cursorHandler;
    protected String _methodName;
    protected StatementConfig _statementConfig;
    protected String _tableDbName;
    protected boolean _offsetByCursorForcedly;
    protected boolean _limitByCursorForcedly;
    protected boolean _autoPagingLogging;
    protected OutsideSqlFilter _outsideSqlFilter;
    protected boolean _removeBlockComment;
    protected boolean _removeLineComment;
    protected boolean _formatSql;
    protected boolean _internalDebug;

    public static OutsideSqlContext getOutsideSqlContextOnThread() {
        return _threadLocal.get();
    }

    public static void setOutsideSqlContextOnThread(OutsideSqlContext outsideSqlContext) {
        if (outsideSqlContext == null) {
            String msg = "The argument[outsideSqlContext] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(outsideSqlContext);
    }

    public static boolean isExistOutsideSqlContextOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearOutsideSqlContextOnThread() {
        _threadLocal.set(null);
    }

    public static String generateSpecifiedOutsideSqlUniqueKey(String methodName, String path, Object pmb, OutsideSqlOption option, Class<?> resultType) {
        String pmbKey = pmb != null ? pmb.getClass().getName() : "null";
        String resultKey = resultType != null ? resultType.getName() : "null";
        String tableDbName = option.getTableDbName();
        String generatedUniqueKey = option.generateUniqueKey();
        return tableDbName + ":" + methodName + "():" + path + ":" + pmbKey + ":" + generatedUniqueKey + ":" + resultKey;
    }

    public static void throwOutsideSqlNotFoundException(String path) {
        String msg = "Look! Read the message below." + OutsideSqlContext.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + OutsideSqlContext.ln();
        msg = msg + "The outsideSql was not found!" + OutsideSqlContext.ln();
        msg = msg + OutsideSqlContext.ln();
        msg = msg + "[Advice]" + OutsideSqlContext.ln();
        msg = msg + "Please confirm the existence of your target file of outsideSql on your classpath." + OutsideSqlContext.ln();
        msg = msg + "And please confirm the file name and the file path STRICTLY!" + OutsideSqlContext.ln();
        msg = msg + OutsideSqlContext.ln();
        msg = msg + "[Specified OutsideSql Path]" + OutsideSqlContext.ln() + path + OutsideSqlContext.ln();
        msg = msg + "* * * * * * * * * */";
        throw new OutsideSqlNotFoundException(msg);
    }

    public OutsideSqlContext(DBMetaProvider dbmetaProvider, String outsideSqlPackage) {
        if (dbmetaProvider == null) {
            String msg = "The argument 'dbmetaProvider' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._dbmetaProvider = dbmetaProvider;
        this._outsideSqlPackage = outsideSqlPackage;
    }

    public String readFilteredOutsideSql(String sqlFileEncoding, String dbmsSuffix) {
        String sql = this.readPlainOutsideSql(sqlFileEncoding, dbmsSuffix);
        sql = this.replaceOutsideSqlBindCharacterOnLineComment(sql);
        if (this._outsideSqlFilter != null) {
            sql = this._outsideSqlFilter.filterReading(sql);
        }
        return sql;
    }

    protected String replaceOutsideSqlBindCharacterOnLineComment(String sql) {
        String[] lines;
        String bindCharacter = "?";
        if (sql.indexOf("?") < 0) {
            return sql;
        }
        String lineSeparator = "\n";
        if (sql.indexOf("\n") < 0) {
            return sql;
        }
        String lineCommentMark = "--";
        if (sql.indexOf("--") < 0) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = sql.split("\n")) {
            int lineCommentIndex = line.indexOf("--");
            if (lineCommentIndex < 0) {
                sb.append(line).append("\n");
                continue;
            }
            String lineComment = line.substring(lineCommentIndex);
            if (lineComment.contains("ELSE") || !lineComment.contains("?")) {
                sb.append(line).append("\n");
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("...Replacing bind character on line comment: " + lineComment));
            }
            String filteredLineComment = OutsideSqlContext.replaceString(lineComment, "?", "Q");
            sb.append(line.substring(0, lineCommentIndex)).append(filteredLineComment).append("\n");
        }
        return sb.toString();
    }

    protected String readPlainOutsideSql(String sqlFileEncoding, String dbmsSuffix) {
        String standardPath = this._outsideSqlPath;
        String readSql = this.doReadPlainOutsideSql(sqlFileEncoding, dbmsSuffix, standardPath);
        if (readSql != null) {
            return readSql;
        }
        String pureName = Srl.substringLastRear(standardPath, "/");
        if (pureName.contains("Bhv_")) {
            String dir = Srl.substringLastFront(standardPath, "/");
            String filtered = Srl.replace(pureName, "Bhv_", "BhvAp_");
            String bhvApPath = dir + "/" + filtered;
            readSql = this.doReadPlainOutsideSql(sqlFileEncoding, dbmsSuffix, bhvApPath);
        }
        if (readSql != null) {
            return readSql;
        }
        OutsideSqlContext.throwOutsideSqlNotFoundException(standardPath);
        return null;
    }

    protected String doReadPlainOutsideSql(String sqlFileEncoding, String dbmsSuffix, String standardPath) {
        String sql;
        String dbmsPath = this.buildDbmsPath(standardPath, dbmsSuffix);
        if (this._internalDebug && _log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("...Reading the outside-SQL: ").append(standardPath);
            sb.append(" {").append(sqlFileEncoding).append(", ").append(dbmsSuffix).append("}");
            _log.debug((Object)sb.toString());
        }
        if (this.isExistResource(dbmsPath)) {
            if (this._internalDebug && _log.isDebugEnabled()) {
                _log.debug((Object)("Found the outside-SQL for the DBMS: " + dbmsPath));
            }
            sql = this.readText(dbmsPath, sqlFileEncoding);
        } else {
            String resolvedSql = this.doReadOutsideSqlWithAliasSuffix(standardPath, sqlFileEncoding, dbmsSuffix);
            if (resolvedSql != null) {
                sql = resolvedSql;
            } else if (this.isExistResource(standardPath)) {
                sql = this.readText(standardPath, sqlFileEncoding);
            } else {
                return null;
            }
        }
        return this.removeInitialUnicodeBomIfNeeds(sqlFileEncoding, sql);
    }

    protected String doReadOutsideSqlWithAliasSuffix(String standardPath, String sqlFileEncoding, String dbmsSuffix) {
        String anotherPath = null;
        if ("_postgresql".equals(dbmsSuffix)) {
            anotherPath = this.buildDbmsPath(standardPath, "_postgre");
        } else if ("_sqlserver".equals(dbmsSuffix)) {
            anotherPath = this.buildDbmsPath(standardPath, "_mssql");
        }
        if (anotherPath != null && this.isExistResource(anotherPath)) {
            return this.readText(anotherPath, sqlFileEncoding);
        }
        return null;
    }

    protected String buildDbmsPath(String standardPath, String dbmsSuffix) {
        String dbmsPath;
        int lastIndexOfDot = standardPath.lastIndexOf(".");
        if (lastIndexOfDot >= 0 && !standardPath.substring(lastIndexOfDot).contains("/")) {
            String base = standardPath.substring(0, lastIndexOfDot);
            dbmsPath = base + dbmsSuffix + standardPath.substring(lastIndexOfDot);
        } else {
            dbmsPath = standardPath + dbmsSuffix;
        }
        return dbmsPath;
    }

    protected String removeInitialUnicodeBomIfNeeds(String sqlFileEncoding, String sql) {
        if ("UTF-8".equalsIgnoreCase(sqlFileEncoding) && sql.length() > 0 && sql.charAt(0) == '\ufeff') {
            sql = sql.substring(1);
        }
        return sql;
    }

    public void setupBehaviorQueryPathIfNeeds() {
        if (!this.isBehaviorQueryPathEnabled()) {
            return;
        }
        if (this._outsideSqlPath.contains(":")) {
            String subDirectoryValue = this._outsideSqlPath.substring(0, this._outsideSqlPath.lastIndexOf(":"));
            String subDirectoryPath = OutsideSqlContext.replaceString(subDirectoryValue, ":", "/");
            String behaviorQueryPath = this._outsideSqlPath.substring(this._outsideSqlPath.lastIndexOf(":") + ":".length());
            String behaviorClassPath = OutsideSqlContext.replaceString(this.buildBehaviorSqlPackageName(), ".", "/");
            String behaviorPackagePath = behaviorClassPath.substring(0, behaviorClassPath.lastIndexOf("/"));
            String behaviorClassName = behaviorClassPath.substring(behaviorClassPath.lastIndexOf("/") + "/".length());
            this._outsideSqlPath = behaviorPackagePath + "/" + subDirectoryPath + "/" + behaviorClassName + "_" + behaviorQueryPath + ".sql";
        } else {
            this._outsideSqlPath = OutsideSqlContext.replaceString(this.buildBehaviorSqlPackageName(), ".", "/") + "_" + this._outsideSqlPath + ".sql";
        }
    }

    protected String buildBehaviorSqlPackageName() {
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(this._tableDbName);
        String behaviorTypeName = dbmeta.getBehaviorTypeName();
        String outsideSqlPackage = this._outsideSqlPackage;
        if (outsideSqlPackage != null && outsideSqlPackage.trim().length() > 0) {
            String behaviorClassName = behaviorTypeName.substring(behaviorTypeName.lastIndexOf(".") + ".".length());
            String tmp = behaviorTypeName.substring(0, behaviorTypeName.lastIndexOf("."));
            String exbhvName = tmp.contains(".") ? tmp.substring(tmp.lastIndexOf(".") + ".".length()) : tmp;
            return outsideSqlPackage + "." + exbhvName + "." + behaviorClassName;
        }
        return behaviorTypeName;
    }

    protected boolean isBehaviorQueryPathEnabled() {
        if (this.isProcedure()) {
            return false;
        }
        return this._outsideSqlPath != null && !this._outsideSqlPath.contains("/") && !this._outsideSqlPath.contains(".") && this._tableDbName != null;
    }

    public boolean isSpecifiedOutsideSql() {
        return this._outsideSqlPath != null;
    }

    public boolean isProcedure() {
        return this._methodName != null && this._methodName.startsWith("call");
    }

    protected boolean isExistResource(String path) {
        return DfResourceUtil.isExist(path);
    }

    protected String readText(String path, String sqlFileEncoding) {
        InputStream ins = DfResourceUtil.getResourceStream(path);
        Reader reader = null;
        try {
            reader = this.createInputStreamReader(ins, sqlFileEncoding);
            String string = this.readText(reader);
            return string;
        }
        catch (IOException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Failed to read the text for outside-SQL.");
            br.addItem("OutsideSql Path");
            br.addElement(path);
            br.addItem("SQL File Encoding");
            br.addElement(sqlFileEncoding);
            String msg = br.buildExceptionMessage();
            throw new OutsideSqlReadFailureException(msg);
        }
        finally {
            block10: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignored) {
                        if (!this._internalDebug || !_log.isDebugEnabled()) break block10;
                        _log.debug((Object)("Failed to close the reader: path=" + path), (Throwable)ignored);
                    }
                }
            }
        }
    }

    protected Reader createInputStreamReader(InputStream ins, String encoding) throws IOException {
        return new InputStreamReader(ins, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readText(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder(100);
        BufferedReader br = null;
        try {
            int n;
            br = new BufferedReader(reader);
            char[] buf = new char[8192];
            while ((n = br.read(buf)) >= 0) {
                sb.append(buf, 0, n);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignored) {}
            }
        }
        return sb.toString();
    }

    protected static String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected static String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public String getOutsideSqlPath() {
        return this._outsideSqlPath;
    }

    public void setOutsideSqlPath(String outsideSqlPath) {
        this._outsideSqlPath = outsideSqlPath;
    }

    public Object getParameterBean() {
        return this._parameterBean;
    }

    public void setParameterBean(Object parameterBean) {
        this._parameterBean = parameterBean;
    }

    public Class<?> getResultType() {
        return this._resultType;
    }

    public void setResultType(Class<?> resultType) {
        this._resultType = resultType;
    }

    public CursorHandler getCursorHandler() {
        return this._cursorHandler;
    }

    public void setCursorHandler(CursorHandler handler) {
        this._cursorHandler = handler;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public void setMethodName(String methodName) {
        this._methodName = methodName;
    }

    public StatementConfig getStatementConfig() {
        return this._statementConfig;
    }

    public void setStatementConfig(StatementConfig statementConfig) {
        this._statementConfig = statementConfig;
    }

    public String getTableDbName() {
        return this._tableDbName;
    }

    public void setTableDbName(String tableDbName) {
        this._tableDbName = tableDbName;
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public void setOffsetByCursorForcedly(boolean offsetByCursorForcedly) {
        this._offsetByCursorForcedly = offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public void setLimitByCursorForcedly(boolean limitByCursorForcedly) {
        this._limitByCursorForcedly = limitByCursorForcedly;
    }

    public boolean isAutoPagingLogging() {
        return this._autoPagingLogging;
    }

    public void setAutoPagingLogging(boolean autoPagingLogging) {
        this._autoPagingLogging = autoPagingLogging;
    }

    public OutsideSqlFilter getOutsideSqlFilter() {
        return this._outsideSqlFilter;
    }

    public void setOutsideSqlFilter(OutsideSqlFilter outsideSqlFilter) {
        this._outsideSqlFilter = outsideSqlFilter;
    }

    public boolean isRemoveBlockComment() {
        return this._removeBlockComment;
    }

    public void setRemoveBlockComment(boolean removeBlockComment) {
        this._removeBlockComment = removeBlockComment;
    }

    public boolean isRemoveLineComment() {
        return this._removeLineComment;
    }

    public void setRemoveLineComment(boolean removeLineComment) {
        this._removeLineComment = removeLineComment;
    }

    public boolean isFormatSql() {
        return this._formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this._formatSql = formatSql;
    }

    public boolean isInternalDebug() {
        return this._internalDebug;
    }

    public void setInternalDebug(boolean internalDebug) {
        this._internalDebug = internalDebug;
    }
}

