/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.resource;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.codelibs.robot.dbflute.AccessContext;
import org.codelibs.robot.dbflute.DBDef;
import org.codelibs.robot.dbflute.bhv.core.BehaviorCommand;
import org.codelibs.robot.dbflute.cbean.ConditionBean;
import org.codelibs.robot.dbflute.cbean.ConditionBeanContext;
import org.codelibs.robot.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.codelibs.robot.dbflute.cbean.cipher.GearedCipherManager;
import org.codelibs.robot.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.codelibs.robot.dbflute.dbmeta.DBMeta;
import org.codelibs.robot.dbflute.dbmeta.DBMetaProvider;
import org.codelibs.robot.dbflute.exception.factory.SQLExceptionHandlerFactory;
import org.codelibs.robot.dbflute.exception.handler.SQLExceptionHandler;
import org.codelibs.robot.dbflute.helper.StringKeyMap;
import org.codelibs.robot.dbflute.jdbc.ValueType;
import org.codelibs.robot.dbflute.resource.ResourceParameter;
import org.codelibs.robot.dbflute.twowaysql.SqlAnalyzer;
import org.codelibs.robot.dbflute.twowaysql.factory.SqlAnalyzerFactory;

public class ResourceContext {
    private static final ThreadLocal<ResourceContext> threadLocal = new ThreadLocal();
    protected ResourceContext _parentContext;
    protected BehaviorCommand<?> _behaviorCommand;
    protected DBDef _currentDBDef;
    protected DBMetaProvider _dbmetaProvider;
    protected SqlClauseCreator _sqlClauseCreator;
    protected SqlAnalyzerFactory _sqlAnalyzerFactory;
    protected SQLExceptionHandlerFactory _sqlExceptionHandlerFactory;
    protected GearedCipherManager _gearedCipherManager;
    protected ResourceParameter _resourceParameter;

    public static ResourceContext getResourceContextOnThread() {
        return threadLocal.get();
    }

    public static void setResourceContextOnThread(ResourceContext resourceContext) {
        threadLocal.set(resourceContext);
    }

    public static boolean isExistResourceContextOnThread() {
        return threadLocal.get() != null;
    }

    public static void clearResourceContextOnThread() {
        threadLocal.set(null);
    }

    public static BehaviorCommand<?> behaviorCommand() {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        BehaviorCommand<?> behaviorCommand = context.getBehaviorCommand();
        if (behaviorCommand == null) {
            String msg = "The behavior command should exist: context=" + context;
            throw new IllegalStateException(msg);
        }
        return behaviorCommand;
    }

    public static DBDef currentDBDef() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return DBDef.Unknown;
        }
        DBDef currentDBDef = ResourceContext.getResourceContextOnThread().getCurrentDBDef();
        if (currentDBDef == null) {
            return DBDef.Unknown;
        }
        return currentDBDef;
    }

    public static boolean isCurrentDBDef(DBDef targetDBDef) {
        return ResourceContext.currentDBDef().equals((Object)targetDBDef);
    }

    public static DBMetaProvider dbmetaProvider() {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        DBMetaProvider provider = context.getDBMetaProvider();
        if (provider == null) {
            String msg = "The provider of DB meta should exist: context=" + context;
            throw new IllegalStateException(msg);
        }
        return provider;
    }

    public static DBMeta provideDBMeta(String tableFlexibleName) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return null;
        }
        DBMetaProvider provider = ResourceContext.getResourceContextOnThread().getDBMetaProvider();
        return provider != null ? provider.provideDBMeta(tableFlexibleName) : null;
    }

    public static DBMeta provideDBMeta(Class<?> entityType) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return null;
        }
        DBMetaProvider provider = ResourceContext.getResourceContextOnThread().getDBMetaProvider();
        return provider != null ? provider.provideDBMeta(entityType) : null;
    }

    public static DBMeta provideDBMetaChecked(String tableFlexibleName) {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        DBMetaProvider provider = context.getDBMetaProvider();
        if (provider == null) {
            String msg = "The provider of DB meta should exist:";
            msg = msg + " tableFlexibleName=" + tableFlexibleName + " context=" + context;
            throw new IllegalStateException(msg);
        }
        return provider.provideDBMetaChecked(tableFlexibleName);
    }

    public static DBMeta provideDBMetaChecked(Class<?> entityType) {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        DBMetaProvider provider = context.getDBMetaProvider();
        if (provider == null) {
            String msg = "The provider of DB meta should exist:";
            msg = msg + " entityType=" + entityType + " context=" + context;
            throw new IllegalStateException(msg);
        }
        return provider.provideDBMetaChecked(entityType);
    }

    public static SqlAnalyzer createSqlAnalyzer(String sql, boolean blockNullParameter) {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        SqlAnalyzerFactory factory = context.getSqlAnalyzerFactory();
        if (factory == null) {
            String msg = "The factory of SQL analyzer should exist:";
            msg = msg + " sql=" + sql + " blockNullParameter=" + blockNullParameter;
            throw new IllegalStateException(msg);
        }
        SqlAnalyzer created = factory.create(sql, blockNullParameter);
        if (created != null) {
            return created;
        }
        String msg = "The factory should not return null:";
        msg = msg + " sql=" + sql + " factory=" + factory;
        throw new IllegalStateException(msg);
    }

    public static SQLExceptionHandler createSQLExceptionHandler() {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        SQLExceptionHandlerFactory factory = context.getSQLExceptionHandlerFactory();
        if (factory == null) {
            String msg = "The factory of SQLException handler should exist.";
            throw new IllegalStateException(msg);
        }
        SQLExceptionHandler created = factory.create();
        if (created != null) {
            return created;
        }
        String msg = "The factory should not return null: factory=" + factory;
        throw new IllegalStateException(msg);
    }

    public static boolean isUniqueConstraintException(String sqlState, Integer errorCode) {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return false;
        }
        SqlClauseCreator sqlClauseCreator = ResourceContext.getResourceContextOnThread().getSqlClauseCreator();
        if (sqlClauseCreator == null) {
            return false;
        }
        return ResourceContext.currentDBDef().dbway().isUniqueConstraintException(sqlState, errorCode);
    }

    public static ColumnFunctionCipher findColumnFunctionCipher(String tableDbName, String columnDbName) {
        ResourceContext.assertResourceContextExists();
        ResourceContext context = ResourceContext.getResourceContextOnThread();
        GearedCipherManager manager = context.getGearedCipherManager();
        return manager != null ? manager.findColumnFunctionCipher(tableDbName, columnDbName) : null;
    }

    public static String getOutsideSqlPackage() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        return resourceParameter != null ? resourceParameter.getOutsideSqlPackage() : null;
    }

    public static String getLogDateFormat() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        return resourceParameter != null ? resourceParameter.getLogDateFormat() : null;
    }

    public static String getLogTimestampFormat() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        return resourceParameter != null ? resourceParameter.getLogTimestampFormat() : null;
    }

    public static boolean isInternalDebug() {
        ResourceParameter resourceParameter = ResourceContext.resourceParameter();
        return resourceParameter != null ? resourceParameter.isInternalDebug() : false;
    }

    protected static ResourceParameter resourceParameter() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            return null;
        }
        return ResourceContext.getResourceContextOnThread().getResourceParameter();
    }

    protected static void assertResourceContextExists() {
        if (!ResourceContext.isExistResourceContextOnThread()) {
            String msg = "The resource context should exist!";
            throw new IllegalStateException(msg);
        }
    }

    public static Date getAccessDate() {
        return AccessContext.getAccessDateOnThread();
    }

    public static Timestamp getAccessTimestamp() {
        return AccessContext.getAccessTimestampOnThread();
    }

    public static Map<String, String> createSelectColumnMap(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        Map<String, String> selectIndexReverseMap = ResourceContext.getSelectIndexReverseMap();
        StringKeyMap<String> columnMap = StringKeyMap.createAsFlexible();
        for (int i = 0; i < count; ++i) {
            String mappedName;
            String columnLabel = rsmd.getColumnLabel(i + 1);
            int dotIndex = columnLabel.lastIndexOf(46);
            if (dotIndex >= 0) {
                columnLabel = columnLabel.substring(dotIndex + 1);
            }
            String realColumnName = selectIndexReverseMap != null ? ((mappedName = selectIndexReverseMap.get(columnLabel)) != null ? mappedName : columnLabel) : columnLabel;
            columnMap.put(realColumnName, realColumnName);
        }
        return columnMap;
    }

    public static Map<String, Integer> getSelectIndexMap() {
        if (!ConditionBeanContext.isExistConditionBeanOnThread()) {
            return null;
        }
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().getSelectIndexMap();
    }

    protected static Map<String, String> getSelectIndexReverseMap() {
        if (!ConditionBeanContext.isExistConditionBeanOnThread()) {
            return null;
        }
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        return cb.getSqlClause().getSelectIndexReverseMap();
    }

    public static Object getValue(ResultSet rs, String columnName, ValueType valueType, Map<String, Integer> selectIndexMap) throws SQLException {
        Integer selectIndex = selectIndexMap.get(columnName);
        if (selectIndex != null) {
            return valueType.getValue(rs, (int)selectIndex);
        }
        return valueType.getValue(rs, columnName);
    }

    public String toString() {
        return "{" + this._behaviorCommand + ", " + (Object)((Object)this._currentDBDef) + ", " + this._dbmetaProvider + ", " + this._sqlClauseCreator + ", " + this._sqlAnalyzerFactory + ", " + this._sqlExceptionHandlerFactory + ", " + this._gearedCipherManager + ", " + this._resourceParameter + "}";
    }

    public ResourceContext getParentContext() {
        return this._parentContext;
    }

    public void setParentContext(ResourceContext parentContext) {
        this._parentContext = parentContext;
    }

    public BehaviorCommand<?> getBehaviorCommand() {
        return this._behaviorCommand;
    }

    public void setBehaviorCommand(BehaviorCommand<?> behaviorCommand) {
        this._behaviorCommand = behaviorCommand;
    }

    public DBDef getCurrentDBDef() {
        return this._currentDBDef;
    }

    public void setCurrentDBDef(DBDef currentDBDef) {
        this._currentDBDef = currentDBDef;
    }

    public DBMetaProvider getDBMetaProvider() {
        return this._dbmetaProvider;
    }

    public void setDBMetaProvider(DBMetaProvider dbmetaProvider) {
        this._dbmetaProvider = dbmetaProvider;
    }

    public SqlClauseCreator getSqlClauseCreator() {
        return this._sqlClauseCreator;
    }

    public void setSqlClauseCreator(SqlClauseCreator sqlClauseCreator) {
        this._sqlClauseCreator = sqlClauseCreator;
    }

    public SqlAnalyzerFactory getSqlAnalyzerFactory() {
        return this._sqlAnalyzerFactory;
    }

    public void setSqlAnalyzerFactory(SqlAnalyzerFactory sqlAnalyzerFactory) {
        this._sqlAnalyzerFactory = sqlAnalyzerFactory;
    }

    public SQLExceptionHandlerFactory getSQLExceptionHandlerFactory() {
        return this._sqlExceptionHandlerFactory;
    }

    public void setSQLExceptionHandlerFactory(SQLExceptionHandlerFactory sqlExceptionHandlerFactory) {
        this._sqlExceptionHandlerFactory = sqlExceptionHandlerFactory;
    }

    public GearedCipherManager getGearedCipherManager() {
        return this._gearedCipherManager;
    }

    public void setGearedCipherManager(GearedCipherManager gearedCipherManager) {
        this._gearedCipherManager = gearedCipherManager;
    }

    public ResourceParameter getResourceParameter() {
        return this._resourceParameter;
    }

    public void setResourceParameter(ResourceParameter resourceParameter) {
        this._resourceParameter = resourceParameter;
    }
}

