/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.s2dao.sqlcommand;

import java.util.Set;
import javax.sql.DataSource;
import org.codelibs.robot.dbflute.bhv.DeleteOption;
import org.codelibs.robot.dbflute.cbean.ConditionBean;
import org.codelibs.robot.dbflute.jdbc.StatementConfig;
import org.codelibs.robot.dbflute.jdbc.StatementFactory;
import org.codelibs.robot.dbflute.resource.InternalMapContext;
import org.codelibs.robot.dbflute.s2dao.sqlcommand.TnAbstractEntityDynamicCommand;
import org.codelibs.robot.dbflute.s2dao.sqlhandler.TnDeleteEntityHandler;

public class TnDeleteEntityDynamicCommand
extends TnAbstractEntityDynamicCommand {
    protected boolean _optimisticLockHandling;
    protected boolean _versionNoAutoIncrementOnMemory;

    public TnDeleteEntityDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        Object bean = this.extractBeanFromArgsChecked(args);
        DeleteOption<ConditionBean> option = this.extractDeleteOption(args);
        this.prepareStatementConfigOnThreadIfExists(option);
        String sql = this.filterExecutedSql(this.createDeleteSql(bean, option));
        return this.doExecute(bean, sql, option);
    }

    protected DeleteOption<ConditionBean> extractDeleteOption(Object[] args) {
        if (args.length < 2 || args[1] == null) {
            return null;
        }
        DeleteOption option = (DeleteOption)args[1];
        return option;
    }

    protected void prepareStatementConfigOnThreadIfExists(DeleteOption<ConditionBean> option) {
        StatementConfig config;
        StatementConfig statementConfig = config = option != null ? option.getDeleteStatementConfig() : null;
        if (config != null) {
            InternalMapContext.setUpdateStatementConfig(config);
        }
    }

    protected Object doExecute(Object bean, String sql, DeleteOption<ConditionBean> option) {
        TnDeleteEntityHandler handler = this.createDeleteEntityHandler(sql, option);
        Object[] realArgs = new Object[]{bean};
        handler.setExceptionMessageSqlArgs(realArgs);
        int result = handler.execute(realArgs);
        return result;
    }

    protected String createDeleteSql(Object bean, DeleteOption<ConditionBean> option) {
        this.checkPrimaryKey();
        StringBuilder sb = new StringBuilder(64);
        sb.append("delete from ").append(this._targetDBMeta.getTableSqlName());
        Set<String> uniqueDrivenPropSet = this.extractUniqueDrivenPropSet(bean);
        this.setupUpdateWhere(sb, uniqueDrivenPropSet, this._optimisticLockHandling);
        return sb.toString();
    }

    protected TnDeleteEntityHandler createDeleteEntityHandler(String sql, DeleteOption<ConditionBean> option) {
        TnDeleteEntityHandler handler = this.newDeleteEntityHandler(sql);
        handler.setOptimisticLockHandling(this._optimisticLockHandling);
        handler.setVersionNoAutoIncrementOnMemory(this._versionNoAutoIncrementOnMemory);
        handler.setDeleteOption(option);
        return handler;
    }

    protected TnDeleteEntityHandler newDeleteEntityHandler(String sql) {
        return new TnDeleteEntityHandler(this._dataSource, this._statementFactory, sql, this._beanMetaData);
    }

    public void setOptimisticLockHandling(boolean optimisticLockHandling) {
        this._optimisticLockHandling = optimisticLockHandling;
    }
}

