/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.robot.dbflute.twowaysql.node;

import org.codelibs.robot.dbflute.exception.factory.ExceptionMessageBuilder;
import org.codelibs.robot.dbflute.twowaysql.context.CommandContext;
import org.codelibs.robot.dbflute.twowaysql.exception.ForCommentParameterNullElementException;
import org.codelibs.robot.dbflute.twowaysql.node.AbstractNode;
import org.codelibs.robot.dbflute.twowaysql.node.BindVariableNode;
import org.codelibs.robot.dbflute.twowaysql.node.LoopAcceptable;
import org.codelibs.robot.dbflute.twowaysql.node.LoopInfo;
import org.codelibs.robot.dbflute.twowaysql.node.Node;

public abstract class ScopeNode
extends AbstractNode {
    protected void processAcceptingChildren(CommandContext ctx, LoopInfo loopInfo) {
        int childSize = this.getChildSize();
        for (int i = 0; i < childSize; ++i) {
            Node child = this.getChild(i);
            if (loopInfo != null) {
                if (child instanceof LoopAcceptable) {
                    this.handleLoopElementNullParameter(child, loopInfo);
                    ((LoopAcceptable)((Object)child)).accept(ctx, loopInfo);
                    continue;
                }
                child.accept(ctx);
                continue;
            }
            child.accept(ctx);
        }
    }

    protected void handleLoopElementNullParameter(Node child, LoopInfo loopInfo) {
        Object parameter;
        if (child instanceof BindVariableNode && ((BindVariableNode)child).isBlockNullParameter() && (parameter = loopInfo.getCurrentParameter()) == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The parameter in list for bind variable was null.");
            br.addItem("Advice");
            br.addElement("Bind variable for select does not allow null value.");
            br.addElement("Confirm your target parameter in the list.");
            br.addItem("Parameter List");
            br.addElement(loopInfo.getParameterList());
            br.addItem("Current Index");
            br.addElement(loopInfo.getLoopIndex());
            br.addItem("FOR Comment Expression");
            br.addElement(loopInfo.getExpression());
            br.addItem("Specified SQL");
            br.addElement(loopInfo.getSpecifiedSql());
            String msg = br.buildExceptionMessage();
            throw new ForCommentParameterNullElementException(msg);
        }
    }
}

