/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.search;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.IntDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;

public class WordFreqValueSourceParser
extends ValueSourceParser {
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        String field = fp.parseArg();
        String word = fp.parseArg();
        boolean normalized = !"false".equals(fp.parseArg());
        return new WordFreqValueSource(field, word, normalized);
    }

    public static class WordFreqValueSource
    extends ValueSource {
        protected final String field;
        protected final String word;
        protected final boolean normalized;

        public WordFreqValueSource(String field, String word, boolean normalized) {
            this.field = field;
            this.word = normalized ? this.normalize(word) : word;
            this.normalized = normalized;
        }

        public String name() {
            return "wordfreq";
        }

        protected String normalize(String value) {
            return value.toLowerCase(Locale.getDefault());
        }

        public FunctionValues getValues(final Map context, AtomicReaderContext readerContext) throws IOException {
            return new IntDocValues(this){

                public int intVal(int docId) {
                    IndexSearcher searcher = (IndexSearcher)context.get("searcher");
                    HashSet<String> fieldSet = new HashSet<String>();
                    fieldSet.add(WordFreqValueSource.this.field);
                    try {
                        Document doc = searcher.doc(docId, fieldSet);
                        if (doc != null) {
                            String value = doc.get(WordFreqValueSource.this.field);
                            if (WordFreqValueSource.this.normalized) {
                                value = WordFreqValueSource.this.normalize(value);
                            }
                            return StringUtils.countMatches((String)value, (String)WordFreqValueSource.this.word);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return 0;
                }
            };
        }

        public boolean equals(Object o) {
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WordFreqValueSource other = (WordFreqValueSource)((Object)o);
            return this.field.equals(other.field) && this.word.equals(other.word) && this.normalized == other.normalized;
        }

        public int hashCode() {
            return (this.field + this.word).hashCode() + (this.normalized ? 1231 : 1237);
        }

        public String description() {
            return this.name() + '(' + this.field + ',' + this.word + ')';
        }
    }
}

