/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest.index;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.entity.SuggestItem;
import jp.sf.fess.suggest.io.AccessibleStringReader;
import jp.sf.fess.suggest.normalizer.SuggestNormalizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.DateUtil;

public class DocumentReader {
    private final List<String> targetFields;
    private int fieldPos = 0;
    private final List<String> targetLabelFields;
    private final List<String> targetRoleFields;
    private final SolrInputDocument solrInputDocument;
    private Tokenizer tokenizer;
    private final TokenizerFactory tokenizerFactory;
    private final SuggestReadingConverter suggestReadingConverter;
    private final SuggestNormalizer suggestNormalizer;
    private final String expiresField;
    private final String segmentField;
    private final String expire;
    private final String segment;
    private final Set<String> badWordSet;
    private boolean hasNext = true;

    public DocumentReader(TokenizerFactory tokenizerFactory, SuggestReadingConverter suggestReadingConverter, SuggestNormalizer suggestNormalizer, SolrInputDocument solrInputDocument, List<String> targetFields, List<String> targetLabelFields, List<String> targetRoleFields, String expiresField, String segmentField, Set<String> badWordSet) {
        this.solrInputDocument = solrInputDocument;
        this.targetFields = targetFields;
        this.targetLabelFields = targetLabelFields;
        this.targetRoleFields = targetRoleFields;
        this.tokenizerFactory = tokenizerFactory;
        this.expiresField = expiresField;
        this.segmentField = segmentField;
        this.suggestReadingConverter = suggestReadingConverter;
        this.suggestNormalizer = suggestNormalizer;
        this.badWordSet = badWordSet;
        Object expireObj = solrInputDocument.getFieldValue(expiresField);
        this.expire = expireObj != null ? expireObj.toString() : DateUtil.getThreadLocalDateFormat().format(new Date());
        Object segmentObj = solrInputDocument.getFieldValue(segmentField);
        this.segment = segmentObj != null ? segmentObj.toString() : "";
    }

    public SuggestItem next() throws IOException {
        if (this.tokenizerFactory == null) {
            String text = this.getNextFieldString();
            if (text == null) {
                return null;
            }
            SuggestItem item = this.createSuggestItem(text, this.targetFields.get(this.fieldPos));
            ++this.fieldPos;
            return item;
        }
        while (this.hasNext) {
            if (this.tokenizer != null) {
                while (this.tokenizer.incrementToken()) {
                    CharTermAttribute att = (CharTermAttribute)this.tokenizer.getAttribute(CharTermAttribute.class);
                    SuggestItem item = this.createSuggestItem(att.toString(), this.targetFields.get(this.fieldPos));
                    if (this.badWordSet.contains(item.getText())) continue;
                    return item;
                }
                this.tokenizer.close();
                this.tokenizer = null;
                ++this.fieldPos;
            }
            this.tokenizer = this.createTokenizer();
            if (this.tokenizer != null) continue;
            this.hasNext = false;
        }
        return null;
    }

    private SuggestItem createSuggestItem(String text, String fieldName) {
        SuggestItem item = new SuggestItem();
        item.setExpiresField(this.expiresField);
        item.setExpires(this.expire);
        item.setSegmentField(this.segmentField);
        item.setSegment(this.segment);
        List labels = item.getLabels();
        for (String label : this.targetLabelFields) {
            Collection valList;
            SolrInputField field = this.solrInputDocument.getField(label);
            if (field == null || (valList = field.getValues()) == null || valList.isEmpty()) continue;
            for (Object val : valList) {
                labels.add(val.toString());
            }
        }
        List roles = item.getRoles();
        for (String role : this.targetRoleFields) {
            Collection valList;
            SolrInputField field = this.solrInputDocument.getField(role);
            if (field == null || (valList = field.getValues()) == null || valList.isEmpty()) continue;
            for (Object val : valList) {
                roles.add(val.toString());
            }
        }
        item.addFieldName(fieldName);
        item.setText(text);
        if (this.suggestReadingConverter != null) {
            List readingList = this.suggestReadingConverter.convert(item.getText());
            for (String reading : readingList) {
                item.addReading(reading);
            }
        } else {
            item.addReading(text);
        }
        return item;
    }

    private Tokenizer createTokenizer() throws IOException {
        String nextFieldString = this.getNextFieldString();
        if (nextFieldString == null) {
            return null;
        }
        AccessibleStringReader rd = new AccessibleStringReader(nextFieldString);
        Tokenizer t = this.tokenizerFactory.create((Reader)rd);
        t.reset();
        return t;
    }

    private String getNextFieldString() {
        StringBuilder fieldValue = null;
        while (this.fieldPos < this.targetFields.size()) {
            Collection valList;
            String fieldName = this.targetFields.get(this.fieldPos);
            SolrInputField field = this.solrInputDocument.getField(fieldName);
            if (field != null && (valList = field.getValues()) != null && !valList.isEmpty()) {
                fieldValue = new StringBuilder(1000);
                for (Object val : valList) {
                    fieldValue.append(val.toString());
                    fieldValue.append(' ');
                }
                break;
            }
            ++this.fieldPos;
        }
        if (fieldValue == null) {
            return null;
        }
        String nextFieldString = fieldValue.toString();
        if (this.suggestNormalizer != null) {
            nextFieldString = this.suggestNormalizer.normalize(nextFieldString);
        }
        return nextFieldString;
    }
}

