/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.solr.plugin.suggest.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.fess.solr.plugin.suggest.SuggestUpdateConfig;
import jp.sf.fess.solr.plugin.suggest.entity.SuggestFieldInfo;
import jp.sf.fess.suggest.converter.SuggestIntegrateConverter;
import jp.sf.fess.suggest.converter.SuggestReadingConverter;
import jp.sf.fess.suggest.exception.FessSuggestException;
import jp.sf.fess.suggest.normalizer.SuggestIntegrateNormalizer;
import jp.sf.fess.suggest.normalizer.SuggestNormalizer;
import jp.sf.fess.suggest.util.SuggestUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.core.SolrConfig;
import org.codelibs.solr.lib.server.SolrLibHttpSolrServer;
import org.codelibs.solr.lib.server.interceptor.PreemptiveAuthInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SolrConfigUtil {
    private static final Logger logger = LoggerFactory.getLogger(SolrConfigUtil.class);
    private static final String USER_DICT_PATH = "userDictionary";
    private static final String USER_DICT_ENCODING = "userDictionaryEncoding";

    private SolrConfigUtil() {
    }

    public static SuggestUpdateConfig getUpdateHandlerConfig(SolrConfig config) {
        String updateInterval;
        String segmentField;
        String expiresField;
        String roleFields;
        String labelFields;
        SuggestUpdateConfig suggestUpdateConfig = new SuggestUpdateConfig();
        Node solrServerNode = config.getNode("updateHandler/suggest/solrServer", false);
        if (solrServerNode != null) {
            try {
                SolrServer solrServer;
                Node classNode = solrServerNode.getAttributes().getNamedItem("class");
                String className = classNode != null ? classNode.getTextContent() : "org.codelibs.solr.lib.server.SolrLibHttpSolrServer";
                Class<?> clazz = Class.forName(className);
                String arg = config.getVal("updateHandler/suggest/solrServer/arg", false);
                if (StringUtils.isNotBlank((String)arg)) {
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    solrServer = (SolrServer)constructor.newInstance(arg);
                } else {
                    solrServer = (SolrServer)clazz.newInstance();
                }
                String username = config.getVal("updateHandler/suggest/solrServer/credentials/username", false);
                String password = config.getVal("updateHandler/suggest/solrServer/credentials/password", false);
                if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password) && solrServer instanceof SolrLibHttpSolrServer) {
                    SolrLibHttpSolrServer solrLibHttpSolrServer = (SolrLibHttpSolrServer)solrServer;
                    URL u = new URL(arg);
                    AuthScope authScope = new AuthScope(u.getHost(), u.getPort());
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                    solrLibHttpSolrServer.setCredentials(authScope, (Credentials)credentials);
                    solrLibHttpSolrServer.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
                }
                NodeList childNodes = solrServerNode.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    String name;
                    Node node = childNodes.item(i);
                    if (node.getNodeType() != 1 || "arg".equals(name = node.getNodeName()) || "credentials".equals(name)) continue;
                    String value = node.getTextContent();
                    Node typeNode = node.getAttributes().getNamedItem("type");
                    Method method = clazz.getMethod("set" + name.substring(0, 1).toUpperCase() + name.substring(1), SolrConfigUtil.getMethodArgClass(typeNode));
                    method.invoke((Object)solrServer, SolrConfigUtil.getMethodArgValue(typeNode, value));
                }
                if (solrServer instanceof SolrLibHttpSolrServer) {
                    ((SolrLibHttpSolrServer)solrServer).init();
                }
                suggestUpdateConfig.setSolrServer(solrServer);
            }
            catch (Exception e) {
                throw new FessSuggestException("Failed to load SolrServer.", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)(labelFields = config.getVal("updateHandler/suggest/labelFields", false)))) {
            suggestUpdateConfig.setLabelFields(labelFields.trim().split(","));
        }
        if (StringUtils.isNotBlank((String)(roleFields = config.getVal("updateHandler/suggest/roleFields", false)))) {
            suggestUpdateConfig.setRoleFields(roleFields.trim().split(","));
        }
        if (StringUtils.isNotBlank((String)(expiresField = config.getVal("updateHandler/suggest/expiresField", false)))) {
            suggestUpdateConfig.setExpiresField(expiresField);
        }
        if (StringUtils.isNotBlank((String)(segmentField = config.getVal("updateHandler/suggest/segmentField", false)))) {
            suggestUpdateConfig.setSegmentField(segmentField);
        }
        if (StringUtils.isNotBlank((String)(updateInterval = config.getVal("updateHandler/suggest/updateInterval", false))) && StringUtils.isNumeric((String)updateInterval)) {
            suggestUpdateConfig.setUpdateInterval(Long.parseLong(updateInterval));
        }
        NodeList nodeList = config.getNodeList("updateHandler/suggest/suggestFieldInfo", true);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            try {
                SuggestUpdateConfig.FieldConfig fieldConfig = new SuggestUpdateConfig.FieldConfig();
                Node fieldInfoNode = nodeList.item(i);
                NamedNodeMap fieldInfoAttributes = fieldInfoNode.getAttributes();
                Node fieldNameNode = fieldInfoAttributes.getNamedItem("fieldName");
                String fieldName = fieldNameNode.getNodeValue();
                if (StringUtils.isBlank((String)fieldName)) continue;
                fieldConfig.setTargetFields(fieldName.trim().split(","));
                if (logger.isInfoEnabled()) {
                    for (String s : fieldConfig.getTargetFields()) {
                        logger.info("fieldName : " + s);
                    }
                }
                NodeList fieldInfoChilds = fieldInfoNode.getChildNodes();
                for (int j = 0; j < fieldInfoChilds.getLength(); ++j) {
                    String value;
                    String key;
                    Node attribute;
                    HashMap<String, String> properties;
                    String className;
                    Node fieldInfoChildNode = fieldInfoChilds.item(j);
                    String fieldInfoChildNodeName = fieldInfoChildNode.getNodeName();
                    if ("tokenizerFactory".equals(fieldInfoChildNodeName)) {
                        SuggestUpdateConfig.TokenizerConfig tokenizerConfig = new SuggestUpdateConfig.TokenizerConfig();
                        NamedNodeMap tokenizerFactoryAttributes = fieldInfoChildNode.getAttributes();
                        Node tokenizerClassNameNode = tokenizerFactoryAttributes.getNamedItem("class");
                        String tokenizerClassName = tokenizerClassNameNode.getNodeValue();
                        tokenizerConfig.setClassName(tokenizerClassName);
                        if (logger.isInfoEnabled()) {
                            logger.info("tokenizerFactory : " + tokenizerClassName);
                        }
                        HashMap<String, String> args = new HashMap<String, String>();
                        for (int k = 0; k < tokenizerFactoryAttributes.getLength(); ++k) {
                            Node attribute2 = tokenizerFactoryAttributes.item(k);
                            String key2 = attribute2.getNodeName();
                            String value2 = attribute2.getNodeValue();
                            if ("class".equals(key2)) continue;
                            args.put(key2, value2);
                        }
                        if (!args.containsKey(USER_DICT_PATH)) {
                            String userDictEncoding;
                            String userDictPath = System.getProperty("fess.user.dict.path", "");
                            if (StringUtils.isNotBlank((String)userDictPath)) {
                                args.put(USER_DICT_PATH, userDictPath);
                            }
                            if (StringUtils.isNotBlank((String)(userDictEncoding = System.getProperty("fess.user.dict.encoding", "")))) {
                                args.put(USER_DICT_ENCODING, userDictEncoding);
                            }
                        }
                        tokenizerConfig.setArgs(args);
                        fieldConfig.setTokenizerConfig(tokenizerConfig);
                        continue;
                    }
                    if ("suggestReadingConverter".equals(fieldInfoChildNodeName)) {
                        NodeList converterNodeList = fieldInfoChildNode.getChildNodes();
                        for (int k = 0; k < converterNodeList.getLength(); ++k) {
                            SuggestUpdateConfig.ConverterConfig converterConfig = new SuggestUpdateConfig.ConverterConfig();
                            Node converterNode = converterNodeList.item(k);
                            if (!"converter".equals(converterNode.getNodeName())) continue;
                            NamedNodeMap converterAttributes = converterNode.getAttributes();
                            Node classNameNode = converterAttributes.getNamedItem("class");
                            className = classNameNode.getNodeValue();
                            converterConfig.setClassName(className);
                            if (logger.isInfoEnabled()) {
                                logger.info("converter : " + className);
                            }
                            properties = new HashMap<String, String>();
                            for (int l = 0; l < converterAttributes.getLength(); ++l) {
                                attribute = converterAttributes.item(l);
                                key = attribute.getNodeName();
                                value = attribute.getNodeValue();
                                if ("class".equals(key)) continue;
                                properties.put(key, value);
                            }
                            converterConfig.setProperties(properties);
                            if (logger.isInfoEnabled()) {
                                logger.info("converter properties = " + properties);
                            }
                            fieldConfig.addConverterConfig(converterConfig);
                        }
                        continue;
                    }
                    if (!"suggestNormalizer".equals(fieldInfoChildNodeName)) continue;
                    NodeList normalizerNodeList = fieldInfoChildNode.getChildNodes();
                    for (int k = 0; k < normalizerNodeList.getLength(); ++k) {
                        SuggestUpdateConfig.NormalizerConfig normalizerConfig = new SuggestUpdateConfig.NormalizerConfig();
                        Node normalizerNode = normalizerNodeList.item(k);
                        if (!"normalizer".equals(normalizerNode.getNodeName())) continue;
                        NamedNodeMap normalizerAttributes = normalizerNode.getAttributes();
                        Node classNameNode = normalizerAttributes.getNamedItem("class");
                        className = classNameNode.getNodeValue();
                        normalizerConfig.setClassName(className);
                        if (logger.isInfoEnabled()) {
                            logger.info("normalizer : " + className);
                        }
                        properties = new HashMap();
                        for (int l = 0; l < normalizerAttributes.getLength(); ++l) {
                            attribute = normalizerAttributes.item(l);
                            key = attribute.getNodeName();
                            value = attribute.getNodeValue();
                            if ("class".equals(key)) continue;
                            properties.put(key, value);
                        }
                        normalizerConfig.setProperties(properties);
                        if (logger.isInfoEnabled()) {
                            logger.info("normalize properties = " + properties);
                        }
                        fieldConfig.addNormalizerConfig(normalizerConfig);
                    }
                }
                suggestUpdateConfig.addFieldConfig(fieldConfig);
                continue;
            }
            catch (Exception e) {
                throw new FessSuggestException("Failed to load Suggest Field Info.", (Throwable)e);
            }
        }
        return suggestUpdateConfig;
    }

    private static Object getMethodArgValue(Node typeNode, String value) {
        if (typeNode != null) {
            String type = typeNode.getTextContent();
            if ("Long".equals(type) || "long".equals(type)) {
                return Long.parseLong(value);
            }
            if ("Integer".equals(type) || "int".equals(type)) {
                return Integer.parseInt(value);
            }
        }
        return value;
    }

    private static Class<?> getMethodArgClass(Node typeNode) {
        if (typeNode != null) {
            String type = typeNode.getTextContent();
            if ("Long".equals(type)) {
                return Long.class;
            }
            if ("long".equals(type)) {
                return Long.TYPE;
            }
            if ("Integer".equals(type)) {
                return Integer.class;
            }
            if ("int".equals(type)) {
                return Integer.TYPE;
            }
        }
        return String.class;
    }

    public static List<SuggestFieldInfo> getSuggestFieldInfoList(SuggestUpdateConfig config) {
        ArrayList<SuggestFieldInfo> list = new ArrayList<SuggestFieldInfo>();
        for (SuggestUpdateConfig.FieldConfig fieldConfig : config.getFieldConfigList()) {
            try {
                List<String> fieldNameList = Arrays.asList(fieldConfig.getTargetFields());
                SuggestUpdateConfig.TokenizerConfig tokenizerConfig = fieldConfig.getTokenizerConfig();
                TokenizerFactory tokenizerFactory = null;
                if (tokenizerConfig != null) {
                    Class<?> cls = Class.forName(tokenizerConfig.getClassName());
                    Constructor<?> constructor = cls.getConstructor(Map.class);
                    tokenizerFactory = (TokenizerFactory)constructor.newInstance(tokenizerConfig.getArgs());
                    try {
                        Class[] params = new Class[]{ResourceLoader.class};
                        Method inform = cls.getDeclaredMethod("inform", params);
                        Object[] args = new Object[]{new FilesystemResourceLoader()};
                        inform.invoke((Object)tokenizerFactory, args);
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (Exception e) {
                        logger.warn("Failed to execute inform of tokenizer.", (Throwable)e);
                    }
                }
                SuggestIntegrateConverter suggestIntegrateConverter = new SuggestIntegrateConverter();
                for (SuggestUpdateConfig.ConverterConfig converterConfig : fieldConfig.getConverterConfigList()) {
                    SuggestReadingConverter suggestReadingConverter = SuggestUtil.createConverter((String)converterConfig.getClassName(), converterConfig.getProperties());
                    suggestIntegrateConverter.addConverter(suggestReadingConverter);
                }
                if (tokenizerFactory != null) {
                    suggestIntegrateConverter.setTokenizerFactory(tokenizerFactory);
                }
                suggestIntegrateConverter.start();
                SuggestIntegrateNormalizer suggestIntegrateNormalizer = new SuggestIntegrateNormalizer();
                for (SuggestUpdateConfig.NormalizerConfig normalizerConfig : fieldConfig.getNormalizerConfigList()) {
                    SuggestNormalizer suggestNormalizer = SuggestUtil.createNormalizer((String)normalizerConfig.getClassName(), normalizerConfig.getProperties());
                    suggestIntegrateNormalizer.addNormalizer(suggestNormalizer);
                }
                suggestIntegrateNormalizer.start();
                SuggestFieldInfo suggestFieldInfo = new SuggestFieldInfo(fieldNameList, tokenizerFactory, (SuggestReadingConverter)suggestIntegrateConverter, (SuggestNormalizer)suggestIntegrateNormalizer);
                list.add(suggestFieldInfo);
            }
            catch (Exception e) {
                throw new FessSuggestException("Failed to create Tokenizer." + fieldConfig.getTokenizerConfig().getClassName(), (Throwable)e);
            }
        }
        return list;
    }
}

