/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.stax.XMLStreamWriterDestination;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.value.UntypedAtomicValue;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.saxon.SaxonCommand;

public final class XSLTBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("xslt");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new XSLT(this, config, parent, child, context);
        }
        catch (SaxonApiException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
    }

    private static final class XSLT
    extends SaxonCommand {
        private final List<Fragment> fragments = new ArrayList<Fragment>();

        public XSLT(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws SaxonApiException, IOException, XMLStreamException {
            super(builder, config, parent, child, context);
            List fragmentConfigs = this.getConfigs().getConfigList(config, "fragments");
            if (fragmentConfigs.size() == 0) {
                throw new MorphlineCompilationException("At least one fragment must be defined", config);
            }
            if (fragmentConfigs.size() > 1) {
                throw new MorphlineCompilationException("More than one fragment is not yet supported", config);
            }
            for (Config fragment : fragmentConfigs) {
                String queryFile;
                String fragmentPath = this.getConfigs().getString(fragment, "fragmentPath");
                if (!fragmentPath.equals("/")) {
                    throw new MorphlineCompilationException("Non-root fragment paths are not yet supported", config);
                }
                XsltCompiler compiler = this.processor.newXsltCompiler();
                compiler.setErrorListener((ErrorListener)new SaxonCommand.DefaultErrorListener());
                compiler.setCompileWithTracing(this.isTracing);
                String version = this.getConfigs().getString(config, "languageVersion", null);
                if (version != null) {
                    compiler.setXsltLanguageVersion(version);
                }
                XsltExecutable executable = null;
                String query = this.getConfigs().getString(fragment, "queryString", null);
                if (query != null) {
                    executable = compiler.compile((Source)new StreamSource(new StringReader(query)));
                }
                if ((queryFile = this.getConfigs().getString(fragment, "queryFile", null)) != null) {
                    executable = compiler.compile((Source)new StreamSource(new File(queryFile)));
                }
                if (query == null && queryFile == null) {
                    throw new MorphlineCompilationException("Either query or queryFile must be defined", config);
                }
                if (query != null && queryFile != null) {
                    throw new MorphlineCompilationException("Must not define both query and queryFile at the same time", config);
                }
                XsltTransformer evaluator = executable.load();
                Config variables = this.getConfigs().getConfig(fragment, "parameters", ConfigFactory.empty());
                for (Map.Entry entry : new Configs().getEntrySet(variables)) {
                    XdmValue xdmValue = XdmNode.wrap((Sequence)new UntypedAtomicValue((CharSequence)entry.getValue().toString()));
                    evaluator.setParameter(new QName((String)entry.getKey()), xdmValue);
                }
                Config fileVariables = this.getConfigs().getConfig(fragment, "fileParameters", ConfigFactory.empty());
                for (Map.Entry entry : new Configs().getEntrySet(fileVariables)) {
                    File file = new File(entry.getValue().toString());
                    XdmNode doc = this.parseXmlDocument(file);
                    evaluator.setParameter(new QName((String)entry.getKey()), (XdmValue)doc);
                }
                if (this.isTracing) {
                    evaluator.setTraceListener((TraceListener)new XQueryTraceListener());
                }
                this.fragments.add(new Fragment(fragmentPath, evaluator));
            }
            this.validateArguments();
        }

        @Override
        protected boolean doProcess2(Record inputRecord, InputStream stream) throws SaxonApiException, XMLStreamException {
            this.incrementNumRecords();
            for (Fragment fragment : this.fragments) {
                Record outputRecord = inputRecord.copy();
                XSLT.removeAttachments((Record)outputRecord);
                XdmNode document = this.parseXmlDocument(stream);
                this.LOG.trace("XSLT input document: {}", (Object)document);
                XsltTransformer evaluator = fragment.transformer;
                evaluator.setInitialContextNode(document);
                MorphlineXMLStreamWriter morphlineWriter = new MorphlineXMLStreamWriter(this.getChild(), outputRecord);
                evaluator.setDestination((Destination)new XMLStreamWriterDestination((XMLStreamWriter)morphlineWriter));
                evaluator.transform();
            }
            return true;
        }

        private static final class MorphlineXMLStreamWriter
        implements XMLStreamWriter {
            private final Command child;
            private final Record template;
            private Record record;
            private int depth = 0;
            private String fieldName;
            private final StringBuilder stringValue = new StringBuilder();
            private boolean isEmpty = true;
            private NamespaceContext rootContext;
            private final Map properties = null;

            public MorphlineXMLStreamWriter(Command child, Record template) {
                this.child = child;
                this.template = template;
                this.record = template.copy();
            }

            @Override
            public void close() throws XMLStreamException {
            }

            @Override
            public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                Preconditions.checkNotNull((Object)localName);
                if (this.depth == 1) {
                    this.fieldName = localName;
                }
                ++this.depth;
            }

            @Override
            public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
                if (this.depth <= 1) {
                    if (value == null) {
                        value = "";
                    }
                    if (value.length() > 0) {
                        this.put(localName, value);
                    }
                }
            }

            @Override
            public void writeEndElement() throws XMLStreamException {
                if (this.inPrologOrEpilog()) {
                    throw new XMLStreamException("Imbalanced element tags; attempted to write an end tag for a nonexistent start tag");
                }
                --this.depth;
                if (this.depth == 1) {
                    Preconditions.checkNotNull((Object)this.fieldName);
                    if (this.stringValue.length() > 0) {
                        this.put(this.fieldName, this.stringValue.toString());
                        this.stringValue.setLength(0);
                    }
                    this.fieldName = null;
                }
                if (this.inPrologOrEpilog()) {
                    if (!this.isEmpty) {
                        this.child.process(this.record);
                    }
                    this.isEmpty = true;
                    this.record = this.template.copy();
                }
            }

            private void put(String key, String value) {
                this.record.put(key, (Object)value);
                this.isEmpty = false;
            }

            @Override
            public void writeCharacters(String text) throws XMLStreamException {
                if (this.depth > 1) {
                    this.stringValue.append(text);
                }
            }

            private boolean inPrologOrEpilog() {
                return this.depth == 0;
            }

            @Override
            public Object getProperty(String name) throws IllegalArgumentException {
                if (name == null) {
                    throw new IllegalArgumentException("Property name must not be null");
                }
                if (!this.properties.containsKey(name)) {
                    throw new IllegalArgumentException("Unsupported property: " + name);
                }
                return this.properties.get(name);
            }

            @Override
            public NamespaceContext getNamespaceContext() {
                return this.rootContext;
            }

            @Override
            public void setNamespaceContext(NamespaceContext rootContext) throws XMLStreamException {
                this.rootContext = rootContext;
            }

            @Override
            public void setDefaultNamespace(String uri) throws XMLStreamException {
            }

            @Override
            public void setPrefix(String prefix, String uri) throws XMLStreamException {
            }

            @Override
            public String getPrefix(String uri) throws XMLStreamException {
                throw new UnsupportedOperationException("unreachable");
            }

            @Override
            public void writeStartDocument() throws XMLStreamException {
                this.writeStartDocument("1.0");
            }

            @Override
            public void writeStartDocument(String version) throws XMLStreamException {
                this.writeStartDocument("UTF-8", version);
            }

            @Override
            public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            }

            @Override
            public void writeStartElement(String localName) throws XMLStreamException {
                String defaultNamespaceURI = "";
                String prefix = "";
                this.writeStartElement(prefix, localName, defaultNamespaceURI);
            }

            @Override
            public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
                String prefix = "";
                this.writeStartElement(prefix, localName, namespaceURI);
            }

            @Override
            public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
                this.writeNamespace("", namespaceURI);
            }

            @Override
            public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            }

            @Override
            public void writeAttribute(String localName, String value) throws XMLStreamException {
                this.writeAttribute("", "", localName, value);
            }

            @Override
            public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
                String prefix = "";
                this.writeAttribute(prefix, namespaceURI, localName, value);
            }

            @Override
            public void writeEndDocument() throws XMLStreamException {
            }

            @Override
            public void flush() throws XMLStreamException {
            }

            @Override
            public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
                this.writeCharacters(new String(text, start, len));
            }

            @Override
            public void writeCData(String data) throws XMLStreamException {
                this.writeCharacters(data);
            }

            @Override
            public void writeEntityRef(String name) throws XMLStreamException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeDTD(String dtd) throws XMLStreamException {
            }

            @Override
            public void writeProcessingInstruction(String target) throws XMLStreamException {
                this.writeProcessingInstruction(target, "");
            }

            @Override
            public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            }

            @Override
            public void writeComment(String data) throws XMLStreamException {
            }

            @Override
            public void writeEmptyElement(String localName) throws XMLStreamException {
                this.writeStartElement(localName);
                this.writeEndElement();
            }

            @Override
            public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
                this.writeStartElement(namespaceURI, localName);
                this.writeEndElement();
            }

            @Override
            public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
                this.writeStartElement(prefix, localName, namespaceURI);
                this.writeEndElement();
            }
        }

        private static final class Fragment {
            private final String fragmentPath;
            private final XsltTransformer transformer;

            public Fragment(String fragmentPath, XsltTransformer transformer) {
                this.fragmentPath = fragmentPath;
                this.transformer = transformer;
            }
        }
    }
}

