/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.WeakHashMap;
import morfologik.fsa.FSA;
import morfologik.stemming.DictionaryAttribute;
import morfologik.stemming.DictionaryMetadata;
import morfologik.util.FileUtils;
import morfologik.util.ResourceUtils;

public final class Dictionary {
    public static final String METADATA_FILE_EXTENSION = "info";
    public final FSA fsa;
    public final DictionaryMetadata metadata;
    public static final WeakHashMap<String, Dictionary> defaultDictionaries = new WeakHashMap();

    public Dictionary(FSA fsa, DictionaryMetadata metadata) {
        this.fsa = fsa;
        this.metadata = metadata;
    }

    public static Dictionary read(File fsaFile) throws IOException {
        File featuresFile = new File(fsaFile.getParent(), Dictionary.getExpectedFeaturesName(fsaFile.getName()));
        FileUtils.assertExists(featuresFile, true, false);
        return Dictionary.readAndClose(new FileInputStream(fsaFile), new FileInputStream(featuresFile));
    }

    public static Dictionary read(URL fsaURL) throws IOException {
        String fsa = fsaURL.toExternalForm();
        String features = Dictionary.getExpectedFeaturesName(fsa);
        return Dictionary.readAndClose(ResourceUtils.openInputStream(fsa), ResourceUtils.openInputStream(features));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dictionary readAndClose(InputStream fsaData, InputStream featuresData) throws IOException {
        Dictionary dictionary;
        try {
            Properties properties = new Properties();
            properties.load(new InputStreamReader(featuresData, "UTF-8"));
            HashMap<DictionaryAttribute, String> map = new HashMap<DictionaryAttribute, String>();
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(DictionaryAttribute.fromPropertyName(key), properties.getProperty(key));
            }
            DictionaryMetadata features = new DictionaryMetadata(map);
            Object fsa = FSA.read(fsaData);
            dictionary = new Dictionary((FSA)fsa, features);
        }
        catch (Throwable throwable) {
            FileUtils.close(fsaData, featuresData);
            throw throwable;
        }
        FileUtils.close(fsaData, featuresData);
        return dictionary;
    }

    public static String getExpectedFeaturesName(String name) {
        int dotIndex = name.lastIndexOf(46);
        String featuresName = dotIndex >= 0 ? name.substring(0, dotIndex) + "." + METADATA_FILE_EXTENSION : name + "." + METADATA_FILE_EXTENSION;
        return featuresName;
    }

    public static Dictionary getForLanguage(String languageCode) {
        if (languageCode == null || "".equals(languageCode)) {
            throw new IllegalArgumentException("Language code must not be empty.");
        }
        WeakHashMap<String, Dictionary> weakHashMap = defaultDictionaries;
        synchronized (weakHashMap) {
            Dictionary dict = defaultDictionaries.get(languageCode);
            if (dict != null) {
                return dict;
            }
            try {
                String dictPath = "morfologik/dictionaries/" + languageCode + ".dict";
                String metaPath = Dictionary.getExpectedFeaturesName(dictPath);
                dict = Dictionary.readAndClose(ResourceUtils.openInputStream(dictPath), ResourceUtils.openInputStream(metaPath));
                defaultDictionaries.put(languageCode, dict);
                return dict;
            }
            catch (IOException e) {
                throw new RuntimeException("Default dictionary resource for language '" + languageCode + "not found.", e);
            }
        }
    }
}

