/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dbflute.CallbackContext;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.SqlStringFilter;
import org.seasar.dbflute.bhv.core.BehaviorCommand;
import org.seasar.dbflute.bhv.core.execution.AbstractFixedArgExecution;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicParameterHandler;
import org.seasar.dbflute.s2dao.sqlhandler.TnBasicSelectHandler;
import org.seasar.dbflute.twowaysql.node.Node;

public class SelectCBExecution
extends AbstractFixedArgExecution {
    protected final TnResultSetHandler _resultSetHandler;

    public SelectCBExecution(DataSource dataSource, StatementFactory statementFactory, Map<String, Class<?>> argNameTypeMap, TnResultSetHandler resultSetHandler) {
        super(dataSource, statementFactory, argNameTypeMap);
        this.assertObjectNotNull("resultSetHandler", resultSetHandler);
        this._resultSetHandler = resultSetHandler;
    }

    @Override
    public Object execute(Object[] args) {
        ConditionBean cb = this.extractConditionBean(args);
        Object splitResult = this.processPagingSelectAndQuerySplit(args, cb);
        if (splitResult != null) {
            return splitResult;
        }
        return this.superExecute(args);
    }

    protected Object superExecute(Object[] args) {
        return super.execute(args);
    }

    @Override
    protected Node getRootNode(Object[] args) {
        return this.analyzeTwoWaySql(this.extractTwoWaySql(args));
    }

    protected String extractTwoWaySql(Object[] args) {
        ConditionBean cb = this.extractConditionBean(args);
        return cb.getSqlClause().getClause();
    }

    protected ConditionBean extractConditionBean(Object[] args) {
        this.assertArgsValid(args);
        Object firstElement = args[0];
        this.assertObjectNotNull("args[0]", firstElement);
        this.assertFirstElementConditionBean(firstElement);
        ConditionBean cb = (ConditionBean)firstElement;
        return cb;
    }

    protected void assertArgsValid(Object[] args) {
        if (args == null) {
            String msg = "The argument 'args' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (args.length == 0) {
            String msg = "The argument 'args' should not be empty.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertFirstElementConditionBean(Object firstElement) {
        if (!(firstElement instanceof ConditionBean)) {
            String msg = "The first element of 'args' should be condition-bean: " + firstElement.getClass();
            throw new IllegalArgumentException(msg);
        }
    }

    protected Object processPagingSelectAndQuerySplit(Object[] args, ConditionBean cb) {
        if (!cb.canPagingSelectAndQuerySplit()) {
            return null;
        }
        if (!cb.isFetchScopeEffective()) {
            return null;
        }
        DBMeta dbmeta = cb.getDBMeta();
        UniqueInfo primaryUniqueInfo = dbmeta.getPrimaryUniqueInfo();
        if (primaryUniqueInfo.isTwoOrMore()) {
            return null;
        }
        ColumnInfo pkColumn = primaryUniqueInfo.getFirstColumn();
        SqlClause sqlClause = cb.getSqlClause();
        List<Object> pkList = this.doSplitSelectFirst(args, cb, dbmeta, sqlClause);
        if (pkList == null) {
            return null;
        }
        if (pkList.isEmpty()) {
            return pkList;
        }
        return this.doSplitSelectSecond(args, cb, pkColumn, sqlClause, pkList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> doSplitSelectFirst(Object[] args, ConditionBean cb, DBMeta dbmeta, SqlClause sqlClause) {
        ArrayList<Object> pkList = new ArrayList<Object>();
        try {
            sqlClause.enablePKOnlySelectForcedly();
            Object firstResult = this.superExecute(args);
            if (firstResult == null || !(firstResult instanceof List)) {
                List<Object> list = null;
                return list;
            }
            List entityList = (List)firstResult;
            for (Entity entity : entityList) {
                Map<String, Object> primaryKeyMap = dbmeta.extractPrimaryKeyMap(entity);
                pkList.add(primaryKeyMap.values().iterator().next());
            }
            ArrayList<Object> arrayList = pkList;
            return arrayList;
        }
        finally {
            sqlClause.disablePKOnlySelectForcedly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doSplitSelectSecond(Object[] args, ConditionBean cb, ColumnInfo pkColumn, SqlClause sqlClause, List<Object> pkList) {
        int fetchSize = sqlClause.getFetchSize();
        int fetchPageNumber = sqlClause.getFetchPageNumber();
        try {
            sqlClause.backupWhereClauseOnBaseQuery();
            sqlClause.clearWhereClauseOnBaseQuery();
            sqlClause.suppressFetchScope();
            String ckey = ConditionKey.CK_IN_SCOPE.getConditionKey();
            cb.localCQ().invokeQuery(pkColumn.getColumnDbName(), ckey, pkList);
            Object object = this.superExecute(args);
            return object;
        }
        finally {
            sqlClause.restoreWhereClauseOnBaseQuery();
            sqlClause.fetchFirst(fetchSize);
            sqlClause.fetchPage(fetchPageNumber);
        }
    }

    @Override
    protected TnBasicParameterHandler newBasicParameterHandler(String executedSql) {
        return new TnBasicSelectHandler(this._dataSource, executedSql, this._resultSetHandler, this._statementFactory);
    }

    @Override
    protected String filterExecutedSql(String executedSql) {
        return this.doFilterExecutedSqlByCallbackFilter(super.filterExecutedSql(executedSql));
    }

    protected String doFilterExecutedSqlByCallbackFilter(String executedSql) {
        SqlStringFilter sqlStringFilter = this.getSqlStringFilter();
        if (sqlStringFilter != null) {
            BehaviorCommand<?> meta = ResourceContext.behaviorCommand();
            String filteredSql = sqlStringFilter.filterSelectCB(meta, executedSql);
            return filteredSql != null ? filteredSql : executedSql;
        }
        return executedSql;
    }

    protected SqlStringFilter getSqlStringFilter() {
        if (!CallbackContext.isExistSqlStringFilterOnThread()) {
            return null;
        }
        return CallbackContext.getCallbackContextOnThread().getSqlStringFilter();
    }

    @Override
    protected boolean isBlockNullParameter() {
        return true;
    }
}

