/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import java.util.ArrayList;
import java.util.Date;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SubQuery;
import org.seasar.dbflute.cbean.chelper.HpQDRSetupper;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.DerivedReferrerOption;
import org.seasar.dbflute.cbean.coption.FromToOption;

public class HpQDRParameter<CB extends ConditionBean, PARAMETER> {
    protected final String _function;
    protected final SubQuery<CB> _subQuery;
    protected final DerivedReferrerOption _option;
    protected final HpQDRSetupper<CB> _setupper;

    public HpQDRParameter(String function, SubQuery<CB> subQuery, DerivedReferrerOption option, HpQDRSetupper<CB> setupper) {
        this._function = function;
        this._subQuery = subQuery;
        this._option = option;
        this._setupper = setupper;
    }

    public void equal(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_EQUAL.getOperand(), value, this._option);
    }

    public void notEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_NOT_EQUAL_STANDARD.getOperand(), value, this._option);
    }

    public void greaterThan(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_GREATER_THAN.getOperand(), value, this._option);
    }

    public void lessThan(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_LESS_THAN.getOperand(), value, this._option);
    }

    public void greaterEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_GREATER_EQUAL.getOperand(), value, this._option);
    }

    public void lessEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_LESS_EQUAL.getOperand(), value, this._option);
    }

    public void isNull() {
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_IS_NULL.getOperand(), null, this._option);
    }

    public void isNotNull() {
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_IS_NOT_NULL.getOperand(), null, this._option);
    }

    public void between(PARAMETER fromValue, PARAMETER toValue) {
        this.doBetween(fromValue, toValue);
    }

    public void rangeOf(Number fromNumber, Number toNumber) {
        if (fromNumber == null && toNumber == null) {
            return;
        }
        Number fromValue = fromNumber;
        Number toValue = toNumber;
        this.dispatchFromTo(fromValue, toValue);
    }

    public void dateFromTo(Date fromDate, Date toDate) {
        this.doFromTo(fromDate, toDate, new FromToOption().compareAsDate());
    }

    public void fromTo(Date fromDate, Date toDate, FromToOption option) {
        this.doFromTo(fromDate, toDate, option);
    }

    protected void doFromTo(Date fromDate, Date toDate, FromToOption option) {
        if (option == null) {
            String msg = "The argument 'option' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (fromDate == null && toDate == null) {
            return;
        }
        if (fromDate != null) {
            fromDate = option.filterFromDate(fromDate);
        }
        if (toDate != null) {
            toDate = option.xfilterToDateBetweenWay(toDate);
        }
        Date fromValue = fromDate;
        Date toValue = toDate;
        this.dispatchFromTo(fromValue, toValue);
    }

    protected void dispatchFromTo(PARAMETER fromValue, PARAMETER toValue) {
        if (fromValue != null && toValue != null) {
            this.doBetween(fromValue, toValue);
        } else if (fromValue != null) {
            this.greaterEqual(fromValue);
        } else if (toValue != null) {
            this.lessEqual(toValue);
        }
    }

    protected void doBetween(PARAMETER fromValue, PARAMETER toValue) {
        this.assertParameterFromNotNull(fromValue);
        this.assertParameterToNotNull(toValue);
        ArrayList<PARAMETER> fromToValueList = new ArrayList<PARAMETER>(2);
        fromToValueList.add(fromValue);
        fromToValueList.add(toValue);
        this._setupper.setup(this._function, this._subQuery, "between", fromToValueList, this._option);
    }

    protected void assertParameterNotNull(Object value) {
        if (value == null) {
            String msg = "The argument 'value' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertParameterFromNotNull(Object fromValue) {
        if (fromValue == null) {
            String msg = "The argument 'fromValue' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertParameterToNotNull(Object toValue) {
        if (toValue == null) {
            String msg = "The argument 'toValue' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    public static boolean isOperandIsNull(String operand) {
        return ConditionKey.CK_IS_NULL.getOperand().equals(operand);
    }
}

