/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.chelper;

import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ScalarQuery;
import org.seasar.dbflute.cbean.chelper.HpSLSExecutor;
import org.seasar.dbflute.cbean.coption.ScalarSelectOption;
import org.seasar.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.dbflute.cbean.sqlclause.clause.SelectClauseType;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.thrower.ConditionBeanExceptionThrower;

public class HpSLSFunction<CB extends ConditionBean, RESULT> {
    protected final CB _conditionBean;
    protected final Class<RESULT> _resultType;
    protected final HpSLSExecutor<CB, RESULT> _executor;

    public HpSLSFunction(CB conditionBean, Class<RESULT> resultType, HpSLSExecutor<CB, RESULT> executor) {
        this._conditionBean = conditionBean;
        this._resultType = resultType;
        this._executor = executor;
    }

    public RESULT count(ScalarQuery<CB> scalarQuery) {
        return this.doCount(scalarQuery, null);
    }

    public RESULT count(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarSelectOption(option);
        return this.doCount(scalarQuery, option);
    }

    protected RESULT doCount(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.UNIQUE_COUNT, option);
    }

    public RESULT countDistinct(ScalarQuery<CB> scalarQuery) {
        return this.doCountDistinct(scalarQuery, null);
    }

    public RESULT countDistinct(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarSelectOption(option);
        return this.doCountDistinct(scalarQuery, option);
    }

    protected RESULT doCountDistinct(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.COUNT_DISTINCT, option);
    }

    public RESULT max(ScalarQuery<CB> scalarQuery) {
        return this.doMax(scalarQuery, null);
    }

    public RESULT max(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarSelectOption(option);
        return this.doMax(scalarQuery, option);
    }

    protected RESULT doMax(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.MAX, option);
    }

    public RESULT min(ScalarQuery<CB> scalarQuery) {
        return this.doMin(scalarQuery, null);
    }

    public RESULT min(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarSelectOption(option);
        return this.doMin(scalarQuery, option);
    }

    protected RESULT doMin(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.MIN, option);
    }

    public RESULT sum(ScalarQuery<CB> scalarQuery) {
        return this.doSum(scalarQuery, null);
    }

    public RESULT sum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarSelectOption(option);
        return this.doSum(scalarQuery, option);
    }

    protected RESULT doSum(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.SUM, option);
    }

    public RESULT avg(ScalarQuery<CB> scalarQuery) {
        return this.doAvg(scalarQuery, null);
    }

    public RESULT avg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarSelectOption(option);
        return this.doAvg(scalarQuery, option);
    }

    protected RESULT doAvg(ScalarQuery<CB> scalarQuery, ScalarSelectOption option) {
        this.assertScalarQuery(scalarQuery);
        return this.exec(scalarQuery, SelectClauseType.AVG, option);
    }

    protected RESULT exec(ScalarQuery<CB> scalarQuery, SelectClauseType selectClauseType, ScalarSelectOption option) {
        this.assertObjectNotNull("scalarQuery", scalarQuery);
        this.assertObjectNotNull("selectClauseType", (Object)selectClauseType);
        this.assertObjectNotNull("conditionBean", this._conditionBean);
        this.assertObjectNotNull("resultType", this._resultType);
        scalarQuery.query(this._conditionBean);
        this.setupTargetColumnInfo(option);
        this.setupScalarSelectOption(option);
        this.assertScalarSelectRequiredSpecifyColumn();
        return this._executor.execute(this._conditionBean, this._resultType, selectClauseType);
    }

    protected void setupTargetColumnInfo(ScalarSelectOption option) {
        if (option == null) {
            return;
        }
        SqlClause sqlClause = this._conditionBean.getSqlClause();
        ColumnInfo columnInfo = sqlClause.getSpecifiedColumnInfoAsOne();
        if (columnInfo != null) {
            columnInfo = sqlClause.getSpecifiedDerivingColumnInfoAsOne();
        }
        option.xsetTargetColumnInfo(columnInfo);
    }

    protected void setupScalarSelectOption(ScalarSelectOption option) {
        if (option != null) {
            this._conditionBean.xacceptScalarSelectOption(option);
            this._conditionBean.localCQ().xregisterParameterOption(option);
        }
    }

    protected void assertScalarSelectRequiredSpecifyColumn() {
        SqlClause sqlClause = this._conditionBean.getSqlClause();
        String columnName = sqlClause.getSpecifiedColumnDbNameAsOne();
        String subQuery = sqlClause.getSpecifiedDerivingSubQueryAsOne();
        if (columnName != null && subQuery != null || columnName == null && subQuery == null) {
            this.throwScalarSelectInvalidColumnSpecificationException();
        }
    }

    protected void throwScalarSelectInvalidColumnSpecificationException() {
        this.createCBExThrower().throwScalarSelectInvalidColumnSpecificationException((ConditionBean)this._conditionBean, this._resultType);
    }

    protected ConditionBeanExceptionThrower createCBExThrower() {
        return new ConditionBeanExceptionThrower();
    }

    protected void assertScalarQuery(ScalarQuery<?> scalarQuery) {
        if (scalarQuery == null) {
            String msg = "The argument 'scalarQuery' for ScalarSelect should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertScalarSelectOption(ScalarSelectOption option) {
        if (option == null) {
            String msg = "The argument 'option' for ScalarSelect should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }
}

