/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.sqlclause.orderby;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.ManualOrderBean;
import org.seasar.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.dbflute.cbean.chelper.HpMobCaseWhenElement;
import org.seasar.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.seasar.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.sqlclause.orderby.OrderByClause;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.util.DfTypeUtil;

public class OrderByElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String _aliasName;
    protected final String _columnName;
    protected final transient ColumnInfo _columnInfo;
    protected final boolean _derivedOrderBy;
    protected String _ascDesc = "asc";
    protected transient GearedCipherManager _gearedCipherManager;
    protected transient OrderByClause.OrderByNullsSetupper _orderByNullsSetupper;
    protected boolean _nullsFirst;
    protected transient ManualOrderBean _mob;

    public OrderByElement(String aliasName, String columnName, ColumnInfo columnInfo, boolean derivedOrderBy) {
        this.assertColumnName(aliasName, columnName);
        this.assertColumnInfo(aliasName, columnInfo);
        this._aliasName = aliasName;
        this._columnName = columnName;
        this._columnInfo = columnInfo;
        this._derivedOrderBy = derivedOrderBy;
    }

    protected void assertColumnName(String aliasName, String columnName) {
        if (columnName == null) {
            String msg = "The argument 'columnName' should not be null: aliasName=" + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertColumnInfo(String aliasName, ColumnInfo columnInfo) {
        if (columnInfo == null) {
            String msg = "The argument 'columnInfo' should not be null: aliasName=" + aliasName;
            throw new IllegalArgumentException(msg);
        }
    }

    public void setupAsc() {
        this._ascDesc = "asc";
    }

    public void setupDesc() {
        this._ascDesc = "desc";
    }

    public void reverse() {
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._ascDesc.equals("asc")) {
            this._ascDesc = "desc";
        } else if (this._ascDesc.equals("desc")) {
            this._ascDesc = "asc";
        } else {
            String msg = "The attribute[ascDesc] should be asc or desc: but ascDesc=" + this._ascDesc;
            throw new IllegalStateException(msg);
        }
    }

    public String getElementClause() {
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        StringBuilder sb = new StringBuilder();
        String columnFullName = this.getColumnFullName();
        if (this._mob != null && this._mob.hasManualOrder()) {
            this.setupManualOrderClause(sb, columnFullName, null);
            return sb.toString();
        }
        sb.append(this.decryptIfNeeds(this._columnInfo, columnFullName)).append(" ").append(this._ascDesc);
        String clause = sb.toString();
        if (this._orderByNullsSetupper != null) {
            return this._orderByNullsSetupper.setup(columnFullName, clause, this._nullsFirst);
        }
        return clause;
    }

    public String getElementClause(Map<String, String> selectClauseRealColumnAliasMap) {
        if (selectClauseRealColumnAliasMap == null) {
            String msg = "The argument 'selectClauseRealColumnAliasMap' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (this._ascDesc == null) {
            String msg = "The attribute 'ascDesc' should not be null.";
            throw new IllegalStateException(msg);
        }
        String columnAlias = this.mappingToRealColumnAlias(selectClauseRealColumnAliasMap, this.getColumnFullName());
        StringBuilder sb = new StringBuilder();
        if (this._mob != null && this._mob.hasManualOrder()) {
            this.setupManualOrderClause(sb, columnAlias, selectClauseRealColumnAliasMap);
            return sb.toString();
        }
        sb.append(columnAlias).append(" ").append(this._ascDesc);
        if (this._orderByNullsSetupper != null) {
            return this._orderByNullsSetupper.setup(columnAlias, sb.toString(), this._nullsFirst);
        }
        return sb.toString();
    }

    protected String mappingToRealColumnAlias(Map<String, String> selectClauseRealColumnAliasMap, String columnFullName) {
        String columnAlias = selectClauseRealColumnAliasMap.get(columnFullName);
        if (columnAlias == null || columnAlias.trim().length() == 0) {
            this.throwOrderByColumnNotFoundException(this.getColumnFullName(), selectClauseRealColumnAliasMap);
        }
        return columnAlias;
    }

    protected void setupManualOrderClause(StringBuilder sb, String columnAlias, Map<String, String> selectClauseRealColumnAliasMap) {
        String realAlias;
        if (this._mob.hasOrderByCalculation()) {
            HpCalcSpecification<ConditionBean> calculationOrder = this._mob.getOrderByCalculation();
            realAlias = calculationOrder.buildStatementToSpecifidName(columnAlias, selectClauseRealColumnAliasMap);
        } else {
            realAlias = selectClauseRealColumnAliasMap != null ? columnAlias : this.decryptIfNeeds(this._columnInfo, columnAlias);
        }
        List<HpMobCaseWhenElement> caseWhenList = this._mob.getCaseWhenBoundList();
        if (!caseWhenList.isEmpty()) {
            sb.append(this.ln()).append("   case").append(this.ln());
            int index = 0;
            for (HpMobCaseWhenElement element : caseWhenList) {
                sb.append("     when ");
                this.doSetupManualOrderClause(sb, realAlias, element);
                List<HpMobCaseWhenElement> connectedElementList = element.getConnectedElementList();
                for (HpMobCaseWhenElement connectedElement : connectedElementList) {
                    this.doSetupManualOrderClause(sb, realAlias, connectedElement);
                }
                Object thenValue = element.getThenValue();
                String thenExp = thenValue != null ? thenValue.toString() : String.valueOf(index);
                sb.append(" then ").append(thenExp).append(this.ln());
                ++index;
            }
            Object elseValue = this._mob.getElseValue();
            String elseExp = elseValue != null ? elseValue.toString() : String.valueOf(index);
            sb.append("     else ").append(elseExp).append(this.ln());
            sb.append("   end");
        } else {
            sb.append(realAlias);
        }
        sb.append(" ").append(this._ascDesc);
    }

    protected void doSetupManualOrderClause(StringBuilder sb, String columnAlias, HpMobCaseWhenElement element) {
        ConditionKey conditionKey = element.getConditionKey();
        String keyExp = conditionKey.getOperand();
        String connector = element.toConnector();
        if (connector != null) {
            sb.append(" ").append(connector).append(" ");
        }
        if (this.isManualOrderConditionKeyNullHandling(conditionKey)) {
            sb.append(columnAlias).append(" ").append(keyExp);
        } else {
            Object bindExp = element.getOrderValue();
            sb.append(columnAlias).append(" ").append(keyExp).append(" ").append(bindExp);
        }
    }

    protected boolean isManualOrderConditionKeyNullHandling(ConditionKey conditionKey) {
        return conditionKey.equals(ConditionKey.CK_IS_NULL) || conditionKey.equals(ConditionKey.CK_IS_NOT_NULL);
    }

    protected void throwOrderByColumnNotFoundException(String columnName, Map<String, String> selectClauseRealColumnAliasMap) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "The column for order-by was not found in select-clause!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "If you use 'union()' or 'unionAll()', check your condition-bean!" + this.ln();
        msg = msg + "You can use only order-by columns on select-clause if union." + this.ln();
        msg = msg + "For example:" + this.ln();
        msg = msg + "  (x):" + this.ln();
        msg = msg + "    AaaCB cb = new AaaCB();" + this.ln();
        msg = msg + "    cb.query().setXxx...();" + this.ln();
        msg = msg + "    cb.union(new UnionQuery<AaaCB>() {" + this.ln();
        msg = msg + "        public void query(AaaCB unionCB) {" + this.ln();
        msg = msg + "            unionCB.query().setXxx...();" + this.ln();
        msg = msg + "        }" + this.ln();
        msg = msg + "    }" + this.ln();
        msg = msg + "    cb.query().queryBbb().addOrderBy_BbbName_Asc();// *NG!" + this.ln();
        msg = msg + "    " + this.ln();
        msg = msg + "  (o):" + this.ln();
        msg = msg + "    AaaCB cb = new AaaCB();" + this.ln();
        msg = msg + "    cb.setupSelect_Bbb();// *Point!" + this.ln();
        msg = msg + "    cb.query().setXxx...();" + this.ln();
        msg = msg + "    cb.union(new UnionQuery<AaaCB>() {" + this.ln();
        msg = msg + "        public void query(AaaCB unionCB) {" + this.ln();
        msg = msg + "            unionCB.query().setXxx...();" + this.ln();
        msg = msg + "        }" + this.ln();
        msg = msg + "    }" + this.ln();
        msg = msg + "    cb.query().queryBbb().addOrderBy_BbbName_Asc();// *OK!" + this.ln();
        msg = msg + "    " + this.ln();
        msg = msg + "Or else if you DON'T use 'union()' or 'unionAll()', This is the Framework Exception!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Column]" + this.ln();
        msg = msg + columnName + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Internal Object]" + this.ln();
        msg = msg + "selectClauseRealColumnAliasMap=" + selectClauseRealColumnAliasMap + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public boolean isAsc() {
        if (this._ascDesc == null) {
            String msg = "The attribute[ascDesc] should not be null.";
            throw new IllegalStateException(msg);
        }
        if (this._ascDesc.equals("asc")) {
            return true;
        }
        if (this._ascDesc.equals("desc")) {
            return false;
        }
        String msg = "The attribute[ascDesc] should be asc or desc: but ascDesc=" + this._ascDesc;
        throw new IllegalStateException(msg);
    }

    public String getColumnFullName() {
        StringBuilder sb = new StringBuilder();
        if (this._aliasName != null) {
            sb.append(this._aliasName).append(".");
        }
        if (this._columnName == null) {
            String msg = "The attribute[columnName] should not be null.";
            throw new IllegalStateException(msg);
        }
        sb.append(this._columnName);
        return sb.toString();
    }

    protected String decryptIfNeeds(ColumnInfo columnInfo, String valueExp) {
        if (this._gearedCipherManager == null) {
            return valueExp;
        }
        ColumnFunctionCipher cipher = this._gearedCipherManager.findColumnFunctionCipher(columnInfo);
        return cipher != null ? cipher.decrypt(valueExp) : valueExp;
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        StringBuilder sb = new StringBuilder();
        sb.append(title).append(":");
        sb.append("{aliasName=").append(this._aliasName);
        sb.append(" columnName=").append(this._columnName);
        sb.append(" ascDesc=").append(this._ascDesc);
        sb.append("}");
        return sb.toString();
    }

    public String getAliasName() {
        return this._aliasName;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public ColumnInfo getColumnInfo() {
        return this._columnInfo;
    }

    public boolean isDerivedOrderBy() {
        return this._derivedOrderBy;
    }

    public String getAscDesc() {
        return this._ascDesc;
    }

    public void setGearedCipherManager(GearedCipherManager gearedCipherManager) {
        this._gearedCipherManager = gearedCipherManager;
    }

    public void setOrderByNullsSetupper(OrderByClause.OrderByNullsSetupper value, boolean nullsFirst) {
        this._orderByNullsSetupper = value;
        this._nullsFirst = nullsFirst;
    }

    public void setManualOrderBean(ManualOrderBean mob) {
        this._mob = mob;
    }

    public ManualOrderBean getManualOrderBean() {
        return this._mob;
    }
}

