/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.exception.factory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.dbflute.resource.DBFluteSystem;

public class ExceptionMessageBuilder {
    protected final List<String> _noticeList = new ArrayList<String>(2);
    protected final Map<String, List<Object>> _elementMap = new LinkedHashMap<String, List<Object>>(8);
    protected List<Object> _currentList;

    public void addNotice(String notice) {
        this._noticeList.add(notice);
    }

    public ExceptionMessageBuilder addItem(String item) {
        this._currentList = new ArrayList<Object>(4);
        this._elementMap.put(item, this._currentList);
        return this;
    }

    public ExceptionMessageBuilder addElement(Object element) {
        if (this._currentList == null) {
            this.addItem("*No Title");
        }
        this._currentList.add(element);
        return this;
    }

    public String buildExceptionMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Look! Read the message below.").append(this.ln());
        sb.append("/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *").append(this.ln());
        if (!this._noticeList.isEmpty()) {
            for (String notice : this._noticeList) {
                sb.append(notice).append(this.ln());
            }
        } else {
            sb.append("*No Notice").append(this.ln());
        }
        Set<Map.Entry<String, List<Object>>> entrySet = this._elementMap.entrySet();
        for (Map.Entry<String, List<Object>> entry : entrySet) {
            String item = entry.getKey();
            sb.append(this.ln());
            sb.append("[").append(item).append("]").append(this.ln());
            List<Object> elementList = entry.getValue();
            for (Object element : elementList) {
                sb.append(element).append(this.ln());
            }
        }
        sb.append("* * * * * * * * * */");
        return sb.toString();
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }
}

